/*
 Navicat Premium Data Transfer

 Source Server         : eldb.elitescloud.com_3306
 Source Server Type    : MySQL
 Source Server Version : 50732
 Source Host           : eldb.elitescloud.com:3306
 Source Schema         : yst_cbpl_support_tm

 Target Server Type    : Oracle
 Target Server Version : 120100
 File Encoding         : 65001

 Date: 07/06/2022 14:26:30
*/


-- ----------------------------
-- Table structure for com_city_code
-- ----------------------------
CREATE TABLE com_city_code (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  area_name NVARCHAR2(40) NOT NULL,
  area_code NVARCHAR2(40) NOT NULL,
  area_type NVARCHAR2(40),
  short_name NVARCHAR2(40),
  english_name NVARCHAR2(40),
  area_level NVARCHAR2(40),
  pid NUMBER(20) NOT NULL,
  area_status NVARCHAR2(40),
  area_spell NVARCHAR2(40),
  area_shspell NVARCHAR2(40),
  tel_head NVARCHAR2(40),
  zip_code NVARCHAR2(40),
  area_desc NVARCHAR2(255),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN com_city_code.id IS '记录唯一ID';
COMMENT ON COLUMN com_city_code.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN com_city_code.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN com_city_code.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN com_city_code.area_name IS '区域名称';
COMMENT ON COLUMN com_city_code.area_code IS '区域代码';
COMMENT ON COLUMN com_city_code.area_type IS '区域类型';
COMMENT ON COLUMN com_city_code.short_name IS '区域简称';
COMMENT ON COLUMN com_city_code.english_name IS '英文名称';
COMMENT ON COLUMN com_city_code.area_level IS '区域等级';
COMMENT ON COLUMN com_city_code.pid IS '上级ID';
COMMENT ON COLUMN com_city_code.area_status IS '地址状态';
COMMENT ON COLUMN com_city_code.area_spell IS '汉语拼音';
COMMENT ON COLUMN com_city_code.area_shspell IS '拼音首字母';
COMMENT ON COLUMN com_city_code.tel_head IS '区号';
COMMENT ON COLUMN com_city_code.zip_code IS '邮编';
COMMENT ON COLUMN com_city_code.area_desc IS '区域描述';
COMMENT ON COLUMN com_city_code.tenant_id IS '租户ID';
COMMENT ON COLUMN com_city_code.remark IS '备注';
COMMENT ON COLUMN com_city_code.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN com_city_code.creator IS '记录创建者';
COMMENT ON COLUMN com_city_code.create_time IS '记录创建时间';
COMMENT ON COLUMN com_city_code.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN com_city_code.updater IS '记录最后更新者';
COMMENT ON COLUMN com_city_code.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN com_city_code.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN com_city_code.audit_data_version IS '锁版本';
COMMENT ON TABLE com_city_code IS '区域定义';

-- ----------------------------
-- Table structure for com_currency
-- ----------------------------
CREATE TABLE com_currency (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  ou_id NUMBER(20),
  curr_code NVARCHAR2(40) NOT NULL,
  curr_name NVARCHAR2(40) NOT NULL,
  disp_decimal NUMBER(11),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN com_currency.id IS '记录唯一ID';
COMMENT ON COLUMN com_currency.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN com_currency.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN com_currency.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN com_currency.ou_id IS '公司ID';
COMMENT ON COLUMN com_currency.curr_code IS '币种编号';
COMMENT ON COLUMN com_currency.curr_name IS '币种名称';
COMMENT ON COLUMN com_currency.disp_decimal IS '显示小数位数';
COMMENT ON COLUMN com_currency.tenant_id IS '租户ID';
COMMENT ON COLUMN com_currency.remark IS '备注';
COMMENT ON COLUMN com_currency.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN com_currency.creator IS '记录创建者';
COMMENT ON COLUMN com_currency.create_time IS '记录创建时间';
COMMENT ON COLUMN com_currency.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN com_currency.updater IS '记录最后更新者';
COMMENT ON COLUMN com_currency.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN com_currency.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN com_currency.audit_data_version IS '锁版本';
COMMENT ON TABLE com_currency IS '币种';

-- ----------------------------
-- Records of com_currency
-- ----------------------------



-- ----------------------------
-- Table structure for com_file
-- ----------------------------
CREATE TABLE com_file (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  file_code NVARCHAR2(255),
  original_name NVARCHAR2(255),
  file_size NUMBER(20),
  suffix NVARCHAR2(255),
  mime_type NVARCHAR2(40),
  file_type NVARCHAR2(40),
  upload_time DATE,
  width NUMBER(11),
  height NUMBER(11),
  url_preview NVARCHAR2(255),
  url_download NVARCHAR2(255),
  url_delete NVARCHAR2(255),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN com_file.id IS '记录唯一ID';
COMMENT ON COLUMN com_file.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN com_file.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN com_file.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN com_file.file_code IS '文件编码，文件服务器上的文件唯一标识';
COMMENT ON COLUMN com_file.original_name IS '文件原名称';
COMMENT ON COLUMN com_file.file_size IS '文件大小，字节B';
COMMENT ON COLUMN com_file.suffix IS '文件名后缀';
COMMENT ON COLUMN com_file.mime_type IS '文件内容类型，mime-type';
COMMENT ON COLUMN com_file.file_type IS '常见的文件类型（IMAGE-图片，AUDIO-音频，VIDEO-视频），为空则表示不常见';
COMMENT ON COLUMN com_file.upload_time IS '上传时间';
COMMENT ON COLUMN com_file.width IS '宽度，图片时有值';
COMMENT ON COLUMN com_file.height IS '高度，图片时有值';
COMMENT ON COLUMN com_file.url_preview IS '文件预览url';
COMMENT ON COLUMN com_file.url_download IS '文件下载url';
COMMENT ON COLUMN com_file.url_delete IS '文件删除url';
COMMENT ON COLUMN com_file.tenant_id IS '租户ID';
COMMENT ON COLUMN com_file.remark IS '备注';
COMMENT ON COLUMN com_file.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN com_file.creator IS '记录创建者';
COMMENT ON COLUMN com_file.create_time IS '记录创建时间';
COMMENT ON COLUMN com_file.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN com_file.updater IS '记录最后更新者';
COMMENT ON COLUMN com_file.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN com_file.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN com_file.audit_data_version IS '锁版本';
COMMENT ON TABLE com_file IS '文件上传记录';

-- ----------------------------
-- Records of com_file
-- ----------------------------



-- ----------------------------
-- Table structure for common_org_bu_treed
-- ----------------------------
CREATE TABLE common_org_bu_treed (
  id NUMBER(20) NOT NULL,
  pid NUMBER(20) NOT NULL,
  sort_no NUMBER(11),
  grade NUMBER(11),
  code_path NVARCHAR2(255),
  bu_tree_id NUMBER(20),
  bu_id NUMBER(20),
  bu_code NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20)
)
;
COMMENT ON COLUMN common_org_bu_treed.id IS '记录唯一ID';
COMMENT ON COLUMN common_org_bu_treed.pid IS '上级ID';
COMMENT ON COLUMN common_org_bu_treed.sort_no IS '排序号';
COMMENT ON COLUMN common_org_bu_treed.grade IS '层级';
COMMENT ON COLUMN common_org_bu_treed.code_path IS '树型结构编号全路径，使用/隔离';
COMMENT ON COLUMN common_org_bu_treed.bu_tree_id IS '组织树ID';
COMMENT ON COLUMN common_org_bu_treed.bu_id IS '组织ID';
COMMENT ON COLUMN common_org_bu_treed.tenant_id IS '租户ID';
COMMENT ON COLUMN common_org_bu_treed.remark IS '备注';
COMMENT ON COLUMN common_org_bu_treed.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN common_org_bu_treed.creator IS '记录创建者';
COMMENT ON COLUMN common_org_bu_treed.create_time IS '记录创建时间';
COMMENT ON COLUMN common_org_bu_treed.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN common_org_bu_treed.updater IS '记录最后更新者';
COMMENT ON COLUMN common_org_bu_treed.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN common_org_bu_treed.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN common_org_bu_treed.audit_data_version IS '锁版本';
COMMENT ON COLUMN common_org_bu_treed.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN common_org_bu_treed.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN common_org_bu_treed.sec_ou_id IS 'sec_ou_id';
COMMENT ON TABLE common_org_bu_treed IS '组织树明细';

-- ----------------------------
-- Records of common_org_bu_treed
-- ----------------------------



-- ----------------------------
-- Table structure for common_org_emp
-- ----------------------------
CREATE TABLE common_org_emp (
  id NUMBER(20) NOT NULL,
  pid NUMBER(20) NOT NULL,
  sort_no NUMBER(11),
  grade NUMBER(11),
  code_path NVARCHAR2(255),
  ou_id NUMBER(20),
  ou_code NVARCHAR2(40),
  ou_name NVARCHAR2(40),
  bu_id NUMBER(20),
  bu_code NVARCHAR2(40),
  bu_name NVARCHAR2(40),
  emp_bu_id NUMBER(20),
  emp_bu_tree_id NUMBER(20),
  emp_bu_treedid NUMBER(20),
  user_id NUMBER(20),
  user_name NVARCHAR2(40),
  emp_code NVARCHAR2(40),
  emp_name NVARCHAR2(40),
  emp_type NVARCHAR2(255),
  emp_type2 NVARCHAR2(40),
  emp_type3 NVARCHAR2(40),
  emp_status NVARCHAR2(40),
  foreign_name NVARCHAR2(40),
  addr_no NUMBER(20),
  emp_gender NVARCHAR2(40),
  birth_date DATE,
  email NVARCHAR2(40),
  mobile NVARCHAR2(40),
  id_type NVARCHAR2(40),
  id_no NVARCHAR2(255),
  emp_level NVARCHAR2(40),
  title NVARCHAR2(40),
  join_date DATE,
  jdy_flag NUMBER(11),
  leave_date DATE,
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20)
)
;
COMMENT ON COLUMN common_org_emp.id IS '记录唯一ID';
COMMENT ON COLUMN common_org_emp.pid IS '上级ID';
COMMENT ON COLUMN common_org_emp.sort_no IS '排序号';
COMMENT ON COLUMN common_org_emp.grade IS '层级';
COMMENT ON COLUMN common_org_emp.code_path IS '树型结构编号全路径，使用/隔离';
COMMENT ON COLUMN common_org_emp.ou_id IS '公司ID';
COMMENT ON COLUMN common_org_emp.ou_code IS '公司编号';
COMMENT ON COLUMN common_org_emp.ou_name IS '公司名称';
COMMENT ON COLUMN common_org_emp.bu_id IS 'BU ID';
COMMENT ON COLUMN common_org_emp.bu_code IS 'BU编号';
COMMENT ON COLUMN common_org_emp.bu_name IS 'BU名称';
COMMENT ON COLUMN common_org_emp.emp_bu_id IS '员工所属 BU ID';
COMMENT ON COLUMN common_org_emp.emp_bu_tree_id IS '员工所属BU树ID';
COMMENT ON COLUMN common_org_emp.emp_bu_treedid IS '员工所属BU树详情ID';
COMMENT ON COLUMN common_org_emp.user_id IS '用户id';
COMMENT ON COLUMN common_org_emp.user_name IS '用户名';
COMMENT ON COLUMN common_org_emp.emp_code IS '雇员编号';
COMMENT ON COLUMN common_org_emp.emp_name IS '雇员姓名';
COMMENT ON COLUMN common_org_emp.emp_type IS '员工类型 [UDC]ORG:EMP_TYPE';
COMMENT ON COLUMN common_org_emp.emp_type2 IS '员工类型2';
COMMENT ON COLUMN common_org_emp.emp_type3 IS '员工类型3';
COMMENT ON COLUMN common_org_emp.emp_status IS '员工状态 [UDC]ORG:EMP_STATUS';
COMMENT ON COLUMN common_org_emp.foreign_name IS '雇员外文名';
COMMENT ON COLUMN common_org_emp.addr_no IS '地址号';
COMMENT ON COLUMN common_org_emp.emp_gender IS '员工性别';
COMMENT ON COLUMN common_org_emp.birth_date IS '出生日期';
COMMENT ON COLUMN common_org_emp.email IS '工作邮箱';
COMMENT ON COLUMN common_org_emp.mobile IS '工作手机号';
COMMENT ON COLUMN common_org_emp.id_type IS '证件类型';
COMMENT ON COLUMN common_org_emp.id_no IS '证件号码';
COMMENT ON COLUMN common_org_emp.emp_level IS '职级';
COMMENT ON COLUMN common_org_emp.title IS '行政职位, [UDC]ORG:TITLE';
COMMENT ON COLUMN common_org_emp.join_date IS '入职日期';
COMMENT ON COLUMN common_org_emp.jdy_flag IS '是否同步激荡云,默认 1 ';
COMMENT ON COLUMN common_org_emp.leave_date IS '离职日期';
COMMENT ON COLUMN common_org_emp.tenant_id IS '租户ID';
COMMENT ON COLUMN common_org_emp.remark IS '备注';
COMMENT ON COLUMN common_org_emp.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN common_org_emp.creator IS '记录创建者';
COMMENT ON COLUMN common_org_emp.create_time IS '记录创建时间';
COMMENT ON COLUMN common_org_emp.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN common_org_emp.updater IS '记录最后更新者';
COMMENT ON COLUMN common_org_emp.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN common_org_emp.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN common_org_emp.audit_data_version IS '锁版本';
COMMENT ON COLUMN common_org_emp.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN common_org_emp.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN common_org_emp.sec_ou_id IS 'sec_ou_id';
COMMENT ON TABLE common_org_emp IS '员工';

-- ----------------------------
-- Table structure for cpcnt_attach
-- ----------------------------
CREATE TABLE cpcnt_attach (
  id NUMBER(20) NOT NULL,
  pay_type NVARCHAR2(40),
  app_id NVARCHAR2(40),
  auth_path NCLOB,
  relate_user_id NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  pay_way NVARCHAR2(40),
  binding_tx_sn2734 NVARCHAR2(40),
  relate_tx_no NVARCHAR2(40),
  src_doc_id NUMBER(20),
  src_doc_no NVARCHAR2(40),
  category NVARCHAR2(40)
)
;
COMMENT ON COLUMN cpcnt_attach.id IS '记录唯一ID';
COMMENT ON COLUMN cpcnt_attach.pay_type IS '支付类别';
COMMENT ON COLUMN cpcnt_attach.app_id IS 'jsapi';
COMMENT ON COLUMN cpcnt_attach.auth_path IS '当开通微信公众号支付时此字段必填';
COMMENT ON COLUMN cpcnt_attach.relate_user_id IS '来源用户id';
COMMENT ON COLUMN cpcnt_attach.tenant_id IS '租户ID';
COMMENT ON COLUMN cpcnt_attach.remark IS '备注';
COMMENT ON COLUMN cpcnt_attach.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN cpcnt_attach.creator IS '记录创建者';
COMMENT ON COLUMN cpcnt_attach.create_time IS '记录创建时间';
COMMENT ON COLUMN cpcnt_attach.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN cpcnt_attach.updater IS '记录最后更新者';
COMMENT ON COLUMN cpcnt_attach.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN cpcnt_attach.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN cpcnt_attach.audit_data_version IS '锁版本';
COMMENT ON COLUMN cpcnt_attach.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN cpcnt_attach.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN cpcnt_attach.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN cpcnt_attach.pay_way IS '支付方式';
COMMENT ON COLUMN cpcnt_attach.binding_tx_sn2734 IS '银行账户绑定流水号2734';
COMMENT ON COLUMN cpcnt_attach.relate_tx_no IS '主表流水号';
COMMENT ON COLUMN cpcnt_attach.src_doc_id IS '来源单据ID';
COMMENT ON COLUMN cpcnt_attach.src_doc_no IS '来源单据编号';
COMMENT ON COLUMN cpcnt_attach.category IS '行业类别';
COMMENT ON TABLE cpcnt_attach IS '中金支付方式实体类实体类';

-- ----------------------------
-- Records of cpcnt_attach
-- ----------------------------

-- ----------------------------
-- Table structure for cpcnt_bank
-- ----------------------------
CREATE TABLE cpcnt_bank (
  id NUMBER(20) NOT NULL,
  bank_id NVARCHAR2(40),
  bank_name NVARCHAR2(100),
  es1 NVARCHAR2(40),
  es2 NVARCHAR2(40),
  es3 NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20)
)
;
COMMENT ON COLUMN cpcnt_bank.id IS '记录唯一ID';
COMMENT ON COLUMN cpcnt_bank.bank_id IS '银行编码';
COMMENT ON COLUMN cpcnt_bank.bank_name IS '银行名称';
COMMENT ON COLUMN cpcnt_bank.es1 IS '备用es1';
COMMENT ON COLUMN cpcnt_bank.es2 IS '备用es2';
COMMENT ON COLUMN cpcnt_bank.es3 IS '备用es3';
COMMENT ON COLUMN cpcnt_bank.tenant_id IS '租户ID';
COMMENT ON COLUMN cpcnt_bank.remark IS '备注';
COMMENT ON COLUMN cpcnt_bank.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN cpcnt_bank.creator IS '记录创建者';
COMMENT ON COLUMN cpcnt_bank.create_time IS '记录创建时间';
COMMENT ON COLUMN cpcnt_bank.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN cpcnt_bank.updater IS '记录最后更新者';
COMMENT ON COLUMN cpcnt_bank.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN cpcnt_bank.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN cpcnt_bank.audit_data_version IS '锁版本';
COMMENT ON COLUMN cpcnt_bank.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN cpcnt_bank.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN cpcnt_bank.sec_ou_id IS 'sec_ou_id';
COMMENT ON TABLE cpcnt_bank IS '中金银行编码实体类';

-- ----------------------------
-- Records of cpcnt_bank
-- ----------------------------



-- ----------------------------
-- Table structure for cpcnt_category
-- ----------------------------
CREATE TABLE cpcnt_category (
  id NUMBER(20) NOT NULL,
  category_id NVARCHAR2(40),
  category_name NVARCHAR2(100),
  es1 NVARCHAR2(40),
  es2 NVARCHAR2(40),
  es3 NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20)
)
;
COMMENT ON COLUMN cpcnt_category.id IS '记录唯一ID';
COMMENT ON COLUMN cpcnt_category.category_id IS '分类类别编码';
COMMENT ON COLUMN cpcnt_category.category_name IS '分类类别名称';
COMMENT ON COLUMN cpcnt_category.es1 IS '备用es1';
COMMENT ON COLUMN cpcnt_category.es2 IS '备用es2';
COMMENT ON COLUMN cpcnt_category.es3 IS '备用es3';
COMMENT ON COLUMN cpcnt_category.tenant_id IS '租户ID';
COMMENT ON COLUMN cpcnt_category.remark IS '备注';
COMMENT ON COLUMN cpcnt_category.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN cpcnt_category.creator IS '记录创建者';
COMMENT ON COLUMN cpcnt_category.create_time IS '记录创建时间';
COMMENT ON COLUMN cpcnt_category.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN cpcnt_category.updater IS '记录最后更新者';
COMMENT ON COLUMN cpcnt_category.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN cpcnt_category.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN cpcnt_category.audit_data_version IS '锁版本';
COMMENT ON COLUMN cpcnt_category.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN cpcnt_category.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN cpcnt_category.sec_ou_id IS 'sec_ou_id';
COMMENT ON TABLE cpcnt_category IS '中金分类类别实体类';

-- ----------------------------
-- Records of cpcnt_category
-- ----------------------------

-- ----------------------------
-- Table structure for cpcnt_district
-- ----------------------------
CREATE TABLE cpcnt_district (
  id NUMBER(20) NOT NULL,
  district_id NVARCHAR2(40),
  parent_id NVARCHAR2(40),
  district_name NVARCHAR2(40),
  es1 NVARCHAR2(40),
  es2 NVARCHAR2(40),
  es3 NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20)
)
;
COMMENT ON COLUMN cpcnt_district.id IS '记录唯一ID';
COMMENT ON COLUMN cpcnt_district.district_id IS '市县区编码';
COMMENT ON COLUMN cpcnt_district.parent_id IS '父级id';
COMMENT ON COLUMN cpcnt_district.district_name IS '市县区名称';
COMMENT ON COLUMN cpcnt_district.es1 IS '备用es1';
COMMENT ON COLUMN cpcnt_district.es2 IS '备用es2';
COMMENT ON COLUMN cpcnt_district.es3 IS '备用es3';
COMMENT ON COLUMN cpcnt_district.tenant_id IS '租户ID';
COMMENT ON COLUMN cpcnt_district.remark IS '备注';
COMMENT ON COLUMN cpcnt_district.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN cpcnt_district.creator IS '记录创建者';
COMMENT ON COLUMN cpcnt_district.create_time IS '记录创建时间';
COMMENT ON COLUMN cpcnt_district.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN cpcnt_district.updater IS '记录最后更新者';
COMMENT ON COLUMN cpcnt_district.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN cpcnt_district.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN cpcnt_district.audit_data_version IS '锁版本';
COMMENT ON COLUMN cpcnt_district.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN cpcnt_district.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN cpcnt_district.sec_ou_id IS 'sec_ou_id';
COMMENT ON TABLE cpcnt_district IS '中金市县区编码实体类';

-- ----------------------------
-- Records of cpcnt_district
-- ----------------------------



-- ----------------------------
-- Table structure for cpcnt_image
-- ----------------------------
CREATE TABLE cpcnt_image (
  id NUMBER(20) NOT NULL,
  image_info NVARCHAR2(40),
  image_type NVARCHAR2(40),
  image_content NVARCHAR2(40),
  relate_user_id NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20)
)
;
COMMENT ON COLUMN cpcnt_image.id IS '记录唯一ID';
COMMENT ON COLUMN cpcnt_image.image_info IS '影印件明细';
COMMENT ON COLUMN cpcnt_image.image_type IS '影印件类别';
COMMENT ON COLUMN cpcnt_image.image_content IS '内容';
COMMENT ON COLUMN cpcnt_image.relate_user_id IS '来源用户id';
COMMENT ON COLUMN cpcnt_image.tenant_id IS '租户ID';
COMMENT ON COLUMN cpcnt_image.remark IS '备注';
COMMENT ON COLUMN cpcnt_image.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN cpcnt_image.creator IS '记录创建者';
COMMENT ON COLUMN cpcnt_image.create_time IS '记录创建时间';
COMMENT ON COLUMN cpcnt_image.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN cpcnt_image.updater IS '记录最后更新者';
COMMENT ON COLUMN cpcnt_image.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN cpcnt_image.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN cpcnt_image.audit_data_version IS '锁版本';
COMMENT ON COLUMN cpcnt_image.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN cpcnt_image.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN cpcnt_image.sec_ou_id IS 'sec_ou_id';
COMMENT ON TABLE cpcnt_image IS '中金影印象实体类';

-- ----------------------------
-- Records of cpcnt_image
-- ----------------------------



-- ----------------------------
-- Table structure for cpcnt_incoming_parts
-- ----------------------------
CREATE TABLE cpcnt_incoming_parts (
  id NUMBER(20) NOT NULL,
  dead_line NVARCHAR2(40),
  pay_type NVARCHAR2(40),
  pay_way NVARCHAR2(40),
  app_id NVARCHAR2(40),
  user_id NVARCHAR2(40),
  auth_path NVARCHAR2(40),
  src_doc_id NUMBER(20),
  src_doc_no NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  tx_code NVARCHAR2(40),
  tx_no NVARCHAR2(40),
  category NVARCHAR2(40),
  service_phone NVARCHAR2(40)
)
;
COMMENT ON COLUMN cpcnt_incoming_parts.id IS '记录唯一ID';
COMMENT ON COLUMN cpcnt_incoming_parts.dead_line IS '交易编码';
COMMENT ON COLUMN cpcnt_incoming_parts.pay_type IS '支付类别';
COMMENT ON COLUMN cpcnt_incoming_parts.pay_way IS '支付方式';
COMMENT ON COLUMN cpcnt_incoming_parts.app_id IS 'jsapi';
COMMENT ON COLUMN cpcnt_incoming_parts.user_id IS '用户id';
COMMENT ON COLUMN cpcnt_incoming_parts.auth_path IS '当开通微信公众号支付时此字段必填';
COMMENT ON COLUMN cpcnt_incoming_parts.src_doc_id IS '来源单据ID';
COMMENT ON COLUMN cpcnt_incoming_parts.src_doc_no IS '来源单据编号';
COMMENT ON COLUMN cpcnt_incoming_parts.tenant_id IS '租户ID';
COMMENT ON COLUMN cpcnt_incoming_parts.remark IS '备注';
COMMENT ON COLUMN cpcnt_incoming_parts.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN cpcnt_incoming_parts.creator IS '记录创建者';
COMMENT ON COLUMN cpcnt_incoming_parts.create_time IS '记录创建时间';
COMMENT ON COLUMN cpcnt_incoming_parts.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN cpcnt_incoming_parts.updater IS '记录最后更新者';
COMMENT ON COLUMN cpcnt_incoming_parts.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN cpcnt_incoming_parts.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN cpcnt_incoming_parts.audit_data_version IS '锁版本';
COMMENT ON COLUMN cpcnt_incoming_parts.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN cpcnt_incoming_parts.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN cpcnt_incoming_parts.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN cpcnt_incoming_parts.tx_code IS '交易编码';
COMMENT ON COLUMN cpcnt_incoming_parts.tx_no IS '银行账户绑定流水号2734';
COMMENT ON COLUMN cpcnt_incoming_parts.category IS '行业类别';
COMMENT ON COLUMN cpcnt_incoming_parts.service_phone IS '客服电话';
COMMENT ON TABLE cpcnt_incoming_parts IS '中金进件确认实体类';

-- ----------------------------
-- Records of cpcnt_incoming_parts
-- ----------------------------



-- ----------------------------
-- Table structure for cpcnt_industry
-- ----------------------------
CREATE TABLE cpcnt_industry (
  id NUMBER(20) NOT NULL,
  industry_id NVARCHAR2(40),
  industry_name NVARCHAR2(100),
  es1 NVARCHAR2(40),
  es2 NVARCHAR2(40),
  es3 NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20)
)
;
COMMENT ON COLUMN cpcnt_industry.id IS '记录唯一ID';
COMMENT ON COLUMN cpcnt_industry.industry_id IS '行业编码';
COMMENT ON COLUMN cpcnt_industry.industry_name IS '行业名称';
COMMENT ON COLUMN cpcnt_industry.es1 IS '备用es1';
COMMENT ON COLUMN cpcnt_industry.es2 IS '备用es2';
COMMENT ON COLUMN cpcnt_industry.es3 IS '备用es3';
COMMENT ON COLUMN cpcnt_industry.tenant_id IS '租户ID';
COMMENT ON COLUMN cpcnt_industry.remark IS '备注';
COMMENT ON COLUMN cpcnt_industry.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN cpcnt_industry.creator IS '记录创建者';
COMMENT ON COLUMN cpcnt_industry.create_time IS '记录创建时间';
COMMENT ON COLUMN cpcnt_industry.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN cpcnt_industry.updater IS '记录最后更新者';
COMMENT ON COLUMN cpcnt_industry.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN cpcnt_industry.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN cpcnt_industry.audit_data_version IS '锁版本';
COMMENT ON COLUMN cpcnt_industry.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN cpcnt_industry.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN cpcnt_industry.sec_ou_id IS 'sec_ou_id';
COMMENT ON TABLE cpcnt_industry IS '中金通用行业代码实体类';

-- ----------------------------
-- Records of cpcnt_industry
-- ----------------------------



-- ----------------------------
-- Table structure for cpcnt_industry_type
-- ----------------------------
CREATE TABLE cpcnt_industry_type (
  id NUMBER(20) NOT NULL,
  industry_type_id NVARCHAR2(40),
  industry_type_name NVARCHAR2(100),
  es1 NVARCHAR2(40),
  es2 NVARCHAR2(40),
  es3 NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20)
)
;
COMMENT ON COLUMN cpcnt_industry_type.id IS '记录唯一ID';
COMMENT ON COLUMN cpcnt_industry_type.industry_type_id IS '行业编码';
COMMENT ON COLUMN cpcnt_industry_type.industry_type_name IS '行业名称';
COMMENT ON COLUMN cpcnt_industry_type.es1 IS '备用es1';
COMMENT ON COLUMN cpcnt_industry_type.es2 IS '备用es2';
COMMENT ON COLUMN cpcnt_industry_type.es3 IS '备用es3';
COMMENT ON COLUMN cpcnt_industry_type.tenant_id IS '租户ID';
COMMENT ON COLUMN cpcnt_industry_type.remark IS '备注';
COMMENT ON COLUMN cpcnt_industry_type.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN cpcnt_industry_type.creator IS '记录创建者';
COMMENT ON COLUMN cpcnt_industry_type.create_time IS '记录创建时间';
COMMENT ON COLUMN cpcnt_industry_type.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN cpcnt_industry_type.updater IS '记录最后更新者';
COMMENT ON COLUMN cpcnt_industry_type.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN cpcnt_industry_type.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN cpcnt_industry_type.audit_data_version IS '锁版本';
COMMENT ON COLUMN cpcnt_industry_type.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN cpcnt_industry_type.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN cpcnt_industry_type.sec_ou_id IS 'sec_ou_id';
COMMENT ON TABLE cpcnt_industry_type IS '中金行业代码实体类';

-- ----------------------------
-- Records of cpcnt_industry_type
-- ----------------------------



-- ----------------------------
-- Table structure for cpcnt_merchant
-- ----------------------------
CREATE TABLE cpcnt_merchant (
  id NUMBER(20) NOT NULL,
  merchant_id NVARCHAR2(40),
  merchant_name NVARCHAR2(40),
  merchant_type NVARCHAR2(100),
  es1 NVARCHAR2(40),
  es2 NVARCHAR2(40),
  es3 NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20)
)
;
COMMENT ON COLUMN cpcnt_merchant.id IS '记录唯一ID';
COMMENT ON COLUMN cpcnt_merchant.merchant_id IS '行业代码';
COMMENT ON COLUMN cpcnt_merchant.merchant_name IS '行业描述';
COMMENT ON COLUMN cpcnt_merchant.merchant_type IS '支付类别';
COMMENT ON COLUMN cpcnt_merchant.es1 IS '备用es1';
COMMENT ON COLUMN cpcnt_merchant.es2 IS '备用es2';
COMMENT ON COLUMN cpcnt_merchant.es3 IS '备用es3';
COMMENT ON COLUMN cpcnt_merchant.tenant_id IS '租户ID';
COMMENT ON COLUMN cpcnt_merchant.remark IS '备注';
COMMENT ON COLUMN cpcnt_merchant.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN cpcnt_merchant.creator IS '记录创建者';
COMMENT ON COLUMN cpcnt_merchant.create_time IS '记录创建时间';
COMMENT ON COLUMN cpcnt_merchant.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN cpcnt_merchant.updater IS '记录最后更新者';
COMMENT ON COLUMN cpcnt_merchant.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN cpcnt_merchant.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN cpcnt_merchant.audit_data_version IS '锁版本';
COMMENT ON COLUMN cpcnt_merchant.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN cpcnt_merchant.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN cpcnt_merchant.sec_ou_id IS 'sec_ou_id';
COMMENT ON TABLE cpcnt_merchant IS '中金商户进件行业类别代码实体类';

-- ----------------------------
-- Records of cpcnt_merchant
-- ----------------------------



-- ----------------------------
-- Table structure for cpcnt_province
-- ----------------------------
CREATE TABLE cpcnt_province (
  id NUMBER(20) NOT NULL,
  province_id NVARCHAR2(40),
  province_name NVARCHAR2(40),
  es1 NVARCHAR2(40),
  es2 NVARCHAR2(40),
  es3 NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20)
)
;
COMMENT ON COLUMN cpcnt_province.id IS '记录唯一ID';
COMMENT ON COLUMN cpcnt_province.province_id IS '省份编码';
COMMENT ON COLUMN cpcnt_province.province_name IS '省份名称';
COMMENT ON COLUMN cpcnt_province.es1 IS '备用es1';
COMMENT ON COLUMN cpcnt_province.es2 IS '备用es2';
COMMENT ON COLUMN cpcnt_province.es3 IS '备用es3';
COMMENT ON COLUMN cpcnt_province.tenant_id IS '租户ID';
COMMENT ON COLUMN cpcnt_province.remark IS '备注';
COMMENT ON COLUMN cpcnt_province.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN cpcnt_province.creator IS '记录创建者';
COMMENT ON COLUMN cpcnt_province.create_time IS '记录创建时间';
COMMENT ON COLUMN cpcnt_province.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN cpcnt_province.updater IS '记录最后更新者';
COMMENT ON COLUMN cpcnt_province.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN cpcnt_province.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN cpcnt_province.audit_data_version IS '锁版本';
COMMENT ON COLUMN cpcnt_province.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN cpcnt_province.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN cpcnt_province.sec_ou_id IS 'sec_ou_id';
COMMENT ON TABLE cpcnt_province IS '中金省份编码实体类';

-- ----------------------------
-- Records of cpcnt_province
-- ----------------------------



-- ----------------------------
-- Table structure for cpcnt_request
-- ----------------------------
CREATE TABLE cpcnt_request (
  id NUMBER(20) NOT NULL,
  dead_line NVARCHAR2(40),
  institution_id NVARCHAR2(40),
  binding_tx_sn4611 NVARCHAR2(40),
  binding_tx_sn4601 NVARCHAR2(40),
  binding_tx_sn7703 NVARCHAR2(40),
  binding_tx_sn2734 NVARCHAR2(40),
  user_id NVARCHAR2(40),
  payee_user_id NVARCHAR2(40),
  acceptance_confirmtype NVARCHAR2(40),
  bank_card_type NVARCHAR2(40),
  operation_flag NVARCHAR2(40),
  upgrade_txsn NVARCHAR2(40),
  binding_way NVARCHAR2(40),
  credential_type NVARCHAR2(40),
  credential_number NVARCHAR2(40),
  credential_address NVARCHAR2(40),
  bank_id NVARCHAR2(40),
  bank_account_type NVARCHAR2(40),
  bank_account_name NVARCHAR2(40),
  bank_account_number NVARCHAR2(40),
  bank_phone_number NVARCHAR2(40),
  cnaps_code NVARCHAR2(40),
  branch_name NVARCHAR2(40),
  province NVARCHAR2(40),
  city NVARCHAR2(40),
  district NVARCHAR2(40),
  valid_date DATE,
  cv_n2 NVARCHAR2(40),
  transfer_charge_flag NVARCHAR2(40),
  notice_url NVARCHAR2(40),
  verify_way NVARCHAR2(40),
  sms_code NVARCHAR2(40),
  amount NUMBER,
  business_type NVARCHAR2(255),
  user_type NVARCHAR2(40),
  image_info NVARCHAR2(40),
  image_type NVARCHAR2(40),
  image_collection_tx_sn NVARCHAR2(40),
  apply_no NVARCHAR2(40),
  protocol_number NVARCHAR2(40),
  protocol_signer_type NVARCHAR2(40),
  agent_phone_number NVARCHAR2(40),
  agent_name NVARCHAR2(40),
  agent_id_number NVARCHAR2(40),
  immediately_sign NVARCHAR2(40),
  pay_way NVARCHAR2(40),
  category NVARCHAR2(40),
  service_phone NVARCHAR2(40),
  platform_name NVARCHAR2(40),
  pay_type NVARCHAR2(40),
  app_id NVARCHAR2(40),
  auth_path NVARCHAR2(225),
  parent_userid NVARCHAR2(40),
  account_level NVARCHAR2(40),
  individual NVARCHAR2(40),
  phone_number NVARCHAR2(40),
  user_name NVARCHAR2(40),
  iss_date DATE,
  expiry_date DATE,
  ind_address NVARCHAR2(40),
  ind_email NVARCHAR2(40),
  occupation NVARCHAR2(40),
  corporation NVARCHAR2(40),
  corporation_name NVARCHAR2(40),
  corporation_short NVARCHAR2(40),
  category_type NVARCHAR2(40),
  cor_email NVARCHAR2(40),
  cor_address NVARCHAR2(40),
  industry_belong_type NVARCHAR2(40),
  industry NVARCHAR2(40),
  scale NVARCHAR2(40),
  basic_acctno NVARCHAR2(40),
  approval_no NVARCHAR2(40),
  auth_capital NUMBER,
  business_scope NVARCHAR2(40),
  cor_type NVARCHAR2(40),
  unified_social_credit_code NVARCHAR2(40),
  all_licence_iss_date DATE,
  all_licence_expiry_date DATE,
  legal_person_name NVARCHAR2(40),
  legal_credential_type NVARCHAR2(40),
  legal_credential_number NVARCHAR2(40),
  legal_person_iss_date DATE,
  legal_person_expiry_date DATE,
  legal_person_contact_number NVARCHAR2(40),
  legal_person_email NVARCHAR2(40),
  shareholder NVARCHAR2(40),
  controller NVARCHAR2(40),
  beneficiary NVARCHAR2(40),
  shareholder_part NVARCHAR2(40),
  shareholder_name NVARCHAR2(40),
  sh_credential_type NVARCHAR2(40),
  sh_credential_number NVARCHAR2(40),
  sh_person_iss_date DATE,
  sh_person_expiry_date DATE,
  retailer NVARCHAR2(40),
  manager_name NVARCHAR2(40),
  manager_credential_type NVARCHAR2(40),
  manager_credential_number NVARCHAR2(40),
  manager_iss_date DATE,
  manager_expiry_date DATE,
  manager_contact_number NVARCHAR2(40),
  manager_email NVARCHAR2(40),
  retailer_reg_number NVARCHAR2(40),
  retailer_name NVARCHAR2(40),
  retailer_license_iss_date DATE,
  retailer_license_expiry_date DATE,
  retailer_formation NVARCHAR2(40),
  retailer_address NVARCHAR2(40),
  retailer_province NVARCHAR2(40),
  retailer_city NVARCHAR2(40),
  retailer_district NVARCHAR2(40),
  retailer_business_scope NVARCHAR2(40),
  manager_credential_address NVARCHAR2(40),
  manager_occupation NVARCHAR2(40),
  bank_account NVARCHAR2(40),
  bank_province NVARCHAR2(40),
  bank_city NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  src_doc_id NUMBER(20),
  src_doc_no NVARCHAR2(40),
  current_page NVARCHAR2(40),
  image_status NVARCHAR2(40),
  auth_info NVARCHAR2(40),
  image_message NVARCHAR2(200),
  image_content NVARCHAR2(40)
)
;
COMMENT ON COLUMN cpcnt_request.id IS '记录唯一ID';
COMMENT ON COLUMN cpcnt_request.dead_line IS '交易编码';
COMMENT ON COLUMN cpcnt_request.institution_id IS '机构编号';
COMMENT ON COLUMN cpcnt_request.binding_tx_sn4611 IS '银行账户绑定流水号4611';
COMMENT ON COLUMN cpcnt_request.binding_tx_sn4601 IS '银行账户绑定流水号4601';
COMMENT ON COLUMN cpcnt_request.binding_tx_sn7703 IS '银行账户绑定流水号7703';
COMMENT ON COLUMN cpcnt_request.binding_tx_sn2734 IS '银行账户绑定流水号2734';
COMMENT ON COLUMN cpcnt_request.user_id IS '用户id';
COMMENT ON COLUMN cpcnt_request.payee_user_id IS '收款用户id';
COMMENT ON COLUMN cpcnt_request.acceptance_confirmtype IS '确权方式';
COMMENT ON COLUMN cpcnt_request.bank_card_type IS '卡类型';
COMMENT ON COLUMN cpcnt_request.operation_flag IS '操作标识';
COMMENT ON COLUMN cpcnt_request.upgrade_txsn IS '绑卡升级交易流水号';
COMMENT ON COLUMN cpcnt_request.binding_way IS '绑卡验证方式';
COMMENT ON COLUMN cpcnt_request.credential_type IS '证件类型';
COMMENT ON COLUMN cpcnt_request.credential_number IS '身份证号';
COMMENT ON COLUMN cpcnt_request.credential_address IS '身份证地址';
COMMENT ON COLUMN cpcnt_request.bank_id IS '绑定银行id';
COMMENT ON COLUMN cpcnt_request.bank_account_type IS '户类型:11=个人账户 12=企业账户';
COMMENT ON COLUMN cpcnt_request.bank_account_name IS '银行账户名称';
COMMENT ON COLUMN cpcnt_request.bank_account_number IS '银行账户号码';
COMMENT ON COLUMN cpcnt_request.bank_phone_number IS '银行卡预留手机号码';
COMMENT ON COLUMN cpcnt_request.cnaps_code IS '人民银行联行号';
COMMENT ON COLUMN cpcnt_request.branch_name IS '分支行名称';
COMMENT ON COLUMN cpcnt_request.province IS '省份';
COMMENT ON COLUMN cpcnt_request.city IS '城市';
COMMENT ON COLUMN cpcnt_request.district IS '区/县';
COMMENT ON COLUMN cpcnt_request.valid_date IS '统一社会信息证代码发证日';
COMMENT ON COLUMN cpcnt_request.cv_n2 IS '信用卡背面的末3位数字';
COMMENT ON COLUMN cpcnt_request.transfer_charge_flag IS '转账充值开通标识';
COMMENT ON COLUMN cpcnt_request.notice_url IS '后台通知地址';
COMMENT ON COLUMN cpcnt_request.verify_way IS '验证方式：10=短信验证	20=小额打款验证';
COMMENT ON COLUMN cpcnt_request.sms_code IS '短信验证码';
COMMENT ON COLUMN cpcnt_request.amount IS '打款金额';
COMMENT ON COLUMN cpcnt_request.business_type IS '业务类型';
COMMENT ON COLUMN cpcnt_request.user_type IS '用户类型： 11=个人 12=企业 13=个体户';
COMMENT ON COLUMN cpcnt_request.image_info IS '影印件明细';
COMMENT ON COLUMN cpcnt_request.image_type IS '影印件类别';
COMMENT ON COLUMN cpcnt_request.image_collection_tx_sn IS '影印件采集交易流水号';
COMMENT ON COLUMN cpcnt_request.apply_no IS '申请流水号';
COMMENT ON COLUMN cpcnt_request.protocol_number IS '协议模板编号';
COMMENT ON COLUMN cpcnt_request.protocol_signer_type IS '协议签署人类型';
COMMENT ON COLUMN cpcnt_request.agent_phone_number IS '经办人手机号';
COMMENT ON COLUMN cpcnt_request.agent_name IS '经办人姓名';
COMMENT ON COLUMN cpcnt_request.agent_id_number IS '经办人身份证号';
COMMENT ON COLUMN cpcnt_request.immediately_sign IS '立即签约 10-是 20-否';
COMMENT ON COLUMN cpcnt_request.pay_way IS '支付方式';
COMMENT ON COLUMN cpcnt_request.category IS '行业类别';
COMMENT ON COLUMN cpcnt_request.service_phone IS '客服电话';
COMMENT ON COLUMN cpcnt_request.platform_name IS '平台名称';
COMMENT ON COLUMN cpcnt_request.pay_type IS '支付类别';
COMMENT ON COLUMN cpcnt_request.app_id IS '当使用 jsapi、小程序时此字段必填';
COMMENT ON COLUMN cpcnt_request.auth_path IS '微信公众号支付';
COMMENT ON COLUMN cpcnt_request.parent_userid IS '归属父级用户 id';
COMMENT ON COLUMN cpcnt_request.account_level IS '账户层级';
COMMENT ON COLUMN cpcnt_request.individual IS '个人开户选择域';
COMMENT ON COLUMN cpcnt_request.phone_number IS '开户手机号码';
COMMENT ON COLUMN cpcnt_request.user_name IS '用户姓名';
COMMENT ON COLUMN cpcnt_request.iss_date IS '统一社会信息证代码发证日';
COMMENT ON COLUMN cpcnt_request.expiry_date IS '统一社会信息证代码发证日';
COMMENT ON COLUMN cpcnt_request.ind_address IS '联系地址';
COMMENT ON COLUMN cpcnt_request.ind_email IS '个人邮箱';
COMMENT ON COLUMN cpcnt_request.occupation IS '职业';
COMMENT ON COLUMN cpcnt_request.corporation IS '企业开户选择域';
COMMENT ON COLUMN cpcnt_request.corporation_name IS '企业名称';
COMMENT ON COLUMN cpcnt_request.corporation_short IS '客户简称';
COMMENT ON COLUMN cpcnt_request.category_type IS '分类类别';
COMMENT ON COLUMN cpcnt_request.cor_email IS '企业邮箱';
COMMENT ON COLUMN cpcnt_request.cor_address IS '企业地址';
COMMENT ON COLUMN cpcnt_request.industry_belong_type IS '行业代码';
COMMENT ON COLUMN cpcnt_request.industry IS '通用行业代码';
COMMENT ON COLUMN cpcnt_request.scale IS '企业规模';
COMMENT ON COLUMN cpcnt_request.basic_acctno IS '企业银行账户';
COMMENT ON COLUMN cpcnt_request.approval_no IS '开户许可证核准号';
COMMENT ON COLUMN cpcnt_request.auth_capital IS '注册资本，单位分';
COMMENT ON COLUMN cpcnt_request.business_scope IS '经营范围';
COMMENT ON COLUMN cpcnt_request.cor_type IS '企业类型';
COMMENT ON COLUMN cpcnt_request.unified_social_credit_code IS '统一社会信息证代码';
COMMENT ON COLUMN cpcnt_request.all_licence_iss_date IS '统一社会信息证代码发证日';
COMMENT ON COLUMN cpcnt_request.all_licence_expiry_date IS '统一社会信息证代码有效期';
COMMENT ON COLUMN cpcnt_request.legal_person_name IS '法人姓名';
COMMENT ON COLUMN cpcnt_request.legal_credential_type IS '证件类型：0-身份证';
COMMENT ON COLUMN cpcnt_request.legal_credential_number IS '法人证件号码';
COMMENT ON COLUMN cpcnt_request.legal_person_iss_date IS '统一社会信息证代码有效期';
COMMENT ON COLUMN cpcnt_request.legal_person_expiry_date IS '统一社会信息证代码有效期';
COMMENT ON COLUMN cpcnt_request.legal_person_contact_number IS '法人联系电话';
COMMENT ON COLUMN cpcnt_request.legal_person_email IS '法人邮箱';
COMMENT ON COLUMN cpcnt_request.shareholder IS '控股股东';
COMMENT ON COLUMN cpcnt_request.controller IS '实际控制人';
COMMENT ON COLUMN cpcnt_request.beneficiary IS '实际收益人';
COMMENT ON COLUMN cpcnt_request.shareholder_part IS '控股人域';
COMMENT ON COLUMN cpcnt_request.shareholder_name IS '控股股东姓名';
COMMENT ON COLUMN cpcnt_request.sh_credential_type IS '控股股东证件类型';
COMMENT ON COLUMN cpcnt_request.sh_credential_number IS '控股股东证件号码';
COMMENT ON COLUMN cpcnt_request.sh_person_iss_date IS '统一社会信息证代码发证日';
COMMENT ON COLUMN cpcnt_request.sh_person_expiry_date IS '统一社会信息证代码发证日';
COMMENT ON COLUMN cpcnt_request.retailer IS '个体户开户域';
COMMENT ON COLUMN cpcnt_request.manager_name IS '经营者姓名';
COMMENT ON COLUMN cpcnt_request.manager_credential_type IS '经营者证件类型：0-身份证';
COMMENT ON COLUMN cpcnt_request.manager_credential_number IS '经营者证件号码';
COMMENT ON COLUMN cpcnt_request.manager_iss_date IS '统一社会信息证代码发证日';
COMMENT ON COLUMN cpcnt_request.manager_expiry_date IS '统一社会信息证代码发证日';
COMMENT ON COLUMN cpcnt_request.manager_contact_number IS '经营者手机号码';
COMMENT ON COLUMN cpcnt_request.manager_email IS '经营者邮箱';
COMMENT ON COLUMN cpcnt_request.retailer_reg_number IS '个体工商注册号码';
COMMENT ON COLUMN cpcnt_request.retailer_name IS '个体工商字号';
COMMENT ON COLUMN cpcnt_request.retailer_license_iss_date IS '统一社会信息证代码发证日';
COMMENT ON COLUMN cpcnt_request.retailer_license_expiry_date IS '统一社会信息证代码发证日';
COMMENT ON COLUMN cpcnt_request.retailer_formation IS '组成形式';
COMMENT ON COLUMN cpcnt_request.retailer_address IS '经营地址';
COMMENT ON COLUMN cpcnt_request.retailer_province IS '省份';
COMMENT ON COLUMN cpcnt_request.retailer_city IS '城市';
COMMENT ON COLUMN cpcnt_request.retailer_district IS '区/县';
COMMENT ON COLUMN cpcnt_request.retailer_business_scope IS '经营范围';
COMMENT ON COLUMN cpcnt_request.manager_credential_address IS '经营者身份证地址';
COMMENT ON COLUMN cpcnt_request.manager_occupation IS '经营者职业';
COMMENT ON COLUMN cpcnt_request.bank_account IS '绑定银行账户域';
COMMENT ON COLUMN cpcnt_request.bank_province IS '省份';
COMMENT ON COLUMN cpcnt_request.bank_city IS '城市';
COMMENT ON COLUMN cpcnt_request.tenant_id IS '租户ID';
COMMENT ON COLUMN cpcnt_request.remark IS '备注';
COMMENT ON COLUMN cpcnt_request.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN cpcnt_request.creator IS '记录创建者';
COMMENT ON COLUMN cpcnt_request.create_time IS '记录创建时间';
COMMENT ON COLUMN cpcnt_request.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN cpcnt_request.updater IS '记录最后更新者';
COMMENT ON COLUMN cpcnt_request.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN cpcnt_request.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN cpcnt_request.audit_data_version IS '锁版本';
COMMENT ON COLUMN cpcnt_request.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN cpcnt_request.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN cpcnt_request.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN cpcnt_request.src_doc_id IS '来源单据ID';
COMMENT ON COLUMN cpcnt_request.src_doc_no IS '来源单据编号';
COMMENT ON COLUMN cpcnt_request.current_page IS '当前页数';
COMMENT ON COLUMN cpcnt_request.image_status IS '影印件审核状态';
COMMENT ON COLUMN cpcnt_request.auth_info IS '影印件-10';
COMMENT ON COLUMN cpcnt_request.image_message IS '影印件审核结果通知消息';
COMMENT ON COLUMN cpcnt_request.image_content IS '影印件-10';
COMMENT ON TABLE cpcnt_request IS '中金支付请求实体类';

-- ----------------------------
-- Records of cpcnt_request
-- ----------------------------



-- ----------------------------
-- Table structure for cpcnt_response
-- ----------------------------
CREATE TABLE cpcnt_response (
  id NUMBER(20) NOT NULL,
  code NVARCHAR2(128),
  message NVARCHAR2(128),
  status NVARCHAR2(128),
  transfer_charge_status NVARCHAR2(40),
  dead_line NVARCHAR2(40),
  response_code NVARCHAR2(40),
  response_message NVARCHAR2(40),
  bank_redirct_form NVARCHAR2(40),
  available_veri_count NVARCHAR2(40),
  tx_sn NVARCHAR2(40),
  institution_id NVARCHAR2(40),
  user_id NVARCHAR2(40),
  dbank NVARCHAR2(40),
  eaccount_name NVARCHAR2(40),
  eaccount_number NVARCHAR2(40),
  binding_status NVARCHAR2(40),
  apply_no NVARCHAR2(40),
  response_time NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20)
)
;
COMMENT ON COLUMN cpcnt_response.id IS '记录唯一ID';
COMMENT ON COLUMN cpcnt_response.code IS '响应码';
COMMENT ON COLUMN cpcnt_response.message IS '响应消息';
COMMENT ON COLUMN cpcnt_response.status IS '状态';
COMMENT ON COLUMN cpcnt_response.transfer_charge_status IS '线下转账充值开通状态';
COMMENT ON COLUMN cpcnt_response.dead_line IS '打款截止日期';
COMMENT ON COLUMN cpcnt_response.response_code IS '响应码';
COMMENT ON COLUMN cpcnt_response.response_message IS '响应消息';
COMMENT ON COLUMN cpcnt_response.bank_redirct_form IS '一键绑卡行方跳转地址';
COMMENT ON COLUMN cpcnt_response.available_veri_count IS '剩余可验证次数';
COMMENT ON COLUMN cpcnt_response.tx_sn IS '交易流水号，同请求';
COMMENT ON COLUMN cpcnt_response.institution_id IS '机构编号';
COMMENT ON COLUMN cpcnt_response.user_id IS '用户 id';
COMMENT ON COLUMN cpcnt_response.dbank IS '银行存管';
COMMENT ON COLUMN cpcnt_response.eaccount_name IS '电子账户名称';
COMMENT ON COLUMN cpcnt_response.eaccount_number IS '电子账户号码';
COMMENT ON COLUMN cpcnt_response.binding_status IS '绑卡状态';
COMMENT ON COLUMN cpcnt_response.apply_no IS '申请流水号';
COMMENT ON COLUMN cpcnt_response.response_time IS '响应时间';
COMMENT ON COLUMN cpcnt_response.tenant_id IS '租户ID';
COMMENT ON COLUMN cpcnt_response.remark IS '备注';
COMMENT ON COLUMN cpcnt_response.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN cpcnt_response.creator IS '记录创建者';
COMMENT ON COLUMN cpcnt_response.create_time IS '记录创建时间';
COMMENT ON COLUMN cpcnt_response.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN cpcnt_response.updater IS '记录最后更新者';
COMMENT ON COLUMN cpcnt_response.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN cpcnt_response.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN cpcnt_response.audit_data_version IS '锁版本';
COMMENT ON COLUMN cpcnt_response.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN cpcnt_response.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN cpcnt_response.sec_ou_id IS 'sec_ou_id';
COMMENT ON TABLE cpcnt_response IS '中金支付响应实体类';

-- ----------------------------
-- Records of cpcnt_response
-- ----------------------------



-- ----------------------------
-- Table structure for flyway_schema_history
-- ----------------------------
CREATE TABLE flyway_schema_history (
  installed_rank NUMBER(11) NOT NULL,
  version NVARCHAR2(50),
  description NVARCHAR2(200) NOT NULL,
  type NVARCHAR2(20) NOT NULL,
  script NVARCHAR2(1000) NOT NULL,
  checksum NUMBER(11),
  installed_by NVARCHAR2(100) NOT NULL,
  installed_on DATE NOT NULL,
  execution_time NUMBER(11) NOT NULL,
  success NUMBER(4) NOT NULL
)
;

-- ----------------------------
-- Records of flyway_schema_history
-- ----------------------------



-- ----------------------------
-- Table structure for itm_brand
-- ----------------------------
CREATE TABLE itm_brand (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  brand_code NVARCHAR2(40),
  brand_name NVARCHAR2(40),
  brand_en_name NVARCHAR2(40),
  brand_initial NVARCHAR2(40),
  brand_agent NVARCHAR2(40),
  file_code NVARCHAR2(255),
  original_name NVARCHAR2(255),
  brand_party NVARCHAR2(40),
  brand_authorized NUMBER(11),
  brand_authorized_start_time DATE,
  brand_authorized_end_time DATE,
  status NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  url NVARCHAR2(256)
)
;
COMMENT ON COLUMN itm_brand.id IS '记录唯一ID';
COMMENT ON COLUMN itm_brand.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_brand.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_brand.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_brand.brand_code IS '品牌编码';
COMMENT ON COLUMN itm_brand.brand_name IS '品牌名称';
COMMENT ON COLUMN itm_brand.brand_en_name IS '品牌英文名';
COMMENT ON COLUMN itm_brand.brand_initial IS '品牌首字母';
COMMENT ON COLUMN itm_brand.brand_agent IS '品牌代理商';
COMMENT ON COLUMN itm_brand.file_code IS '品牌Logo文件编号';
COMMENT ON COLUMN itm_brand.original_name IS '品牌Logo文件名称';
COMMENT ON COLUMN itm_brand.brand_party IS '品牌方';
COMMENT ON COLUMN itm_brand.brand_authorized IS '品牌授权（0：否，1：是）';
COMMENT ON COLUMN itm_brand.brand_authorized_start_time IS '品牌授权开始时间';
COMMENT ON COLUMN itm_brand.brand_authorized_end_time IS '品牌授权结束时间';
COMMENT ON COLUMN itm_brand.status IS '品牌名称';
COMMENT ON COLUMN itm_brand.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_brand.remark IS '备注';
COMMENT ON COLUMN itm_brand.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_brand.creator IS '记录创建者';
COMMENT ON COLUMN itm_brand.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_brand.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_brand.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_brand.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_brand.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_brand.audit_data_version IS '锁版本';
COMMENT ON COLUMN itm_brand.url IS '图片url';
COMMENT ON TABLE itm_brand IS '品牌';

-- ----------------------------
-- Records of itm_brand
-- ----------------------------



-- ----------------------------
-- Table structure for itm_cate_contr_para
-- ----------------------------
CREATE TABLE itm_cate_contr_para (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  item_cate_code NVARCHAR2(32),
  param_code NVARCHAR2(32),
  param_name NVARCHAR2(32),
  param_value NVARCHAR2(32),
  sort_no NUMBER(11),
  status NVARCHAR2(8),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  price_group NVARCHAR2(40),
  price_group2 NVARCHAR2(40),
  price_group3 NVARCHAR2(40)
)
;
COMMENT ON COLUMN itm_cate_contr_para.id IS '记录唯一ID';
COMMENT ON COLUMN itm_cate_contr_para.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_cate_contr_para.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_cate_contr_para.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_cate_contr_para.item_cate_code IS '品类编码';
COMMENT ON COLUMN itm_cate_contr_para.param_code IS '管控参数编号';
COMMENT ON COLUMN itm_cate_contr_para.param_name IS '管控参数名称';
COMMENT ON COLUMN itm_cate_contr_para.param_value IS '参数值';
COMMENT ON COLUMN itm_cate_contr_para.sort_no IS '排序';
COMMENT ON COLUMN itm_cate_contr_para.status IS '状态';
COMMENT ON COLUMN itm_cate_contr_para.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_cate_contr_para.remark IS '备注';
COMMENT ON COLUMN itm_cate_contr_para.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_cate_contr_para.creator IS '记录创建者';
COMMENT ON COLUMN itm_cate_contr_para.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_cate_contr_para.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_cate_contr_para.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_cate_contr_para.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_cate_contr_para.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_cate_contr_para.audit_data_version IS '锁版本';
COMMENT ON COLUMN itm_cate_contr_para.price_group IS '产品段值码';
COMMENT ON COLUMN itm_cate_contr_para.price_group2 IS ' 财务商品分类码';
COMMENT ON COLUMN itm_cate_contr_para.price_group3 IS '费用类码';
COMMENT ON TABLE itm_cate_contr_para IS '品类管控参数';



-- ----------------------------
-- Table structure for itm_cate_prop
-- ----------------------------
CREATE TABLE itm_cate_prop (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  item_cate_code NVARCHAR2(40),
  cate_prop_code NVARCHAR2(40),
  cate_prop_name NVARCHAR2(40),
  cate_prop_type NVARCHAR2(40),
  is_box NUMBER(11),
  is_hand NUMBER(11),
  is_must NUMBER(11),
  is_sku NUMBER(11),
  sort_no NUMBER(11),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_cate_prop.id IS '记录唯一ID';
COMMENT ON COLUMN itm_cate_prop.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_cate_prop.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_cate_prop.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_cate_prop.item_cate_code IS '品类编码';
COMMENT ON COLUMN itm_cate_prop.cate_prop_code IS '属性名编码';
COMMENT ON COLUMN itm_cate_prop.cate_prop_name IS '属性名名称';
COMMENT ON COLUMN itm_cate_prop.cate_prop_type IS '属性类型';
COMMENT ON COLUMN itm_cate_prop.is_box IS '单选复选(0:单选,1:复选)';
COMMENT ON COLUMN itm_cate_prop.is_hand IS '录入方式(0:列表选择,1:手动输入)';
COMMENT ON COLUMN itm_cate_prop.is_must IS '是否必填(0:否,1:是)';
COMMENT ON COLUMN itm_cate_prop.is_sku IS '是否和SKU相关(0:否,1:是)';
COMMENT ON COLUMN itm_cate_prop.sort_no IS '排序号';
COMMENT ON COLUMN itm_cate_prop.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_cate_prop.remark IS '备注';
COMMENT ON COLUMN itm_cate_prop.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_cate_prop.creator IS '记录创建者';
COMMENT ON COLUMN itm_cate_prop.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_cate_prop.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_cate_prop.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_cate_prop.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_cate_prop.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_cate_prop.audit_data_version IS '锁版本';
COMMENT ON TABLE itm_cate_prop IS '品类属性key表';

-- ----------------------------
-- Records of itm_cate_prop
-- ----------------------------



-- ----------------------------
-- Table structure for itm_cate_prop_value
-- ----------------------------
CREATE TABLE itm_cate_prop_value (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  cate_prop_id NUMBER(20),
  prop_value_code NVARCHAR2(32),
  prop_value_name NVARCHAR2(32),
  prop_value_rank NUMBER(11),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_cate_prop_value.id IS '记录唯一ID';
COMMENT ON COLUMN itm_cate_prop_value.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_cate_prop_value.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_cate_prop_value.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_cate_prop_value.cate_prop_id IS '属性名ID';
COMMENT ON COLUMN itm_cate_prop_value.prop_value_code IS '属性值编码';
COMMENT ON COLUMN itm_cate_prop_value.prop_value_name IS '属性值名称';
COMMENT ON COLUMN itm_cate_prop_value.prop_value_rank IS '属性值排序';
COMMENT ON COLUMN itm_cate_prop_value.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_cate_prop_value.remark IS '备注';
COMMENT ON COLUMN itm_cate_prop_value.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_cate_prop_value.creator IS '记录创建者';
COMMENT ON COLUMN itm_cate_prop_value.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_cate_prop_value.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_cate_prop_value.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_cate_prop_value.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_cate_prop_value.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_cate_prop_value.audit_data_version IS '锁版本';
COMMENT ON TABLE itm_cate_prop_value IS '品类属性value表';

-- ----------------------------
-- Records of itm_cate_prop_value
-- ----------------------------



-- ----------------------------
-- Table structure for itm_combo_d
-- ----------------------------
CREATE TABLE itm_combo_d (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  item_combo_code NVARCHAR2(32),
  item_code NVARCHAR2(32),
  status NVARCHAR2(8),
  qty NUMBER,
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_combo_d.id IS '记录唯一ID';
COMMENT ON COLUMN itm_combo_d.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_combo_d.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_combo_d.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_combo_d.item_combo_code IS '组合商品编码';
COMMENT ON COLUMN itm_combo_d.item_code IS '商品编码';
COMMENT ON COLUMN itm_combo_d.status IS '状态';
COMMENT ON COLUMN itm_combo_d.qty IS '数量';
COMMENT ON COLUMN itm_combo_d.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_combo_d.remark IS '备注';
COMMENT ON COLUMN itm_combo_d.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_combo_d.creator IS '记录创建者';
COMMENT ON COLUMN itm_combo_d.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_combo_d.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_combo_d.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_combo_d.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_combo_d.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_combo_d.audit_data_version IS '锁版本';
COMMENT ON TABLE itm_combo_d IS '组合商品明细';

-- ----------------------------
-- Records of itm_combo_d
-- ----------------------------



-- ----------------------------
-- Table structure for itm_combo_tag
-- ----------------------------
CREATE TABLE itm_combo_tag (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  item_combo_code NVARCHAR2(32),
  tag_cate_code NVARCHAR2(32),
  tag_code NVARCHAR2(32),
  status NVARCHAR2(8),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_combo_tag.id IS '记录唯一ID';
COMMENT ON COLUMN itm_combo_tag.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_combo_tag.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_combo_tag.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_combo_tag.item_combo_code IS '组合商品编码';
COMMENT ON COLUMN itm_combo_tag.tag_cate_code IS '标签分类编码';
COMMENT ON COLUMN itm_combo_tag.tag_code IS '标签编码';
COMMENT ON COLUMN itm_combo_tag.status IS '状态';
COMMENT ON COLUMN itm_combo_tag.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_combo_tag.remark IS '备注';
COMMENT ON COLUMN itm_combo_tag.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_combo_tag.creator IS '记录创建者';
COMMENT ON COLUMN itm_combo_tag.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_combo_tag.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_combo_tag.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_combo_tag.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_combo_tag.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_combo_tag.audit_data_version IS '锁版本';
COMMENT ON TABLE itm_combo_tag IS '组合商品标签';

-- ----------------------------
-- Records of itm_combo_tag
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item
-- ----------------------------
CREATE TABLE ITM_ITEM
(
    ID                       NUMBER(20) NOT NULL,
    OU_ID                    NUMBER(20),
    OU_CODE                  NVARCHAR2(40),
    OU_NAME                  NVARCHAR2(40),
    BU_ID                    NUMBER(20),
    BU_CODE                  NVARCHAR2(40),
    BU_NAME                  NVARCHAR2(40),
    ITEM_CODE                NVARCHAR2(40),
    ITEM_CODE2               NVARCHAR2(40),
    ITEM_CODE3               NVARCHAR2(40),
    ITEM_NAME                NVARCHAR2(255),
    ITEM_NAME2               NVARCHAR2(255),
    ITEM_NAME3               NVARCHAR2(255),
    ITEM_ABBR                NVARCHAR2(40),
    ITEM_TYPE                NVARCHAR2(40),
    ITEM_TYPE2               NVARCHAR2(40),
    ITEM_TYPE3               NVARCHAR2(40),
    ITEM_TYPE4               NVARCHAR2(40),
    ITEM_TYPE5               NVARCHAR2(40),
    ITEM_STATUS              NVARCHAR2(40),
    ITEM_STATUS2             NVARCHAR2(40),
    ITEM_STATUS3             NVARCHAR2(40),
    SPEC                     NVARCHAR2(255),
    SPU_ID                   NUMBER(20),
    SPU_CODE                 NVARCHAR2(40),
    SPU_CODE2                NVARCHAR2(40),
    SPU_CODE3                NVARCHAR2(40),
    SPU_NAME                 NVARCHAR2(255),
    SPU_NAME2                NVARCHAR2(255),
    SPU_NAME3                NVARCHAR2(255),
    SPU_ABBR                 NVARCHAR2(40),
    ITEM_ATTR                NVARCHAR2(255),
    ITEM_ATTR2               NVARCHAR2(40),
    ITEM_ATTR3               NVARCHAR2(40),
    ITEM_ATTR4               NVARCHAR2(40),
    ITEM_ATTR5               NVARCHAR2(40),
    ITEM_CATE_CODE           NVARCHAR2(40),
    ITEM_CATE_CODE2          NVARCHAR2(40),
    ITEM_CATE_CODE3          NVARCHAR2(40),
    ITEM_SOURCE              NVARCHAR2(40),
    BRAND                    NVARCHAR2(40),
    BRAND2                   NVARCHAR2(40),
    RELEASE_FLAG             NUMBER(11),
    SALEPURC_FLAG            NUMBER(11),
    SN_FLAG                  NUMBER(11),
    LOT_FLAG                 NUMBER(11),
    GUARANTEE_FLAG           NUMBER(11),
    MEMBERDISC_FLAGX         NUMBER(11),
    DISTRIBUTION_FLAGX       NUMBER(11),
    FIN_TYPE                 NVARCHAR2(40),
    COST_TYPE                NVARCHAR2(40),
    ALLOC_TYPE               NVARCHAR2(40),
    DELIVER_TYPE             NVARCHAR2(40),
    AFTERSALES_SERVICE_FLAGX NUMBER(11),
    INSTALL_FLAG             NUMBER(11),
    RETURN_EXCHANGE_FLAG     NUMBER(11),
    RETURN_EXCHANGE_POLICY   NVARCHAR2(40),
    WARRANTY_FLAG            NUMBER(11),
    WARRANTY_PERIOD          NUMBER(11),
    WARRANTY_PERIOD_UNIT     NVARCHAR2(40),
    TRANS_CONDITION          NVARCHAR2(40),
    STORE_CONDITION          NVARCHAR2(40),
    PACKAGE_SPEC             NVARCHAR2(40),
    GUARANTEE_PERIOD         NUMBER(11),
    GUARANTEE_PERIOD_UNIT    NVARCHAR2(40),
    GUARANTEE_DAYS           NUMBER(11),
    TAX_TYPE                 NVARCHAR2(40),
    TAX_CODE                 NVARCHAR2(40),
    TAX_RATE                 NUMBER,
    TAX_RATE_NO              NVARCHAR2(40),
    TAX_CODE2                NVARCHAR2(40),
    TAX_RATE2                NUMBER,
    TAX_RATE_NO2             NVARCHAR2(40),
    TAX_RATE_TARIFF          NUMBER,
    SUPP_ID                  NUMBER(20),
    SUPP_CODE                NVARCHAR2(40),
    SUPP_ABBR                NVARCHAR2(40),
    SUPP_NAME                NVARCHAR2(40),
    SUPP_ITEM_CODE           NVARCHAR2(40),
    BAR_CODE                 NVARCHAR2(40),
    BAR_CODE2                NVARCHAR2(40),
    UOM                      NVARCHAR2(40),
    UOM2                     NVARCHAR2(40),
    UOM3                     NVARCHAR2(40),
    UOM4                     NVARCHAR2(40),
    UOM5                     NVARCHAR2(40),
    SALE_UOM                 NVARCHAR2(40),
    PURC_UOM                 NVARCHAR2(40),
    SHIP_UOM                 NVARCHAR2(40),
    ORDER_UOM                NVARCHAR2(40),
    PRICING_UOM              NVARCHAR2(40),
    STORE_UOM                NVARCHAR2(40),
    GROSS_WEIGHT             NUMBER,
    NET_WEIGHT               NUMBER,
    WEIGHT_UNIT              NVARCHAR2(40),
    WEIGHT_ITEM_UOM          NVARCHAR2(40),
    VOLUME                   NUMBER,
    VOLUME_UNIT              NVARCHAR2(40),
    LENGTH                   NUMBER,
    WIDTH                    NUMBER,
    HEIGHT                   NUMBER,
    LENGTH_UNIT              NVARCHAR2(40),
    MOQ                      NUMBER,
    SAFE_QTY                 NUMBER,
    MAX_ORDER_QTY            NUMBER,
    TAGS                     NVARCHAR2(255),
    OUTER_CODE               NVARCHAR2(40),
    OUTER_CODE2              NVARCHAR2(40),
    CAT                      NVARCHAR2(40),
    CAT2                     NVARCHAR2(40),
    CAT3                     NVARCHAR2(40),
    CAT4                     NVARCHAR2(40),
    CAT5                     NVARCHAR2(40),
    CAT6                     NVARCHAR2(40),
    CAT7                     NVARCHAR2(40),
    CAT8                     NVARCHAR2(40),
    CAT9                     NVARCHAR2(40),
    CAT10                    NVARCHAR2(40),
    ES1                      NVARCHAR2(40),
    ES2                      NVARCHAR2(40),
    ES3                      NVARCHAR2(40),
    ES4                      NVARCHAR2(40),
    ES5                      NVARCHAR2(40),
    ES6                      NVARCHAR2(40),
    ES7                      NVARCHAR2(40),
    ES8                      NVARCHAR2(40),
    ES9                      NVARCHAR2(40),
    ES10                     NVARCHAR2(40),
    EN1                      NUMBER,
    EN2                      NUMBER,
    EN3                      NUMBER,
    EN4                      NUMBER,
    EN5                      NUMBER,
    ED1                      DATE,
    ED2                      DATE,
    ED3                      DATE,
    STANDARD                 NVARCHAR2(255),
    STANDARD_DESC            NVARCHAR2(255),
    STANDARD_SORT            NUMBER(11),
    MATERIAL                 NVARCHAR2(255),
    MATERIAL_DESC            NVARCHAR2(255),
    MATERIAL_SORT            NUMBER(11),
    DIAMETER                 NVARCHAR2(255),
    DIAMETER_DESC            NVARCHAR2(255),
    DIAMETER_SORT            NUMBER(11),
    LENGTHS                  NVARCHAR2(255),
    LENGTHS_DESC             NVARCHAR2(255),
    LENGTHS_SORT             NUMBER(11),
    TOOTH                    NVARCHAR2(255),
    TOOTH_DESC               NVARCHAR2(255),
    TOOTH_SORT               NUMBER(11),
    SURFACE                  NVARCHAR2(255),
    SURFACE_DESC             NVARCHAR2(255),
    SURFACE_SORT             NUMBER(11),
    STRENGTH                 NVARCHAR2(255),
    STRENGTH_DESC            NVARCHAR2(255),
    STRENGTH_SORT            NUMBER(11),
    SOURCE                   NVARCHAR2(255),
    SPEC2                    NVARCHAR2(255),
    ITEM_DESC                NCLOB,
    SUB_TITLE                NVARCHAR2(200),
    PINYIN                   NVARCHAR2(200),
    PACKAGE_QTY              NUMBER,
    BATCH_QTY                NUMBER,
    STAMP                    NVARCHAR2(40),
    PURCHASER_NAME           NVARCHAR2(40),
    FIN_GL_TYPE              NVARCHAR2(10),
    SHIPMENT_TYPE            NVARCHAR2(40),
    PLAN_TYPE                NVARCHAR2(40),
    MEM_CODE                 NVARCHAR2(40),
    PINYIN_SH                NVARCHAR2(100),
    OTHER_TYPE1              NVARCHAR2(40),
    OTHER_TYPE2              NVARCHAR2(40),
    INTF_STATUS              NVARCHAR2(40),
    DRAW_NO                  NVARCHAR2(40),
    INTF_TIME                DATE,
    MIN_QTY                  NUMBER,
    PRICE                    NUMBER,
    PRICE_PERIOD             NVARCHAR2(40),
    USAGE_DESC               NVARCHAR2(40),
    ITEM_CODE4               NVARCHAR2(40),
    WH_CODE                  NVARCHAR2(40),
    PROC_INST_ID             NVARCHAR2(255),
    PROC_INST_STATUS         NVARCHAR2(255),
    SUBMIT_TIME              DATE,
    APPROVED_TIME            DATE,
    TENANT_ID                NUMBER(20),
    REMARK                   NVARCHAR2(1000),
    CREATE_USER_ID           NUMBER(20),
    CREATOR                  NVARCHAR2(255),
    CREATE_TIME              DATE,
    MODIFY_USER_ID           NUMBER(20),
    UPDATER                  NVARCHAR2(255),
    MODIFY_TIME              DATE,
    DELETE_FLAG              NUMBER(11) NOT NULL,
    AUDIT_DATA_VERSION       NUMBER(11),
    SEC_BU_ID                NUMBER(20),
    SEC_USER_ID              NUMBER(20),
    SEC_OU_ID                NUMBER(20),
    REBATE_TYPE              NVARCHAR2(40),
    DIMENSION                NVARCHAR2(40),
    WEIGHT_UOM               NVARCHAR2(40),
    TAG_ITM                  NUMBER(11),
    DATA_RELATIONSHIP_SOURCE NVARCHAR2(40),
    ISPROPORTION             NUMBER(10),
    ISMUTEX                  NUMBER(10),
    C1_CODE                  VARCHAR2(40),
    C2_CODE                  VARCHAR2(40),
    C3_CODE                  VARCHAR2(40)
);

COMMENT ON TABLE ITM_ITEM IS '商品';
COMMENT ON COLUMN ITM_ITEM.ID IS '记录唯一ID';
COMMENT ON COLUMN ITM_ITEM.OU_ID IS '公司ID';
COMMENT ON COLUMN ITM_ITEM.OU_CODE IS '公司编号';
COMMENT ON COLUMN ITM_ITEM.OU_NAME IS '公司名称';
COMMENT ON COLUMN ITM_ITEM.BU_ID IS 'BU ID';
COMMENT ON COLUMN ITM_ITEM.BU_CODE IS 'BU编号';
COMMENT ON COLUMN ITM_ITEM.BU_NAME IS 'BU名称';
COMMENT ON COLUMN ITM_ITEM.ITEM_CODE IS '商品编号';
COMMENT ON COLUMN ITM_ITEM.ITEM_CODE2 IS '商品编号2';
COMMENT ON COLUMN ITM_ITEM.ITEM_CODE3 IS '商品编号3';
COMMENT ON COLUMN ITM_ITEM.ITEM_NAME IS '商品名称';
COMMENT ON COLUMN ITM_ITEM.ITEM_NAME2 IS '商品名称2';
COMMENT ON COLUMN ITM_ITEM.ITEM_NAME3 IS '商品名称3';
COMMENT ON COLUMN ITM_ITEM.ITEM_ABBR IS '商品简称';
COMMENT ON COLUMN ITM_ITEM.ITEM_TYPE IS '商品类型 [UDC]ITM:ITEM_TYPE';
COMMENT ON COLUMN ITM_ITEM.ITEM_TYPE2 IS '商品类型2 [UDC]ITM:ITEM_TYPE2';
COMMENT ON COLUMN ITM_ITEM.ITEM_TYPE3 IS '商品类型3';
COMMENT ON COLUMN ITM_ITEM.ITEM_TYPE4 IS '商品类型4';
COMMENT ON COLUMN ITM_ITEM.ITEM_TYPE5 IS '商品类型5';
COMMENT ON COLUMN ITM_ITEM.ITEM_STATUS IS '商品状态 [UDC]ITM:ITEM_STATUS';
COMMENT ON COLUMN ITM_ITEM.ITEM_STATUS2 IS '商品状态2';
COMMENT ON COLUMN ITM_ITEM.ITEM_STATUS3 IS '商品状态3';
COMMENT ON COLUMN ITM_ITEM.SPEC IS '规格，比如：食品净含量';
COMMENT ON COLUMN ITM_ITEM.SPU_ID IS 'SPU_ID';
COMMENT ON COLUMN ITM_ITEM.SPU_CODE IS 'SPU_CODE';
COMMENT ON COLUMN ITM_ITEM.SPU_CODE2 IS 'SPU_CODE2';
COMMENT ON COLUMN ITM_ITEM.SPU_CODE3 IS 'SPU_CODE3';
COMMENT ON COLUMN ITM_ITEM.SPU_NAME IS 'SPU_NAME';
COMMENT ON COLUMN ITM_ITEM.SPU_NAME2 IS 'SPU_NAME2';
COMMENT ON COLUMN ITM_ITEM.SPU_NAME3 IS 'SPU_NAME3';
COMMENT ON COLUMN ITM_ITEM.SPU_ABBR IS 'SPU简称';
COMMENT ON COLUMN ITM_ITEM.ITEM_ATTR IS '商品规格';
COMMENT ON COLUMN ITM_ITEM.ITEM_ATTR2 IS '商品规格2';
COMMENT ON COLUMN ITM_ITEM.ITEM_ATTR3 IS '商品规格3';
COMMENT ON COLUMN ITM_ITEM.ITEM_ATTR4 IS '商品规格4';
COMMENT ON COLUMN ITM_ITEM.ITEM_ATTR5 IS '商品规格5';
COMMENT ON COLUMN ITM_ITEM.ITEM_CATE_CODE IS '商品品类编号';
COMMENT ON COLUMN ITM_ITEM.ITEM_CATE_CODE2 IS '商品品类编号2';
COMMENT ON COLUMN ITM_ITEM.ITEM_CATE_CODE3 IS '商品品类编号3';
COMMENT ON COLUMN ITM_ITEM.ITEM_SOURCE IS '商品识别号';
COMMENT ON COLUMN ITM_ITEM.BRAND IS '品牌';
COMMENT ON COLUMN ITM_ITEM.BRAND2 IS '品牌2';
COMMENT ON COLUMN ITM_ITEM.RELEASE_FLAG IS '是否发布';
COMMENT ON COLUMN ITM_ITEM.SALEPURC_FLAG IS '是否允许自采';
COMMENT ON COLUMN ITM_ITEM.SN_FLAG IS '是否启用序列号';
COMMENT ON COLUMN ITM_ITEM.LOT_FLAG IS '是否启用批次号';
COMMENT ON COLUMN ITM_ITEM.GUARANTEE_FLAG IS '效期管理标识';
COMMENT ON COLUMN ITM_ITEM.MEMBERDISC_FLAGX IS '是否享会员折扣';
COMMENT ON COLUMN ITM_ITEM.DISTRIBUTION_FLAGX IS '是否分销';
COMMENT ON COLUMN ITM_ITEM.FIN_TYPE IS '财务分类 [UDC]ITM:FIN_TYPE';
COMMENT ON COLUMN ITM_ITEM.COST_TYPE IS '成本计价方法 [UDC]ITM:COST_TYPE';
COMMENT ON COLUMN ITM_ITEM.ALLOC_TYPE IS '配货类型 [UDC]ITM:ALLOC_TYPE';
COMMENT ON COLUMN ITM_ITEM.DELIVER_TYPE IS '配送类型 [UDC]ITM:DELIVER_TYPE';
COMMENT ON COLUMN ITM_ITEM.AFTERSALES_SERVICE_FLAGX IS '是否需要售后服务';
COMMENT ON COLUMN ITM_ITEM.INSTALL_FLAG IS '是否需要安装';
COMMENT ON COLUMN ITM_ITEM.RETURN_EXCHANGE_FLAG IS '是否可退换货';
COMMENT ON COLUMN ITM_ITEM.RETURN_EXCHANGE_POLICY IS '退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY';
COMMENT ON COLUMN ITM_ITEM.WARRANTY_FLAG IS '是否保修';
COMMENT ON COLUMN ITM_ITEM.WARRANTY_PERIOD IS '保修期时长';
COMMENT ON COLUMN ITM_ITEM.WARRANTY_PERIOD_UNIT IS '保修期单位 [UDC]COM:TIME_UNIT';
COMMENT ON COLUMN ITM_ITEM.TRANS_CONDITION IS '运输条件';
COMMENT ON COLUMN ITM_ITEM.STORE_CONDITION IS '存储条件';
COMMENT ON COLUMN ITM_ITEM.PACKAGE_SPEC IS '包装规格';
COMMENT ON COLUMN ITM_ITEM.GUARANTEE_PERIOD IS '保质期时长';
COMMENT ON COLUMN ITM_ITEM.GUARANTEE_PERIOD_UNIT IS '保质期单位 [UDC]COM:TIME_UNIT';
COMMENT ON COLUMN ITM_ITEM.GUARANTEE_DAYS IS '保质期天数';
COMMENT ON COLUMN ITM_ITEM.TAX_TYPE IS '税收分类码';
COMMENT ON COLUMN ITM_ITEM.TAX_CODE IS '税码(进项)';
COMMENT ON COLUMN ITM_ITEM.TAX_RATE IS '税率(进项)';
COMMENT ON COLUMN ITM_ITEM.TAX_RATE_NO IS '税率编号(进项)';
COMMENT ON COLUMN ITM_ITEM.TAX_CODE2 IS '税码2(销项)';
COMMENT ON COLUMN ITM_ITEM.TAX_RATE2 IS '税率2(销项)';
COMMENT ON COLUMN ITM_ITEM.TAX_RATE_NO2 IS '税率编号2(销项)';
COMMENT ON COLUMN ITM_ITEM.TAX_RATE_TARIFF IS '关税税率';
COMMENT ON COLUMN ITM_ITEM.SUPP_ID IS '供应商ID';
COMMENT ON COLUMN ITM_ITEM.SUPP_CODE IS '供应商编号';
COMMENT ON COLUMN ITM_ITEM.SUPP_ABBR IS '供应商简称';
COMMENT ON COLUMN ITM_ITEM.SUPP_NAME IS '供应商名称';
COMMENT ON COLUMN ITM_ITEM.SUPP_ITEM_CODE IS '供应商物料编码';
COMMENT ON COLUMN ITM_ITEM.BAR_CODE IS '条码';
COMMENT ON COLUMN ITM_ITEM.BAR_CODE2 IS '条码';
COMMENT ON COLUMN ITM_ITEM.UOM IS '主计量单位 [UDC]COM:UOM';
COMMENT ON COLUMN ITM_ITEM.UOM2 IS '主计量单位2 [UDC]COM:UOM';
COMMENT ON COLUMN ITM_ITEM.UOM3 IS '主计量单位3 [UDC]COM:UOM';
COMMENT ON COLUMN ITM_ITEM.UOM4 IS '主计量单位4 [UDC]COM:UOM';
COMMENT ON COLUMN ITM_ITEM.UOM5 IS '主计量单位5 [UDC]COM:UOM';
COMMENT ON COLUMN ITM_ITEM.SALE_UOM IS '默认销售单位 [UDC]COM:UOM';
COMMENT ON COLUMN ITM_ITEM.PURC_UOM IS '默认采购单位 [UDC]COM:UOM';
COMMENT ON COLUMN ITM_ITEM.SHIP_UOM IS '发运计量单位 [UDC]COM:UOM';
COMMENT ON COLUMN ITM_ITEM.ORDER_UOM IS '要货计量单位 [UDC]COM:UOM';
COMMENT ON COLUMN ITM_ITEM.PRICING_UOM IS '定价计量单位 [UDC]COM:UOM';
COMMENT ON COLUMN ITM_ITEM.STORE_UOM IS '库存计量单位 [UDC]COM:UOM';
COMMENT ON COLUMN ITM_ITEM.GROSS_WEIGHT IS '毛重';
COMMENT ON COLUMN ITM_ITEM.NET_WEIGHT IS '净重';
COMMENT ON COLUMN ITM_ITEM.WEIGHT_UNIT IS '重量单位 [UDC]COM:WEIGHT_UNIT';
COMMENT ON COLUMN ITM_ITEM.WEIGHT_ITEM_UOM IS '重量对应的品项单位 [UDC]COM:UOM';
COMMENT ON COLUMN ITM_ITEM.VOLUME IS '体积';
COMMENT ON COLUMN ITM_ITEM.VOLUME_UNIT IS '体积单位 [UDC]COM:VOLUME_UNIT';
COMMENT ON COLUMN ITM_ITEM.LENGTH IS '长';
COMMENT ON COLUMN ITM_ITEM.WIDTH IS '宽';
COMMENT ON COLUMN ITM_ITEM.HEIGHT IS '高';
COMMENT ON COLUMN ITM_ITEM.LENGTH_UNIT IS '长度单位 [UDC]COM:LENGTH_UNIT';
COMMENT ON COLUMN ITM_ITEM.MOQ IS '最小起定量';
COMMENT ON COLUMN ITM_ITEM.SAFE_QTY IS '安全库存';
COMMENT ON COLUMN ITM_ITEM.MAX_ORDER_QTY IS '最大要货量';
COMMENT ON COLUMN ITM_ITEM.TAGS IS '标签';
COMMENT ON COLUMN ITM_ITEM.OUTER_CODE IS '外部编号';
COMMENT ON COLUMN ITM_ITEM.OUTER_CODE2 IS '外部编号2';
COMMENT ON COLUMN ITM_ITEM.CAT IS '类别码 [UDC]ITM:ITM_CAT2';
COMMENT ON COLUMN ITM_ITEM.CAT2 IS '类别码 [UDC]ITM:ITM_CAT2';
COMMENT ON COLUMN ITM_ITEM.CAT3 IS '类别码 [UDC]ITM:ITM_CAT3';
COMMENT ON COLUMN ITM_ITEM.CAT4 IS '类别码 [UDC]ITM:ITM_CAT4';
COMMENT ON COLUMN ITM_ITEM.CAT5 IS '类别码 [UDC]ITM:ITM_CAT5';
COMMENT ON COLUMN ITM_ITEM.CAT6 IS '类别码 [UDC]ITM:ITM_CAT6';
COMMENT ON COLUMN ITM_ITEM.CAT7 IS '类别码 [UDC]ITM:ITM_CAT7';
COMMENT ON COLUMN ITM_ITEM.CAT8 IS '类别码 [UDC]ITM:ITM_CAT8';
COMMENT ON COLUMN ITM_ITEM.CAT9 IS '类别码 [UDC]ITM:ITM_CAT9';
COMMENT ON COLUMN ITM_ITEM.CAT10 IS '类别码 [UDC]ITM:ITM_CAT10';
COMMENT ON COLUMN ITM_ITEM.ES1 IS 'ES1';
COMMENT ON COLUMN ITM_ITEM.ES2 IS 'ES2';
COMMENT ON COLUMN ITM_ITEM.ES3 IS 'ES3';
COMMENT ON COLUMN ITM_ITEM.ES4 IS 'ES4';
COMMENT ON COLUMN ITM_ITEM.ES5 IS 'ES5';
COMMENT ON COLUMN ITM_ITEM.ES6 IS 'ES6';
COMMENT ON COLUMN ITM_ITEM.ES7 IS 'ES7';
COMMENT ON COLUMN ITM_ITEM.ES8 IS 'ES8';
COMMENT ON COLUMN ITM_ITEM.ES9 IS 'ES9';
COMMENT ON COLUMN ITM_ITEM.ES10 IS 'ES10';
COMMENT ON COLUMN ITM_ITEM.EN1 IS 'EN1';
COMMENT ON COLUMN ITM_ITEM.EN2 IS 'EN2';
COMMENT ON COLUMN ITM_ITEM.EN3 IS 'EN3';
COMMENT ON COLUMN ITM_ITEM.EN4 IS 'EN4';
COMMENT ON COLUMN ITM_ITEM.EN5 IS 'EN5';
COMMENT ON COLUMN ITM_ITEM.ED1 IS 'ED1';
COMMENT ON COLUMN ITM_ITEM.ED2 IS 'ED2';
COMMENT ON COLUMN ITM_ITEM.ED3 IS 'ED3';
COMMENT ON COLUMN ITM_ITEM.STANDARD IS '标准';
COMMENT ON COLUMN ITM_ITEM.STANDARD_DESC IS '标准描述';
COMMENT ON COLUMN ITM_ITEM.STANDARD_SORT IS '标准排序';
COMMENT ON COLUMN ITM_ITEM.MATERIAL IS '材质';
COMMENT ON COLUMN ITM_ITEM.MATERIAL_DESC IS '材质描述';
COMMENT ON COLUMN ITM_ITEM.MATERIAL_SORT IS '材质排序';
COMMENT ON COLUMN ITM_ITEM.DIAMETER IS '直径';
COMMENT ON COLUMN ITM_ITEM.DIAMETER_DESC IS '直径描述';
COMMENT ON COLUMN ITM_ITEM.DIAMETER_SORT IS '直径排序';
COMMENT ON COLUMN ITM_ITEM.LENGTHS IS '长度';
COMMENT ON COLUMN ITM_ITEM.LENGTHS_DESC IS '长度描述';
COMMENT ON COLUMN ITM_ITEM.LENGTHS_SORT IS '长度排序';
COMMENT ON COLUMN ITM_ITEM.TOOTH IS '牙别';
COMMENT ON COLUMN ITM_ITEM.TOOTH_DESC IS '牙别描述';
COMMENT ON COLUMN ITM_ITEM.TOOTH_SORT IS '牙别排序';
COMMENT ON COLUMN ITM_ITEM.SURFACE IS '表面处理';
COMMENT ON COLUMN ITM_ITEM.SURFACE_DESC IS '表面处理描述';
COMMENT ON COLUMN ITM_ITEM.SURFACE_SORT IS '表面处理排序';
COMMENT ON COLUMN ITM_ITEM.STRENGTH IS '强度';
COMMENT ON COLUMN ITM_ITEM.STRENGTH_DESC IS '强度描述';
COMMENT ON COLUMN ITM_ITEM.STRENGTH_SORT IS '强度排序';
COMMENT ON COLUMN ITM_ITEM.SOURCE IS '来源';
COMMENT ON COLUMN ITM_ITEM.SPEC2 IS '规格，比如：食品净含量';
COMMENT ON COLUMN ITM_ITEM.ITEM_DESC IS '品项描述 文描，可含有格式，包含导航段落信息';
COMMENT ON COLUMN ITM_ITEM.SUB_TITLE IS '副标题 如京东有';
COMMENT ON COLUMN ITM_ITEM.PINYIN IS '拼音';
COMMENT ON COLUMN ITM_ITEM.PACKAGE_QTY IS '整包装数量';
COMMENT ON COLUMN ITM_ITEM.BATCH_QTY IS '批量';
COMMENT ON COLUMN ITM_ITEM.STAMP IS '印记';
COMMENT ON COLUMN ITM_ITEM.PURCHASER_NAME IS '采购员姓名';
COMMENT ON COLUMN ITM_ITEM.FIN_GL_TYPE IS '财务总账类别 [UDC]ITM:FIN_GL_TYPE';
COMMENT ON COLUMN ITM_ITEM.SHIPMENT_TYPE IS '发运类型';
COMMENT ON COLUMN ITM_ITEM.PLAN_TYPE IS '计划类型';
COMMENT ON COLUMN ITM_ITEM.MEM_CODE IS '助记码';
COMMENT ON COLUMN ITM_ITEM.PINYIN_SH IS '拼音简称';
COMMENT ON COLUMN ITM_ITEM.OTHER_TYPE1 IS '其它类型1';
COMMENT ON COLUMN ITM_ITEM.OTHER_TYPE2 IS '其它类型2';
COMMENT ON COLUMN ITM_ITEM.INTF_STATUS IS '接口状态';
COMMENT ON COLUMN ITM_ITEM.DRAW_NO IS '接口状态';
COMMENT ON COLUMN ITM_ITEM.INTF_TIME IS '接口处理时间';
COMMENT ON COLUMN ITM_ITEM.PROC_INST_ID IS '流程实例ID';
COMMENT ON COLUMN ITM_ITEM.PROC_INST_STATUS IS '流程实例状态';
COMMENT ON COLUMN ITM_ITEM.SUBMIT_TIME IS '提交时间';
COMMENT ON COLUMN ITM_ITEM.APPROVED_TIME IS '审批通过时间';
COMMENT ON COLUMN ITM_ITEM.TENANT_ID IS '租户ID';
COMMENT ON COLUMN ITM_ITEM.REMARK IS '备注';
COMMENT ON COLUMN ITM_ITEM.CREATE_USER_ID IS '记录创建者ID';
COMMENT ON COLUMN ITM_ITEM.CREATOR IS '记录创建者';
COMMENT ON COLUMN ITM_ITEM.CREATE_TIME IS '记录创建时间';
COMMENT ON COLUMN ITM_ITEM.MODIFY_USER_ID IS '记录最后更新者ID';
COMMENT ON COLUMN ITM_ITEM.UPDATER IS '记录最后更新者';
COMMENT ON COLUMN ITM_ITEM.MODIFY_TIME IS '记录最后更新时间';
COMMENT ON COLUMN ITM_ITEM.DELETE_FLAG IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN ITM_ITEM.AUDIT_DATA_VERSION IS '锁版本';
COMMENT ON COLUMN ITM_ITEM.SEC_BU_ID IS 'SEC_BU_ID';
COMMENT ON COLUMN ITM_ITEM.SEC_USER_ID IS 'SEC_USER_ID';
COMMENT ON COLUMN ITM_ITEM.SEC_OU_ID IS 'SEC_OU_ID';
COMMENT ON COLUMN ITM_ITEM.REBATE_TYPE IS '供应商回扣类型';
COMMENT ON COLUMN ITM_ITEM.DIMENSION IS '直径';
COMMENT ON COLUMN ITM_ITEM.WEIGHT_UOM IS '重量单位';
COMMENT ON COLUMN ITM_ITEM.TAG_ITM IS '分散打散标记：1是，0否';
COMMENT ON COLUMN ITM_ITEM.DATA_RELATIONSHIP_SOURCE IS '数据关系来源';
COMMENT ON COLUMN ITM_ITEM.C1_CODE IS '大类';
COMMENT ON COLUMN ITM_ITEM.C2_CODE IS '中类';
COMMENT ON COLUMN ITM_ITEM.C3_CODE IS '小类';

-- ----------------------------
-- Records of itm_item
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_apply
-- ----------------------------
CREATE TABLE itm_item_apply (
  id NUMBER(20) NOT NULL,
  ou_id NUMBER(20),
  bu_id NUMBER(20),
  doc_no NVARCHAR2(32),
  doc_type NVARCHAR2(32),
  doc_type2 NVARCHAR2(32),
  doc_type3 NVARCHAR2(32),
  doc_status NVARCHAR2(32),
  apply_emp_id NUMBER(20),
  apply_date DATE,
  apply_desc NVARCHAR2(128),
  appr_status NVARCHAR2(32),
  appr_time DATE,
  apply_user_id NUMBER(20),
  apply_comment NVARCHAR2(128),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  proc_inst_id NVARCHAR2(255),
  proc_inst_status NVARCHAR2(255),
  submit_time DATE,
  approved_time DATE
)
;
COMMENT ON COLUMN itm_item_apply.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_apply.ou_id IS 'OU公司ID';
COMMENT ON COLUMN itm_item_apply.bu_id IS 'BU组织ID';
COMMENT ON COLUMN itm_item_apply.doc_no IS '单据编号';
COMMENT ON COLUMN itm_item_apply.doc_type IS '单据类型';
COMMENT ON COLUMN itm_item_apply.doc_type2 IS '单据类型2';
COMMENT ON COLUMN itm_item_apply.doc_type3 IS '单据类型3';
COMMENT ON COLUMN itm_item_apply.doc_status IS '单据状态';
COMMENT ON COLUMN itm_item_apply.apply_emp_id IS '申请人员工ID';
COMMENT ON COLUMN itm_item_apply.apply_date IS '申请日期';
COMMENT ON COLUMN itm_item_apply.apply_desc IS '申请描述';
COMMENT ON COLUMN itm_item_apply.appr_status IS '审批状态';
COMMENT ON COLUMN itm_item_apply.appr_time IS '审批时间';
COMMENT ON COLUMN itm_item_apply.apply_user_id IS '审批人ID';
COMMENT ON COLUMN itm_item_apply.apply_comment IS '审批意见';
COMMENT ON COLUMN itm_item_apply.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_apply.remark IS '备注';
COMMENT ON COLUMN itm_item_apply.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_apply.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_apply.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_apply.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_apply.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_apply.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_apply.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_apply.audit_data_version IS '锁版本';
COMMENT ON COLUMN itm_item_apply.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_apply.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_apply.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_apply.proc_inst_id IS '流程实例ID';
COMMENT ON COLUMN itm_item_apply.proc_inst_status IS '流程实例状态';
COMMENT ON COLUMN itm_item_apply.submit_time IS '提交时间';
COMMENT ON COLUMN itm_item_apply.approved_time IS '审批通过时间';
COMMENT ON TABLE itm_item_apply IS '商品审核单据表';

-- ----------------------------
-- Records of itm_item_apply
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_applyd
-- ----------------------------
CREATE TABLE itm_item_applyd (
  id NUMBER(20) NOT NULL,
  ou_id NUMBER(20),
  doc_no NVARCHAR2(32),
  ou_code NVARCHAR2(40),
  ou_name NVARCHAR2(40),
  bu_id NUMBER(20),
  bu_code NVARCHAR2(40),
  bu_name NVARCHAR2(40),
  item_code NVARCHAR2(40),
  item_code2 NVARCHAR2(40),
  item_code3 NVARCHAR2(40),
  item_name NVARCHAR2(255),
  item_name2 NVARCHAR2(255),
  item_name3 NVARCHAR2(255),
  item_abbr NVARCHAR2(40),
  item_type NVARCHAR2(40),
  item_type2 NVARCHAR2(40),
  item_type3 NVARCHAR2(40),
  item_type4 NVARCHAR2(40),
  item_type5 NVARCHAR2(40),
  item_status NVARCHAR2(40),
  item_status2 NVARCHAR2(40),
  item_status3 NVARCHAR2(40),
  spec NVARCHAR2(255),
  spu_id NUMBER(20) NOT NULL,
  spu_code NVARCHAR2(40),
  spu_code2 NVARCHAR2(40),
  spu_code3 NVARCHAR2(40),
  spu_name NVARCHAR2(255),
  spu_name2 NVARCHAR2(255),
  spu_name3 NVARCHAR2(255),
  spu_abbr NVARCHAR2(40),
  item_attr NVARCHAR2(255),
  item_attr2 NVARCHAR2(40),
  item_attr3 NVARCHAR2(40),
  item_attr4 NVARCHAR2(40),
  item_attr5 NVARCHAR2(40),
  item_cate_code NVARCHAR2(40),
  item_cate_code2 NVARCHAR2(40),
  item_cate_code3 NVARCHAR2(40),
  item_source NVARCHAR2(40),
  brand NVARCHAR2(40),
  brand2 NVARCHAR2(40),
  salepurc_flag NUMBER(11),
  sn_flag NUMBER(11),
  lot_flag NUMBER(11),
  guarantee_flag NUMBER(11),
  memberdisc_flagx NUMBER(11),
  distribution_flagx NUMBER(11),
  fin_type NVARCHAR2(40),
  cost_type NVARCHAR2(40),
  alloc_type NVARCHAR2(40),
  deliver_type NVARCHAR2(40),
  install_flag NUMBER(11),
  return_exchange_flag NUMBER(11),
  return_exchange_policy NVARCHAR2(40),
  warranty_flag NUMBER(11),
  warranty_period NUMBER(11),
  warranty_period_unit NVARCHAR2(40),
  trans_condition NVARCHAR2(40),
  store_condition NVARCHAR2(40),
  package_spec NVARCHAR2(40),
  guarantee_period NUMBER(11),
  guarantee_period_unit NVARCHAR2(40),
  guarantee_days NUMBER(11),
  tax_type NVARCHAR2(40),
  tax_code NVARCHAR2(40),
  tax_rate NUMBER,
  tax_rate_no NVARCHAR2(40),
  tax_code2 NVARCHAR2(40),
  tax_rate2 NUMBER,
  tax_rate_no2 NVARCHAR2(40),
  tax_rate_tariff NUMBER,
  supp_id NUMBER(20),
  supp_code NVARCHAR2(40),
  supp_abbr NVARCHAR2(40),
  supp_name NVARCHAR2(40),
  supp_item_code NVARCHAR2(40),
  bar_code NVARCHAR2(40),
  bar_code2 NVARCHAR2(40),
  uom NVARCHAR2(40),
  uom2 NVARCHAR2(40),
  uom3 NVARCHAR2(40),
  uom4 NVARCHAR2(40),
  uom5 NVARCHAR2(40),
  sale_uom NVARCHAR2(40),
  purc_uom NVARCHAR2(40),
  ship_uom NVARCHAR2(40),
  order_uom NVARCHAR2(40),
  pricing_uom NVARCHAR2(40),
  store_uom NVARCHAR2(40),
  gross_weight NUMBER,
  net_weight NUMBER,
  weight_unit NVARCHAR2(40),
  weight_item_uom NVARCHAR2(40),
  volume NUMBER,
  volume_unit NVARCHAR2(40),
  length NUMBER,
  width NUMBER,
  height NUMBER,
  length_unit NVARCHAR2(40),
  moq NUMBER,
  safe_qty NUMBER,
  max_order_qty NUMBER,
  tags NVARCHAR2(255),
  outer_code NVARCHAR2(40),
  outer_code2 NVARCHAR2(40),
  cat NVARCHAR2(40),
  cat2 NVARCHAR2(40),
  cat3 NVARCHAR2(40),
  cat4 NVARCHAR2(40),
  cat5 NVARCHAR2(40),
  cat6 NVARCHAR2(40),
  cat7 NVARCHAR2(40),
  cat8 NVARCHAR2(40),
  cat9 NVARCHAR2(40),
  cat10 NVARCHAR2(40),
  es1 NVARCHAR2(40),
  es2 NVARCHAR2(40),
  es3 NVARCHAR2(40),
  es4 NVARCHAR2(40),
  es5 NVARCHAR2(40),
  es6 NVARCHAR2(40),
  es7 NVARCHAR2(40),
  es8 NVARCHAR2(40),
  es9 NVARCHAR2(40),
  es10 NVARCHAR2(40),
  en1 NUMBER,
  en2 NUMBER,
  en3 NUMBER,
  en4 NUMBER,
  en5 NUMBER,
  ed1 DATE,
  ed2 DATE,
  ed3 DATE,
  tenant_id NUMBER(20),
  remark NVARCHAR2(1000),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  price1 NUMBER,
  price2 NUMBER,
  price3 NUMBER,
  price4 NUMBER,
  price5 NUMBER,
  price8 NUMBER,
  price9 NUMBER,
  price10 NUMBER,
  price11 NUMBER,
  price12 NUMBER,
  doc_type NVARCHAR2(32),
  aftersales_service_flagx NUMBER(11)
)
;
COMMENT ON COLUMN itm_item_applyd.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_applyd.ou_id IS '公司ID';
COMMENT ON COLUMN itm_item_applyd.doc_no IS '单据编号';
COMMENT ON COLUMN itm_item_applyd.ou_code IS '公司编号';
COMMENT ON COLUMN itm_item_applyd.ou_name IS '公司名称';
COMMENT ON COLUMN itm_item_applyd.bu_id IS 'BU ID';
COMMENT ON COLUMN itm_item_applyd.bu_code IS 'BU编号（采购组织编码）';
COMMENT ON COLUMN itm_item_applyd.bu_name IS 'BU名称';
COMMENT ON COLUMN itm_item_applyd.item_code IS '商品编号';
COMMENT ON COLUMN itm_item_applyd.item_code2 IS '商品编号2';
COMMENT ON COLUMN itm_item_applyd.item_code3 IS '商品编号3';
COMMENT ON COLUMN itm_item_applyd.item_name IS '商品名称';
COMMENT ON COLUMN itm_item_applyd.item_name2 IS '商品名称2';
COMMENT ON COLUMN itm_item_applyd.item_name3 IS '商品名称3';
COMMENT ON COLUMN itm_item_applyd.item_abbr IS '商品简称';
COMMENT ON COLUMN itm_item_applyd.item_type IS '商品类型 [UDC]ITM:ITEM_TYPE';
COMMENT ON COLUMN itm_item_applyd.item_type2 IS '商品类型2 [UDC]ITM:ITEM_TYPE2';
COMMENT ON COLUMN itm_item_applyd.item_type3 IS '商品类型3';
COMMENT ON COLUMN itm_item_applyd.item_type4 IS '商品类型4';
COMMENT ON COLUMN itm_item_applyd.item_type5 IS '商品类型5';
COMMENT ON COLUMN itm_item_applyd.item_status IS '商品状态 [UDC]ITM:ITEM_STATUS';
COMMENT ON COLUMN itm_item_applyd.item_status2 IS '商品状态2';
COMMENT ON COLUMN itm_item_applyd.item_status3 IS '商品状态3';
COMMENT ON COLUMN itm_item_applyd.spec IS '规格，比如：食品净含量';
COMMENT ON COLUMN itm_item_applyd.spu_id IS 'SPU_ID';
COMMENT ON COLUMN itm_item_applyd.spu_code IS 'SPU_CODE';
COMMENT ON COLUMN itm_item_applyd.spu_code2 IS 'SPU_CODE2';
COMMENT ON COLUMN itm_item_applyd.spu_code3 IS 'SPU_CODE3';
COMMENT ON COLUMN itm_item_applyd.spu_name IS 'SPU_NAME';
COMMENT ON COLUMN itm_item_applyd.spu_name2 IS 'SPU_NAME2';
COMMENT ON COLUMN itm_item_applyd.spu_name3 IS 'SPU_NAME3';
COMMENT ON COLUMN itm_item_applyd.spu_abbr IS 'SPU简称';
COMMENT ON COLUMN itm_item_applyd.item_attr IS '商品规格';
COMMENT ON COLUMN itm_item_applyd.item_attr2 IS '商品规格2';
COMMENT ON COLUMN itm_item_applyd.item_attr3 IS '商品规格3';
COMMENT ON COLUMN itm_item_applyd.item_attr4 IS '商品规格4';
COMMENT ON COLUMN itm_item_applyd.item_attr5 IS '商品规格5';
COMMENT ON COLUMN itm_item_applyd.item_cate_code IS '商品品类编号';
COMMENT ON COLUMN itm_item_applyd.item_cate_code2 IS '商品品类编号2';
COMMENT ON COLUMN itm_item_applyd.item_cate_code3 IS '商品品类编号3';
COMMENT ON COLUMN itm_item_applyd.item_source IS '商品识别号';
COMMENT ON COLUMN itm_item_applyd.brand IS '品牌';
COMMENT ON COLUMN itm_item_applyd.brand2 IS '品牌2';
COMMENT ON COLUMN itm_item_applyd.salepurc_flag IS '是否允许自采';
COMMENT ON COLUMN itm_item_applyd.sn_flag IS '是否启用序列号';
COMMENT ON COLUMN itm_item_applyd.lot_flag IS '是否启用批次号';
COMMENT ON COLUMN itm_item_applyd.guarantee_flag IS '效期管理标识';
COMMENT ON COLUMN itm_item_applyd.memberdisc_flagx IS '是否享会员折扣';
COMMENT ON COLUMN itm_item_applyd.distribution_flagx IS '是否分销';
COMMENT ON COLUMN itm_item_applyd.fin_type IS '财务分类 [UDC]ITM:FIN_TYPE';
COMMENT ON COLUMN itm_item_applyd.cost_type IS '成本计价方法 [UDC]ITM:COST_TYPE';
COMMENT ON COLUMN itm_item_applyd.alloc_type IS '配货类型 [UDC]ITM:ALLOC_TYPE';
COMMENT ON COLUMN itm_item_applyd.deliver_type IS '配送类型 [UDC]ITM:DELIVER_TYPE';
COMMENT ON COLUMN itm_item_applyd.install_flag IS '是否需要安装';
COMMENT ON COLUMN itm_item_applyd.return_exchange_flag IS '是否可退换货';
COMMENT ON COLUMN itm_item_applyd.return_exchange_policy IS '退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY';
COMMENT ON COLUMN itm_item_applyd.warranty_flag IS '是否保修';
COMMENT ON COLUMN itm_item_applyd.warranty_period IS '保修期时长';
COMMENT ON COLUMN itm_item_applyd.warranty_period_unit IS '保修期单位 [UDC]COM:TIME_UNIT';
COMMENT ON COLUMN itm_item_applyd.trans_condition IS '运输条件';
COMMENT ON COLUMN itm_item_applyd.store_condition IS '存储条件';
COMMENT ON COLUMN itm_item_applyd.package_spec IS '包装规格';
COMMENT ON COLUMN itm_item_applyd.guarantee_period IS '保质期时长';
COMMENT ON COLUMN itm_item_applyd.guarantee_period_unit IS '保质期单位 [UDC]COM:TIME_UNIT';
COMMENT ON COLUMN itm_item_applyd.guarantee_days IS '保质期天数';
COMMENT ON COLUMN itm_item_applyd.tax_type IS '税收分类码';
COMMENT ON COLUMN itm_item_applyd.tax_code IS '税码(进项)';
COMMENT ON COLUMN itm_item_applyd.tax_rate IS '税率(进项)';
COMMENT ON COLUMN itm_item_applyd.tax_rate_no IS '税率编号(进项)';
COMMENT ON COLUMN itm_item_applyd.tax_code2 IS '税码2(销项)';
COMMENT ON COLUMN itm_item_applyd.tax_rate2 IS '税率2(销项)';
COMMENT ON COLUMN itm_item_applyd.tax_rate_no2 IS '税率编号2(销项)';
COMMENT ON COLUMN itm_item_applyd.tax_rate_tariff IS '关税税率';
COMMENT ON COLUMN itm_item_applyd.supp_id IS '供应商ID';
COMMENT ON COLUMN itm_item_applyd.supp_code IS '供应商编号';
COMMENT ON COLUMN itm_item_applyd.supp_abbr IS '供应商简称';
COMMENT ON COLUMN itm_item_applyd.supp_name IS '供应商名称';
COMMENT ON COLUMN itm_item_applyd.supp_item_code IS '供应商物料编码';
COMMENT ON COLUMN itm_item_applyd.bar_code IS '条码';
COMMENT ON COLUMN itm_item_applyd.bar_code2 IS '条码';
COMMENT ON COLUMN itm_item_applyd.uom IS '主计量单位 [UDC]COM:UOM';
COMMENT ON COLUMN itm_item_applyd.uom2 IS '主计量单位2 [UDC]COM:UOM';
COMMENT ON COLUMN itm_item_applyd.uom3 IS '主计量单位3 [UDC]COM:UOM';
COMMENT ON COLUMN itm_item_applyd.uom4 IS '主计量单位4 [UDC]COM:UOM';
COMMENT ON COLUMN itm_item_applyd.uom5 IS '主计量单位5 [UDC]COM:UOM';
COMMENT ON COLUMN itm_item_applyd.sale_uom IS '默认销售单位 [UDC]COM:UOM';
COMMENT ON COLUMN itm_item_applyd.purc_uom IS '默认采购单位 [UDC]COM:UOM';
COMMENT ON COLUMN itm_item_applyd.ship_uom IS '发运计量单位 [UDC]COM:UOM';
COMMENT ON COLUMN itm_item_applyd.order_uom IS '要货计量单位 [UDC]COM:UOM';
COMMENT ON COLUMN itm_item_applyd.pricing_uom IS '定价计量单位 [UDC]COM:UOM';
COMMENT ON COLUMN itm_item_applyd.store_uom IS '库存计量单位 [UDC]COM:UOM';
COMMENT ON COLUMN itm_item_applyd.gross_weight IS '毛重';
COMMENT ON COLUMN itm_item_applyd.net_weight IS '净重';
COMMENT ON COLUMN itm_item_applyd.weight_unit IS '重量单位 [UDC]COM:WEIGHT_UNIT';
COMMENT ON COLUMN itm_item_applyd.weight_item_uom IS '重量对应的品项单位 [UDC]COM:UOM';
COMMENT ON COLUMN itm_item_applyd.volume IS '体积';
COMMENT ON COLUMN itm_item_applyd.volume_unit IS '体积单位 [UDC]COM:VOLUME_UNIT';
COMMENT ON COLUMN itm_item_applyd.length IS '长';
COMMENT ON COLUMN itm_item_applyd.width IS '宽';
COMMENT ON COLUMN itm_item_applyd.height IS '高';
COMMENT ON COLUMN itm_item_applyd.length_unit IS '长度单位 [UDC]COM:LENGTH_UNIT';
COMMENT ON COLUMN itm_item_applyd.moq IS '最小起定量';
COMMENT ON COLUMN itm_item_applyd.safe_qty IS '安全库存';
COMMENT ON COLUMN itm_item_applyd.max_order_qty IS '最大要货量';
COMMENT ON COLUMN itm_item_applyd.tags IS '标签';
COMMENT ON COLUMN itm_item_applyd.outer_code IS '外部编号';
COMMENT ON COLUMN itm_item_applyd.outer_code2 IS '外部编号2';
COMMENT ON COLUMN itm_item_applyd.cat IS '类别码 [UDC]ITM:ITM_CAT';
COMMENT ON COLUMN itm_item_applyd.cat2 IS '类别码 [UDC]ITM:ITM_CAT2';
COMMENT ON COLUMN itm_item_applyd.cat3 IS '类别码 [UDC]ITM:ITM_CAT3';
COMMENT ON COLUMN itm_item_applyd.cat4 IS '类别码 [UDC]ITM:ITM_CAT4';
COMMENT ON COLUMN itm_item_applyd.cat5 IS '类别码 [UDC]ITM:ITM_CAT5';
COMMENT ON COLUMN itm_item_applyd.cat6 IS '类别码 [UDC]ITM:ITM_CAT6';
COMMENT ON COLUMN itm_item_applyd.cat7 IS '类别码 [UDC]ITM:ITM_CAT7';
COMMENT ON COLUMN itm_item_applyd.cat8 IS '类别码 [UDC]ITM:ITM_CAT8';
COMMENT ON COLUMN itm_item_applyd.cat9 IS '类别码 [UDC]ITM:ITM_CAT9';
COMMENT ON COLUMN itm_item_applyd.cat10 IS '类别码 [UDC]ITM:ITM_CAT10';
COMMENT ON COLUMN itm_item_applyd.es1 IS 'ES1';
COMMENT ON COLUMN itm_item_applyd.es2 IS 'ES2';
COMMENT ON COLUMN itm_item_applyd.es3 IS 'ES3';
COMMENT ON COLUMN itm_item_applyd.es4 IS 'ES4';
COMMENT ON COLUMN itm_item_applyd.es5 IS 'ES5';
COMMENT ON COLUMN itm_item_applyd.es6 IS 'ES6';
COMMENT ON COLUMN itm_item_applyd.es7 IS 'ES7';
COMMENT ON COLUMN itm_item_applyd.es8 IS 'ES8';
COMMENT ON COLUMN itm_item_applyd.es9 IS 'ES9';
COMMENT ON COLUMN itm_item_applyd.es10 IS 'ES10';
COMMENT ON COLUMN itm_item_applyd.en1 IS 'EN1';
COMMENT ON COLUMN itm_item_applyd.en2 IS 'EN2';
COMMENT ON COLUMN itm_item_applyd.en3 IS 'EN3';
COMMENT ON COLUMN itm_item_applyd.en4 IS 'EN4';
COMMENT ON COLUMN itm_item_applyd.en5 IS 'EN5';
COMMENT ON COLUMN itm_item_applyd.ed1 IS 'ED1';
COMMENT ON COLUMN itm_item_applyd.ed2 IS 'ED2';
COMMENT ON COLUMN itm_item_applyd.ed3 IS 'ED3';
COMMENT ON COLUMN itm_item_applyd.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_applyd.remark IS '备注';
COMMENT ON COLUMN itm_item_applyd.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_applyd.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_applyd.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_applyd.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_applyd.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_applyd.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_applyd.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_applyd.audit_data_version IS '锁版本';
COMMENT ON COLUMN itm_item_applyd.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_applyd.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_applyd.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_applyd.doc_type IS '申请类型(单据类型)';
COMMENT ON COLUMN itm_item_applyd.aftersales_service_flagx IS '是否需要售后服务';
COMMENT ON TABLE itm_item_applyd IS '商品履历';

-- ----------------------------
-- Records of itm_item_applyd
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_attachment
-- ----------------------------
CREATE TABLE itm_item_attachment (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  item_id NUMBER(20),
  file_id NUMBER(20),
  file_name NVARCHAR2(256),
  file_code NVARCHAR2(256),
  file_type NVARCHAR2(40),
  img_size NVARCHAR2(40),
  file_size NVARCHAR2(40),
  major NUMBER(4),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  url NVARCHAR2(256)
)
;
COMMENT ON COLUMN itm_item_attachment.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_attachment.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_attachment.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_attachment.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_attachment.item_id IS '商品ID';
COMMENT ON COLUMN itm_item_attachment.file_id IS '文件ID';
COMMENT ON COLUMN itm_item_attachment.file_name IS '商品文件名称';
COMMENT ON COLUMN itm_item_attachment.file_code IS '商品文件编号';
COMMENT ON COLUMN itm_item_attachment.file_type IS '商品文件类型(图片，附件等)';
COMMENT ON COLUMN itm_item_attachment.img_size IS '图片尺寸';
COMMENT ON COLUMN itm_item_attachment.file_size IS '文件大小';
COMMENT ON COLUMN itm_item_attachment.major IS '是否主图';
COMMENT ON COLUMN itm_item_attachment.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_attachment.remark IS '备注';
COMMENT ON COLUMN itm_item_attachment.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_attachment.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_attachment.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_attachment.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_attachment.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_attachment.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_attachment.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_attachment.audit_data_version IS '锁版本';
COMMENT ON COLUMN itm_item_attachment.url IS '图片url';
COMMENT ON TABLE itm_item_attachment IS '商品附件';

-- ----------------------------
-- Records of itm_item_attachment
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_attachment_applyd
-- ----------------------------
CREATE TABLE itm_item_attachment_applyd (
  id NUMBER(20) NOT NULL,
  item_id NUMBER(20),
  file_id NUMBER(20),
  file_name NVARCHAR2(256),
  file_code NVARCHAR2(256),
  file_type NVARCHAR2(40),
  img_size NVARCHAR2(40),
  file_size NVARCHAR2(40),
  major NUMBER(4),
  url NVARCHAR2(256),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  doc_no NVARCHAR2(32)
)
;
COMMENT ON COLUMN itm_item_attachment_applyd.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_attachment_applyd.item_id IS '商品ID';
COMMENT ON COLUMN itm_item_attachment_applyd.file_id IS '文件ID';
COMMENT ON COLUMN itm_item_attachment_applyd.file_name IS '商品文件名称';
COMMENT ON COLUMN itm_item_attachment_applyd.file_code IS '商品文件编号';
COMMENT ON COLUMN itm_item_attachment_applyd.file_type IS '商品文件类型(图片，附件等)';
COMMENT ON COLUMN itm_item_attachment_applyd.img_size IS '图片尺寸';
COMMENT ON COLUMN itm_item_attachment_applyd.file_size IS '文件大小';
COMMENT ON COLUMN itm_item_attachment_applyd.major IS '是否主图';
COMMENT ON COLUMN itm_item_attachment_applyd.url IS '图片url';
COMMENT ON COLUMN itm_item_attachment_applyd.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_attachment_applyd.remark IS '备注';
COMMENT ON COLUMN itm_item_attachment_applyd.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_attachment_applyd.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_attachment_applyd.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_attachment_applyd.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_attachment_applyd.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_attachment_applyd.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_attachment_applyd.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_attachment_applyd.audit_data_version IS '锁版本';
COMMENT ON COLUMN itm_item_attachment_applyd.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_attachment_applyd.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_attachment_applyd.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_attachment_applyd.doc_no IS '单据编号';
COMMENT ON TABLE itm_item_attachment_applyd IS '商品附件-履历';

-- ----------------------------
-- Records of itm_item_attachment_applyd
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_bom
-- ----------------------------
CREATE TABLE itm_item_bom (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  pid NUMBER(20) NOT NULL,
  sort_no NUMBER(11),
  grade NUMBER(11),
  id_path NVARCHAR2(255),
  code_path NVARCHAR2(255),
  item_id NUMBER(20),
  qty NUMBER(11),
  general_accessories_spec NVARCHAR2(255),
  bom_type NVARCHAR2(40),
  bom_type2 NVARCHAR2(40),
  bom_type3 NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_item_bom.item_id IS '商品ID';
COMMENT ON COLUMN itm_item_bom.qty IS '数量(主计量单位的数量)';
COMMENT ON COLUMN itm_item_bom.general_accessories_spec IS '通用配件型号';
COMMENT ON COLUMN itm_item_bom.bom_type IS '物料类型';
COMMENT ON COLUMN itm_item_bom.bom_type2 IS '物料类型2';
COMMENT ON COLUMN itm_item_bom.bom_type3 IS '物料类型3';
COMMENT ON TABLE itm_item_bom IS '商品(物料)结构清单';

-- ----------------------------
-- Records of itm_item_bom
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_business
-- ----------------------------
CREATE TABLE itm_item_business (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  bu_treedid NUMBER(20),
  item_source NVARCHAR2(40),
  bu_code NVARCHAR2(40),
  spu_id NUMBER(20),
  spu_code NVARCHAR2(40),
  alloc_type NVARCHAR2(40),
  tax_rate_no NVARCHAR2(40),
  tax_rate_no2 NVARCHAR2(40),
  tax_rate_tariff NUMBER,
  install_flag NUMBER(11),
  return_exchange_flag NUMBER(11),
  return_exchange_policy NVARCHAR2(40),
  warranty_flag NUMBER(11),
  warranty_period NUMBER(11),
  warranty_period_unit NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_item_business.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_business.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_business.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_business.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_business.bu_treedid IS '组织树节点ID';
COMMENT ON COLUMN itm_item_business.item_source IS '商品识别号';
COMMENT ON COLUMN itm_item_business.bu_code IS '组织编号';
COMMENT ON COLUMN itm_item_business.spu_id IS 'spuId';
COMMENT ON COLUMN itm_item_business.spu_code IS '组织编号';
COMMENT ON COLUMN itm_item_business.alloc_type IS '配货类型 [UDC]ITM:ALLOC_TYPE';
COMMENT ON COLUMN itm_item_business.tax_rate_no IS '税率编号(进项)';
COMMENT ON COLUMN itm_item_business.tax_rate_no2 IS '税率编号2(销项)';
COMMENT ON COLUMN itm_item_business.tax_rate_tariff IS '关税税率';
COMMENT ON COLUMN itm_item_business.install_flag IS '是否需要安装';
COMMENT ON COLUMN itm_item_business.return_exchange_flag IS '是否可退换货';
COMMENT ON COLUMN itm_item_business.return_exchange_policy IS '退换货政策 [UDC]ITM:RETURN_EXCHANGE_POLICY';
COMMENT ON COLUMN itm_item_business.warranty_flag IS '是否保修';
COMMENT ON COLUMN itm_item_business.warranty_period IS '保修期时长';
COMMENT ON COLUMN itm_item_business.warranty_period_unit IS '保修期单位 [UDC]COM:TIME_UNIT';
COMMENT ON COLUMN itm_item_business.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_business.remark IS '备注';
COMMENT ON COLUMN itm_item_business.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_business.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_business.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_business.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_business.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_business.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_business.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_business.audit_data_version IS '锁版本';
COMMENT ON TABLE itm_item_business IS '商品经营目录';

-- ----------------------------
-- Records of itm_item_business
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_cate
-- ----------------------------
CREATE TABLE itm_item_cate (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  pid NUMBER(20) NOT NULL,
  sort_no NUMBER(11),
  grade NUMBER(11),
  id_path NVARCHAR2(255),
  code_path NVARCHAR2(255),
  item_cate_code NVARCHAR2(32),
  item_cate_name NVARCHAR2(32),
  item_cate_is_basic NUMBER(11),
  status NVARCHAR2(8),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_item_cate.item_cate_code IS '品类编码';
COMMENT ON COLUMN itm_item_cate.item_cate_name IS '品类名称';
COMMENT ON COLUMN itm_item_cate.item_cate_is_basic IS '是否基础类目（0：不是，1：是）';
COMMENT ON COLUMN itm_item_cate.status IS '状态';
COMMENT ON TABLE itm_item_cate IS '商品品类';



-- ----------------------------
-- Table structure for itm_item_combo
-- ----------------------------
CREATE TABLE itm_item_combo (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  item_combo_code NVARCHAR2(32),
  item_combo_name NVARCHAR2(32),
  item_combo_other_name NVARCHAR2(32),
  item_combo_type NVARCHAR2(16),
  status NVARCHAR2(8),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_item_combo.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_combo.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_combo.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_combo.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_combo.item_combo_code IS '组合商品编码';
COMMENT ON COLUMN itm_item_combo.item_combo_name IS '组合商品名称';
COMMENT ON COLUMN itm_item_combo.item_combo_other_name IS '组合商品别名';
COMMENT ON COLUMN itm_item_combo.item_combo_type IS '组合商品类型';
COMMENT ON COLUMN itm_item_combo.status IS '状态';
COMMENT ON COLUMN itm_item_combo.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_combo.remark IS '备注';
COMMENT ON COLUMN itm_item_combo.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_combo.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_combo.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_combo.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_combo.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_combo.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_combo.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_combo.audit_data_version IS '锁版本';
COMMENT ON TABLE itm_item_combo IS '组合商品';

-- ----------------------------
-- Records of itm_item_combo
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_cust_prop
-- ----------------------------
CREATE TABLE itm_item_cust_prop (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  item_id NUMBER(20),
  cust_prop_key NVARCHAR2(32),
  cust_prop_value NVARCHAR2(32),
  status NVARCHAR2(8),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_item_cust_prop.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_cust_prop.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_cust_prop.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_cust_prop.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_cust_prop.item_id IS '商品ID';
COMMENT ON COLUMN itm_item_cust_prop.cust_prop_key IS '自定义属性Key';
COMMENT ON COLUMN itm_item_cust_prop.cust_prop_value IS '自定义属性Value';
COMMENT ON COLUMN itm_item_cust_prop.status IS '状态';
COMMENT ON COLUMN itm_item_cust_prop.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_cust_prop.remark IS '备注';
COMMENT ON COLUMN itm_item_cust_prop.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_cust_prop.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_cust_prop.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_cust_prop.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_cust_prop.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_cust_prop.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_cust_prop.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_cust_prop.audit_data_version IS '锁版本';
COMMENT ON TABLE itm_item_cust_prop IS '商品自定义属性';

-- ----------------------------
-- Records of itm_item_cust_prop
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_cust_prop_applyd
-- ----------------------------
CREATE TABLE itm_item_cust_prop_applyd (
  id NUMBER(20) NOT NULL,
  item_id NUMBER(20),
  cust_prop_key NVARCHAR2(32),
  cust_prop_value NVARCHAR2(32),
  status NVARCHAR2(8),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  doc_no NVARCHAR2(32)
)
;
COMMENT ON COLUMN itm_item_cust_prop_applyd.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_cust_prop_applyd.item_id IS '商品ID';
COMMENT ON COLUMN itm_item_cust_prop_applyd.cust_prop_key IS '自定义属性Key';
COMMENT ON COLUMN itm_item_cust_prop_applyd.cust_prop_value IS '自定义属性Value';
COMMENT ON COLUMN itm_item_cust_prop_applyd.status IS '状态';
COMMENT ON COLUMN itm_item_cust_prop_applyd.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_cust_prop_applyd.remark IS '备注';
COMMENT ON COLUMN itm_item_cust_prop_applyd.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_cust_prop_applyd.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_cust_prop_applyd.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_cust_prop_applyd.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_cust_prop_applyd.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_cust_prop_applyd.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_cust_prop_applyd.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_cust_prop_applyd.audit_data_version IS '锁版本';
COMMENT ON COLUMN itm_item_cust_prop_applyd.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_cust_prop_applyd.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_cust_prop_applyd.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_cust_prop_applyd.doc_no IS '单据编号';
COMMENT ON TABLE itm_item_cust_prop_applyd IS '商品自定义属性_履历';

-- ----------------------------
-- Records of itm_item_cust_prop_applyd
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_prop
-- ----------------------------
CREATE TABLE itm_item_prop (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  item_id NUMBER(20),
  cate_prop_type NVARCHAR2(40),
  cate_prop_code NVARCHAR2(40),
  cate_prop_name NVARCHAR2(40),
  prop_value NVARCHAR2(255),
  status NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_item_prop.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_prop.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_prop.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_prop.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_prop.item_id IS '商品ID';
COMMENT ON COLUMN itm_item_prop.cate_prop_type IS '属性类型';
COMMENT ON COLUMN itm_item_prop.cate_prop_code IS '属性名编码';
COMMENT ON COLUMN itm_item_prop.cate_prop_name IS '属性名名称';
COMMENT ON COLUMN itm_item_prop.prop_value IS '属性名属性值编码';
COMMENT ON COLUMN itm_item_prop.status IS '状态';
COMMENT ON COLUMN itm_item_prop.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_prop.remark IS '备注';
COMMENT ON COLUMN itm_item_prop.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_prop.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_prop.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_prop.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_prop.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_prop.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_prop.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_prop.audit_data_version IS '锁版本';
COMMENT ON TABLE itm_item_prop IS '商品属性';

-- ----------------------------
-- Records of itm_item_prop
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_prop_applyd
-- ----------------------------
CREATE TABLE itm_item_prop_applyd (
  id NUMBER(20) NOT NULL,
  item_id NUMBER(20),
  cate_prop_type NVARCHAR2(40),
  cate_prop_code NVARCHAR2(40),
  cate_prop_name NVARCHAR2(40),
  prop_value NVARCHAR2(255),
  status NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  doc_no NVARCHAR2(32)
)
;
COMMENT ON COLUMN itm_item_prop_applyd.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_prop_applyd.item_id IS '商品ID';
COMMENT ON COLUMN itm_item_prop_applyd.cate_prop_type IS '属性类型';
COMMENT ON COLUMN itm_item_prop_applyd.cate_prop_code IS '属性名编码';
COMMENT ON COLUMN itm_item_prop_applyd.cate_prop_name IS '属性名名称';
COMMENT ON COLUMN itm_item_prop_applyd.prop_value IS '属性名属性值编码';
COMMENT ON COLUMN itm_item_prop_applyd.status IS '状态';
COMMENT ON COLUMN itm_item_prop_applyd.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_prop_applyd.remark IS '备注';
COMMENT ON COLUMN itm_item_prop_applyd.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_prop_applyd.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_prop_applyd.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_prop_applyd.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_prop_applyd.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_prop_applyd.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_prop_applyd.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_prop_applyd.audit_data_version IS '锁版本';
COMMENT ON COLUMN itm_item_prop_applyd.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_prop_applyd.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_prop_applyd.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_prop_applyd.doc_no IS '单据编号';
COMMENT ON TABLE itm_item_prop_applyd IS '商品属性_履历';

-- ----------------------------
-- Records of itm_item_prop_applyd
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_publish
-- ----------------------------
CREATE TABLE itm_item_publish (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  user_id NUMBER(20),
  publish_time DATE,
  status NVARCHAR2(8),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_item_publish.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_publish.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_publish.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_publish.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_publish.user_id IS '发布人ID';
COMMENT ON COLUMN itm_item_publish.publish_time IS '发布时间';
COMMENT ON COLUMN itm_item_publish.status IS '状态';
COMMENT ON COLUMN itm_item_publish.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_publish.remark IS '备注';
COMMENT ON COLUMN itm_item_publish.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_publish.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_publish.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_publish.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_publish.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_publish.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_publish.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_publish.audit_data_version IS '锁版本';
COMMENT ON TABLE itm_item_publish IS '商品发布管理';

-- ----------------------------
-- Records of itm_item_publish
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_qualify
-- ----------------------------
CREATE TABLE itm_item_qualify (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  ou_id NUMBER(20),
  ou_code NVARCHAR2(40),
  ou_name NVARCHAR2(40),
  bu_id NUMBER(20),
  bu_code NVARCHAR2(40),
  bu_name NVARCHAR2(40),
  item_id NUMBER(20),
  item_code NVARCHAR2(40),
  item_code2 NVARCHAR2(40),
  item_code3 NVARCHAR2(40),
  item_name NVARCHAR2(40),
  item_name2 NVARCHAR2(40),
  item_name3 NVARCHAR2(40),
  spec NVARCHAR2(255),
  spu_id NUMBER(20),
  spu_code NVARCHAR2(40),
  spu_code2 NVARCHAR2(40),
  spu_code3 NVARCHAR2(40),
  spu_name NVARCHAR2(40),
  spu_name2 NVARCHAR2(40),
  spu_name3 NVARCHAR2(40),
  qualify_type NVARCHAR2(40),
  qualify_name NVARCHAR2(40),
  qualify_no NVARCHAR2(40),
  qualify_file_name NVARCHAR2(255),
  qualify_file_code NVARCHAR2(255),
  valid_from DATE,
  valid_to DATE,
  next_check_date DATE,
  longterm_flag NUMBER(11),
  qualify_status NVARCHAR2(40),
  qualify_status2 NVARCHAR2(40),
  qualify_owner NVARCHAR2(40),
  related_id1 NUMBER(20),
  related_id2 NUMBER(20),
  es1 NVARCHAR2(40),
  es2 NVARCHAR2(40),
  es3 NVARCHAR2(40),
  es4 NVARCHAR2(40),
  es5 NVARCHAR2(40),
  es6 NVARCHAR2(40),
  es7 NVARCHAR2(40),
  es8 NVARCHAR2(40),
  es9 NVARCHAR2(40),
  es10 NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_item_qualify.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_qualify.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_qualify.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_qualify.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_qualify.ou_id IS '公司ID';
COMMENT ON COLUMN itm_item_qualify.ou_code IS '公司编号';
COMMENT ON COLUMN itm_item_qualify.ou_name IS '公司名称';
COMMENT ON COLUMN itm_item_qualify.bu_id IS 'BU ID';
COMMENT ON COLUMN itm_item_qualify.bu_code IS 'BU编号';
COMMENT ON COLUMN itm_item_qualify.bu_name IS 'BU名称';
COMMENT ON COLUMN itm_item_qualify.item_id IS '商品ID';
COMMENT ON COLUMN itm_item_qualify.item_code IS '商品编号';
COMMENT ON COLUMN itm_item_qualify.item_code2 IS '商品编号2';
COMMENT ON COLUMN itm_item_qualify.item_code3 IS '商品编号3';
COMMENT ON COLUMN itm_item_qualify.item_name IS '商品名称';
COMMENT ON COLUMN itm_item_qualify.item_name2 IS '商品名称2';
COMMENT ON COLUMN itm_item_qualify.item_name3 IS '商品名称3';
COMMENT ON COLUMN itm_item_qualify.spec IS '规格，比如：食品净含量';
COMMENT ON COLUMN itm_item_qualify.spu_id IS 'SPU_ID';
COMMENT ON COLUMN itm_item_qualify.spu_code IS 'SPU_CODE';
COMMENT ON COLUMN itm_item_qualify.spu_code2 IS 'SPU_CODE2';
COMMENT ON COLUMN itm_item_qualify.spu_code3 IS 'SPU_CODE3';
COMMENT ON COLUMN itm_item_qualify.spu_name IS 'SPU_NAME';
COMMENT ON COLUMN itm_item_qualify.spu_name2 IS 'SPU_NAME2';
COMMENT ON COLUMN itm_item_qualify.spu_name3 IS 'SPU_NAME3';
COMMENT ON COLUMN itm_item_qualify.qualify_type IS '资质类型 [UDC]ITM:QUALIFY_TYPE';
COMMENT ON COLUMN itm_item_qualify.qualify_name IS '资质名称';
COMMENT ON COLUMN itm_item_qualify.qualify_no IS '资质编号';
COMMENT ON COLUMN itm_item_qualify.qualify_file_name IS '资质文件名称';
COMMENT ON COLUMN itm_item_qualify.qualify_file_code IS '资质文件编号';
COMMENT ON COLUMN itm_item_qualify.valid_from IS '生效日期';
COMMENT ON COLUMN itm_item_qualify.valid_to IS '失效日期';
COMMENT ON COLUMN itm_item_qualify.next_check_date IS '下次检查日期';
COMMENT ON COLUMN itm_item_qualify.longterm_flag IS '是否长期有效';
COMMENT ON COLUMN itm_item_qualify.qualify_status IS '资质证照状态 [UDC]COM:STATUS_ACTIVEORNO';
COMMENT ON COLUMN itm_item_qualify.qualify_status2 IS '资质证照状态2';
COMMENT ON COLUMN itm_item_qualify.qualify_owner IS '证照所有者';
COMMENT ON COLUMN itm_item_qualify.related_id1 IS '关联ID1';
COMMENT ON COLUMN itm_item_qualify.related_id2 IS '关联ID2';
COMMENT ON COLUMN itm_item_qualify.es1 IS 'ES1';
COMMENT ON COLUMN itm_item_qualify.es2 IS 'ES2';
COMMENT ON COLUMN itm_item_qualify.es3 IS 'ES3';
COMMENT ON COLUMN itm_item_qualify.es4 IS 'ES4';
COMMENT ON COLUMN itm_item_qualify.es5 IS 'ES5';
COMMENT ON COLUMN itm_item_qualify.es6 IS 'ES6';
COMMENT ON COLUMN itm_item_qualify.es7 IS 'ES7';
COMMENT ON COLUMN itm_item_qualify.es8 IS 'ES8';
COMMENT ON COLUMN itm_item_qualify.es9 IS 'ES9';
COMMENT ON COLUMN itm_item_qualify.es10 IS 'ES10';
COMMENT ON COLUMN itm_item_qualify.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_qualify.remark IS '备注';
COMMENT ON COLUMN itm_item_qualify.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_qualify.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_qualify.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_qualify.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_qualify.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_qualify.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_qualify.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_qualify.audit_data_version IS '锁版本';
COMMENT ON TABLE itm_item_qualify IS '商品资质信息';

-- ----------------------------
-- Records of itm_item_qualify
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_qualify_applyd
-- ----------------------------
CREATE TABLE itm_item_qualify_applyd (
  id NUMBER(20) NOT NULL,
  ou_id NUMBER(20),
  ou_code NVARCHAR2(40),
  ou_name NVARCHAR2(40),
  bu_id NUMBER(20),
  bu_code NVARCHAR2(40),
  bu_name NVARCHAR2(40),
  item_id NUMBER(20),
  item_code NVARCHAR2(40),
  item_code2 NVARCHAR2(40),
  item_code3 NVARCHAR2(40),
  item_name NVARCHAR2(40),
  item_name2 NVARCHAR2(40),
  item_name3 NVARCHAR2(40),
  spec NVARCHAR2(255),
  spu_id NUMBER(20),
  spu_code NVARCHAR2(40),
  spu_code2 NVARCHAR2(40),
  spu_code3 NVARCHAR2(40),
  spu_name NVARCHAR2(40),
  spu_name2 NVARCHAR2(40),
  spu_name3 NVARCHAR2(40),
  qualify_type NVARCHAR2(40),
  qualify_name NVARCHAR2(40),
  qualify_no NVARCHAR2(40),
  qualify_file_name NVARCHAR2(255),
  qualify_file_code NVARCHAR2(255),
  valid_from DATE,
  valid_to DATE,
  next_check_date DATE,
  longterm_flag NUMBER(11),
  qualify_status NVARCHAR2(40),
  qualify_status2 NVARCHAR2(40),
  qualify_owner NVARCHAR2(40),
  related_id1 NUMBER(20),
  related_id2 NUMBER(20),
  es1 NVARCHAR2(40),
  es2 NVARCHAR2(40),
  es3 NVARCHAR2(40),
  es4 NVARCHAR2(40),
  es5 NVARCHAR2(40),
  es6 NVARCHAR2(40),
  es7 NVARCHAR2(40),
  es8 NVARCHAR2(40),
  es9 NVARCHAR2(40),
  es10 NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  doc_no NVARCHAR2(32)
)
;
COMMENT ON COLUMN itm_item_qualify_applyd.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_qualify_applyd.ou_id IS '公司ID';
COMMENT ON COLUMN itm_item_qualify_applyd.ou_code IS '公司编号';
COMMENT ON COLUMN itm_item_qualify_applyd.ou_name IS '公司名称';
COMMENT ON COLUMN itm_item_qualify_applyd.bu_id IS 'BU ID';
COMMENT ON COLUMN itm_item_qualify_applyd.bu_code IS 'BU编号';
COMMENT ON COLUMN itm_item_qualify_applyd.bu_name IS 'BU名称';
COMMENT ON COLUMN itm_item_qualify_applyd.item_id IS '商品ID';
COMMENT ON COLUMN itm_item_qualify_applyd.item_code IS '商品编号';
COMMENT ON COLUMN itm_item_qualify_applyd.item_code2 IS '商品编号2';
COMMENT ON COLUMN itm_item_qualify_applyd.item_code3 IS '商品编号3';
COMMENT ON COLUMN itm_item_qualify_applyd.item_name IS '商品名称';
COMMENT ON COLUMN itm_item_qualify_applyd.item_name2 IS '商品名称2';
COMMENT ON COLUMN itm_item_qualify_applyd.item_name3 IS '商品名称3';
COMMENT ON COLUMN itm_item_qualify_applyd.spec IS '规格，比如：食品净含量';
COMMENT ON COLUMN itm_item_qualify_applyd.spu_id IS 'SPU_ID';
COMMENT ON COLUMN itm_item_qualify_applyd.spu_code IS 'SPU_CODE';
COMMENT ON COLUMN itm_item_qualify_applyd.spu_code2 IS 'SPU_CODE2';
COMMENT ON COLUMN itm_item_qualify_applyd.spu_code3 IS 'SPU_CODE3';
COMMENT ON COLUMN itm_item_qualify_applyd.spu_name IS 'SPU_NAME';
COMMENT ON COLUMN itm_item_qualify_applyd.spu_name2 IS 'SPU_NAME2';
COMMENT ON COLUMN itm_item_qualify_applyd.spu_name3 IS 'SPU_NAME3';
COMMENT ON COLUMN itm_item_qualify_applyd.qualify_type IS '资质类型 [UDC]ITM:QUALIFY_TYPE';
COMMENT ON COLUMN itm_item_qualify_applyd.qualify_name IS '资质名称';
COMMENT ON COLUMN itm_item_qualify_applyd.qualify_no IS '资质编号';
COMMENT ON COLUMN itm_item_qualify_applyd.qualify_file_name IS '资质文件名称';
COMMENT ON COLUMN itm_item_qualify_applyd.qualify_file_code IS '资质文件编号';
COMMENT ON COLUMN itm_item_qualify_applyd.valid_from IS '生效日期';
COMMENT ON COLUMN itm_item_qualify_applyd.valid_to IS '失效日期';
COMMENT ON COLUMN itm_item_qualify_applyd.next_check_date IS '下次检查日期';
COMMENT ON COLUMN itm_item_qualify_applyd.longterm_flag IS '是否长期有效';
COMMENT ON COLUMN itm_item_qualify_applyd.qualify_status IS '资质证照状态 [UDC]COM:STATUS_ACTIVEORNO';
COMMENT ON COLUMN itm_item_qualify_applyd.qualify_status2 IS '资质证照状态2';
COMMENT ON COLUMN itm_item_qualify_applyd.qualify_owner IS '证照所有者';
COMMENT ON COLUMN itm_item_qualify_applyd.related_id1 IS '关联ID1';
COMMENT ON COLUMN itm_item_qualify_applyd.related_id2 IS '关联ID2';
COMMENT ON COLUMN itm_item_qualify_applyd.es1 IS 'ES1';
COMMENT ON COLUMN itm_item_qualify_applyd.es2 IS 'ES2';
COMMENT ON COLUMN itm_item_qualify_applyd.es3 IS 'ES3';
COMMENT ON COLUMN itm_item_qualify_applyd.es4 IS 'ES4';
COMMENT ON COLUMN itm_item_qualify_applyd.es5 IS 'ES5';
COMMENT ON COLUMN itm_item_qualify_applyd.es6 IS 'ES6';
COMMENT ON COLUMN itm_item_qualify_applyd.es7 IS 'ES7';
COMMENT ON COLUMN itm_item_qualify_applyd.es8 IS 'ES8';
COMMENT ON COLUMN itm_item_qualify_applyd.es9 IS 'ES9';
COMMENT ON COLUMN itm_item_qualify_applyd.es10 IS 'ES10';
COMMENT ON COLUMN itm_item_qualify_applyd.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_qualify_applyd.remark IS '备注';
COMMENT ON COLUMN itm_item_qualify_applyd.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_qualify_applyd.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_qualify_applyd.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_qualify_applyd.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_qualify_applyd.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_qualify_applyd.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_qualify_applyd.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_qualify_applyd.audit_data_version IS '锁版本';
COMMENT ON COLUMN itm_item_qualify_applyd.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_qualify_applyd.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_qualify_applyd.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_qualify_applyd.doc_no IS '单据编号';
COMMENT ON TABLE itm_item_qualify_applyd IS '商品资质信息_履历';

-- ----------------------------
-- Records of itm_item_qualify_applyd
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_sku_business
-- ----------------------------
CREATE TABLE itm_item_sku_business (
  id NUMBER(20) NOT NULL,
  item_id NUMBER(20),
  item_code NVARCHAR2(32),
  spu_id NUMBER(20),
  spu_code NVARCHAR2(40),
  item_source NVARCHAR2(40),
  bu_code NVARCHAR2(40),
  item_life_status NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20)
)
;
COMMENT ON COLUMN itm_item_sku_business.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_sku_business.item_id IS 'skuId';
COMMENT ON COLUMN itm_item_sku_business.item_code IS '商品编码（sku编码）';
COMMENT ON COLUMN itm_item_sku_business.spu_id IS 'SPU_ID';
COMMENT ON COLUMN itm_item_sku_business.spu_code IS 'SPU_CODE';
COMMENT ON COLUMN itm_item_sku_business.item_source IS '商品来源组织';
COMMENT ON COLUMN itm_item_sku_business.bu_code IS '商品所属公司';
COMMENT ON COLUMN itm_item_sku_business.item_life_status IS '生命状态';
COMMENT ON COLUMN itm_item_sku_business.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_sku_business.remark IS '备注';
COMMENT ON COLUMN itm_item_sku_business.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_sku_business.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_sku_business.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_sku_business.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_sku_business.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_sku_business.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_sku_business.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_sku_business.audit_data_version IS '锁版本';
COMMENT ON COLUMN itm_item_sku_business.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_sku_business.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_sku_business.sec_ou_id IS 'sec_ou_id';
COMMENT ON TABLE itm_item_sku_business IS '商品sku经营目录表';

-- ----------------------------
-- Records of itm_item_sku_business
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_status_config
-- ----------------------------
CREATE TABLE itm_item_status_config (
  id NUMBER(20) NOT NULL,
  business_type NVARCHAR2(40),
  business_code NVARCHAR2(40),
  business_name NVARCHAR2(40),
  business_desc NVARCHAR2(40),
  config_status NVARCHAR2(40),
  check_basic_status NUMBER(11),
  check_shop_status NUMBER(11),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  data_sign NVARCHAR2(40),
  busin_excu_sign_status1 NUMBER(11),
  busin_excu_sign_status2 NUMBER(11),
  busin_excu_sign_status3 NUMBER(11),
  busin_excu_sign_status4 NUMBER(11),
  busin_excu_sign_status5 NUMBER(11),
  busin_excu_sign_status6 NUMBER(11),
  busin_excu_sign_status7 NUMBER(11),
  busin_excu_sign_status8 NUMBER(11),
  busin_excu_sign_status9 NUMBER(11),
  busin_excu_sign_status10 NUMBER(11),
  enable NUMBER(11),
  sale_freeze NUMBER(11),
  purc_freeze NUMBER(11)
)
;
COMMENT ON COLUMN itm_item_status_config.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_status_config.business_type IS '业务';
COMMENT ON COLUMN itm_item_status_config.business_code IS '对应场景代码';
COMMENT ON COLUMN itm_item_status_config.business_name IS '场景名称';
COMMENT ON COLUMN itm_item_status_config.business_desc IS '场景说明';
COMMENT ON COLUMN itm_item_status_config.config_status IS '配置状态';
COMMENT ON COLUMN itm_item_status_config.check_basic_status IS '是否校验basic商品状态';
COMMENT ON COLUMN itm_item_status_config.check_shop_status IS '是否校验经营目录商品状态';
COMMENT ON COLUMN itm_item_status_config.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_status_config.remark IS '备注';
COMMENT ON COLUMN itm_item_status_config.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_status_config.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_status_config.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_status_config.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_status_config.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_status_config.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_status_config.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_status_config.audit_data_version IS '锁版本';
COMMENT ON COLUMN itm_item_status_config.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_status_config.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_status_config.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_status_config.data_sign IS '数据标识';
COMMENT ON COLUMN itm_item_status_config.busin_excu_sign_status1 IS '正常';
COMMENT ON COLUMN itm_item_status_config.busin_excu_sign_status2 IS '销售冻结';
COMMENT ON COLUMN itm_item_status_config.busin_excu_sign_status3 IS '采购冻结';
COMMENT ON COLUMN itm_item_status_config.busin_excu_sign_status4 IS '业务执行标识4';
COMMENT ON COLUMN itm_item_status_config.busin_excu_sign_status5 IS '业务执行标识5';
COMMENT ON COLUMN itm_item_status_config.busin_excu_sign_status6 IS '业务执行标识6';
COMMENT ON COLUMN itm_item_status_config.busin_excu_sign_status7 IS '业务执行标识7';
COMMENT ON COLUMN itm_item_status_config.busin_excu_sign_status8 IS '业务执行标识8';
COMMENT ON COLUMN itm_item_status_config.busin_excu_sign_status9 IS '业务执行标识9';
COMMENT ON COLUMN itm_item_status_config.busin_excu_sign_status10 IS '业务执行标识4910';
COMMENT ON COLUMN itm_item_status_config.enable IS '正常';
COMMENT ON COLUMN itm_item_status_config.sale_freeze IS '销售冻结';
COMMENT ON COLUMN itm_item_status_config.purc_freeze IS '采购冻结';
COMMENT ON TABLE itm_item_status_config IS '商品状态配置表';

-- ----------------------------
-- Records of itm_item_status_config
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_tag
-- ----------------------------
CREATE TABLE itm_item_tag (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  item_id NUMBER(20),
  upper_tag_code NVARCHAR2(32),
  upper_tag_name NVARCHAR2(32),
  tag_code NVARCHAR2(32),
  tag_name NVARCHAR2(32),
  status NVARCHAR2(8),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_item_tag.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_tag.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_tag.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_tag.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_tag.item_id IS '商品ID';
COMMENT ON COLUMN itm_item_tag.upper_tag_code IS '上级标签编码';
COMMENT ON COLUMN itm_item_tag.upper_tag_name IS '上级标签名称';
COMMENT ON COLUMN itm_item_tag.tag_code IS '标签编码';
COMMENT ON COLUMN itm_item_tag.tag_name IS '标签名称';
COMMENT ON COLUMN itm_item_tag.status IS '状态';
COMMENT ON COLUMN itm_item_tag.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_tag.remark IS '备注';
COMMENT ON COLUMN itm_item_tag.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_tag.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_tag.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_tag.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_tag.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_tag.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_tag.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_tag.audit_data_version IS '锁版本';
COMMENT ON TABLE itm_item_tag IS '商品标签';

-- ----------------------------
-- Records of itm_item_tag
-- ----------------------------



-- ----------------------------
-- Table structure for itm_item_tag_applyd
-- ----------------------------
CREATE TABLE itm_item_tag_applyd (
  id NUMBER(20) NOT NULL,
  item_id NUMBER(20),
  upper_tag_code NVARCHAR2(32),
  upper_tag_name NVARCHAR2(32),
  tag_code NVARCHAR2(32),
  tag_name NVARCHAR2(32),
  status NVARCHAR2(8),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  doc_no NVARCHAR2(32)
)
;
COMMENT ON COLUMN itm_item_tag_applyd.id IS '记录唯一ID';
COMMENT ON COLUMN itm_item_tag_applyd.item_id IS '商品ID';
COMMENT ON COLUMN itm_item_tag_applyd.upper_tag_code IS '上级标签编码';
COMMENT ON COLUMN itm_item_tag_applyd.upper_tag_name IS '上级标签名称';
COMMENT ON COLUMN itm_item_tag_applyd.tag_code IS '标签编码';
COMMENT ON COLUMN itm_item_tag_applyd.tag_name IS '标签名称';
COMMENT ON COLUMN itm_item_tag_applyd.status IS '状态';
COMMENT ON COLUMN itm_item_tag_applyd.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_item_tag_applyd.remark IS '备注';
COMMENT ON COLUMN itm_item_tag_applyd.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_item_tag_applyd.creator IS '记录创建者';
COMMENT ON COLUMN itm_item_tag_applyd.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_item_tag_applyd.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_item_tag_applyd.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_item_tag_applyd.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_item_tag_applyd.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_item_tag_applyd.audit_data_version IS '锁版本';
COMMENT ON COLUMN itm_item_tag_applyd.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_item_tag_applyd.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_item_tag_applyd.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_item_tag_applyd.doc_no IS '单据编号';
COMMENT ON TABLE itm_item_tag_applyd IS '商品标签_履历';

-- ----------------------------
-- Records of itm_item_tag_applyd
-- ----------------------------



-- ----------------------------
-- Table structure for itm_itemuom_conv
-- ----------------------------
CREATE TABLE itm_itemuom_conv (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  item_id NUMBER(20),
  from_uom NVARCHAR2(40),
  to_uom NVARCHAR2(40),
  ratio NUMBER,
  revert_ratio NUMBER,
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_itemuom_conv.id IS '记录唯一ID';
COMMENT ON COLUMN itm_itemuom_conv.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_itemuom_conv.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_itemuom_conv.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_itemuom_conv.item_id IS '商品id';
COMMENT ON COLUMN itm_itemuom_conv.from_uom IS '从单位';
COMMENT ON COLUMN itm_itemuom_conv.to_uom IS '到单位';
COMMENT ON COLUMN itm_itemuom_conv.ratio IS '转换系数';
COMMENT ON COLUMN itm_itemuom_conv.revert_ratio IS '反向系数';
COMMENT ON COLUMN itm_itemuom_conv.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_itemuom_conv.remark IS '备注';
COMMENT ON COLUMN itm_itemuom_conv.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_itemuom_conv.creator IS '记录创建者';
COMMENT ON COLUMN itm_itemuom_conv.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_itemuom_conv.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_itemuom_conv.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_itemuom_conv.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_itemuom_conv.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_itemuom_conv.audit_data_version IS '锁版本';
COMMENT ON TABLE itm_itemuom_conv IS '商品计量单位转换';

-- ----------------------------
-- Records of itm_itemuom_conv
-- ----------------------------



-- ----------------------------
-- Table structure for itm_itemuom_conv_applyd
-- ----------------------------
CREATE TABLE itm_itemuom_conv_applyd (
  id NUMBER(20) NOT NULL,
  item_id NUMBER(20),
  from_uom NVARCHAR2(40),
  to_uom NVARCHAR2(40),
  ratio NUMBER,
  revert_ratio NUMBER,
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  doc_no NVARCHAR2(32)
)
;
COMMENT ON COLUMN itm_itemuom_conv_applyd.id IS '记录唯一ID';
COMMENT ON COLUMN itm_itemuom_conv_applyd.item_id IS '商品id';
COMMENT ON COLUMN itm_itemuom_conv_applyd.from_uom IS '从单位';
COMMENT ON COLUMN itm_itemuom_conv_applyd.to_uom IS '到单位';
COMMENT ON COLUMN itm_itemuom_conv_applyd.ratio IS '转换系数';
COMMENT ON COLUMN itm_itemuom_conv_applyd.revert_ratio IS '反向系数';
COMMENT ON COLUMN itm_itemuom_conv_applyd.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_itemuom_conv_applyd.remark IS '备注';
COMMENT ON COLUMN itm_itemuom_conv_applyd.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_itemuom_conv_applyd.creator IS '记录创建者';
COMMENT ON COLUMN itm_itemuom_conv_applyd.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_itemuom_conv_applyd.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_itemuom_conv_applyd.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_itemuom_conv_applyd.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_itemuom_conv_applyd.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_itemuom_conv_applyd.audit_data_version IS '锁版本';
COMMENT ON COLUMN itm_itemuom_conv_applyd.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_itemuom_conv_applyd.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_itemuom_conv_applyd.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_itemuom_conv_applyd.doc_no IS '单据编号';
COMMENT ON TABLE itm_itemuom_conv_applyd IS '商品计量单位转换_履历';

-- ----------------------------
-- Records of itm_itemuom_conv_applyd
-- ----------------------------



-- ----------------------------
-- Table structure for itm_life_status_scheduling
-- ----------------------------
CREATE TABLE itm_life_status_scheduling (
  id NUMBER(20) NOT NULL,
  ou_id NUMBER(20),
  ou_code NVARCHAR2(40),
  ou_name NVARCHAR2(40),
  bu_id NUMBER(20),
  bu_code NVARCHAR2(40),
  bu_name NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  life_status_code NVARCHAR2(40),
  item_source NVARCHAR2(40),
  item_id NUMBER(20),
  item_code NVARCHAR2(40),
  item_name NVARCHAR2(40),
  branch_plant NVARCHAR2(40),
  global_or_not NUMBER(11),
  item_life_status NVARCHAR2(40),
  valid_from DATE,
  valid_to DATE,
  status NUMBER(11)
)
;
COMMENT ON COLUMN itm_life_status_scheduling.id IS '记录唯一ID';
COMMENT ON COLUMN itm_life_status_scheduling.ou_id IS '创建人所属公司id';
COMMENT ON COLUMN itm_life_status_scheduling.ou_code IS '创建人所属公司编码';
COMMENT ON COLUMN itm_life_status_scheduling.ou_name IS '创建人所属公司名称';
COMMENT ON COLUMN itm_life_status_scheduling.bu_id IS 'BU ID';
COMMENT ON COLUMN itm_life_status_scheduling.bu_code IS 'BU编号';
COMMENT ON COLUMN itm_life_status_scheduling.bu_name IS 'BU名称';
COMMENT ON COLUMN itm_life_status_scheduling.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_life_status_scheduling.remark IS '备注';
COMMENT ON COLUMN itm_life_status_scheduling.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_life_status_scheduling.creator IS '记录创建者';
COMMENT ON COLUMN itm_life_status_scheduling.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_life_status_scheduling.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_life_status_scheduling.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_life_status_scheduling.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_life_status_scheduling.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_life_status_scheduling.audit_data_version IS '锁版本';
COMMENT ON COLUMN itm_life_status_scheduling.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_life_status_scheduling.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_life_status_scheduling.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_life_status_scheduling.life_status_code IS '生命状态编码';
COMMENT ON COLUMN itm_life_status_scheduling.item_source IS '商品来源';
COMMENT ON COLUMN itm_life_status_scheduling.item_id IS '商品ID';
COMMENT ON COLUMN itm_life_status_scheduling.item_code IS '商品编号';
COMMENT ON COLUMN itm_life_status_scheduling.item_name IS '商品名称';
COMMENT ON COLUMN itm_life_status_scheduling.branch_plant IS '范围';
COMMENT ON COLUMN itm_life_status_scheduling.global_or_not IS '是否全局';
COMMENT ON COLUMN itm_life_status_scheduling.item_life_status IS '生命状态';
COMMENT ON COLUMN itm_life_status_scheduling.valid_from IS '生效时间';
COMMENT ON COLUMN itm_life_status_scheduling.valid_to IS '失效时间';
COMMENT ON COLUMN itm_life_status_scheduling.status IS '活动状态';
COMMENT ON TABLE itm_life_status_scheduling IS '商品生命状态日程表';

-- ----------------------------
-- Records of itm_life_status_scheduling
-- ----------------------------



-- ----------------------------
-- Table structure for itm_prop
-- ----------------------------
CREATE TABLE itm_prop (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  cate_prop_code NVARCHAR2(40),
  cate_prop_name NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_prop.id IS '记录唯一ID';
COMMENT ON COLUMN itm_prop.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN itm_prop.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN itm_prop.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN itm_prop.cate_prop_code IS '属性名编码';
COMMENT ON COLUMN itm_prop.cate_prop_name IS '属性名名称';
COMMENT ON COLUMN itm_prop.tenant_id IS '租户ID';
COMMENT ON COLUMN itm_prop.remark IS '备注';
COMMENT ON COLUMN itm_prop.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN itm_prop.creator IS '记录创建者';
COMMENT ON COLUMN itm_prop.create_time IS '记录创建时间';
COMMENT ON COLUMN itm_prop.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN itm_prop.updater IS '记录最后更新者';
COMMENT ON COLUMN itm_prop.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN itm_prop.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN itm_prop.audit_data_version IS '锁版本';
COMMENT ON TABLE itm_prop IS '属性表';

-- ----------------------------
-- Records of itm_prop
-- ----------------------------



-- ----------------------------
-- Table structure for itm_tag
-- ----------------------------
CREATE TABLE itm_tag (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  pid NUMBER(20) NOT NULL,
  sort_no NUMBER(11),
  grade NUMBER(11),
  id_path NVARCHAR2(255),
  code_path NVARCHAR2(255),
  tag_code NVARCHAR2(32),
  tag_name NVARCHAR2(32),
  tag_type NVARCHAR2(8),
  tag_desc NVARCHAR2(255),
  status NVARCHAR2(8),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN itm_tag.tag_code IS '标签编码';
COMMENT ON COLUMN itm_tag.tag_name IS '标签名称';
COMMENT ON COLUMN itm_tag.tag_type IS '标签类型';
COMMENT ON COLUMN itm_tag.tag_desc IS '标签描述';
COMMENT ON COLUMN itm_tag.status IS '状态';
COMMENT ON TABLE itm_tag IS '标签';

-- ----------------------------
-- Records of itm_tag
-- ----------------------------



-- ----------------------------
-- Table structure for org_addr
-- ----------------------------
CREATE TABLE org_addr (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  bu_id NUMBER(20),
  bu_code NVARCHAR2(32),
  bu_name NVARCHAR2(32),
  addr_no NUMBER(20) NOT NULL,
  line_no NUMBER(11),
  addr_code NVARCHAR2(40),
  addr_type NVARCHAR2(40),
  addr_type2 NVARCHAR2(32),
  addr_type3 NVARCHAR2(32),
  addr_name NVARCHAR2(40),
  addr_abbr NVARCHAR2(40),
  addr_status NVARCHAR2(32),
  addr_status2 NVARCHAR2(32),
  addr_status3 NVARCHAR2(32),
  legal_addr_no NUMBER(20),
  src_cls NVARCHAR2(32),
  src_id NUMBER(20),
  outer_code NVARCHAR2(32),
  es1 NVARCHAR2(32),
  es2 NVARCHAR2(32),
  es3 NVARCHAR2(32),
  es4 NVARCHAR2(32),
  es5 NVARCHAR2(32),
  es6 NVARCHAR2(32),
  es7 NVARCHAR2(32),
  es8 NVARCHAR2(32),
  es9 NVARCHAR2(32),
  es10 NVARCHAR2(32),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN org_addr.id IS '记录唯一ID';
COMMENT ON COLUMN org_addr.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN org_addr.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN org_addr.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN org_addr.bu_id IS 'BU_ID';
COMMENT ON COLUMN org_addr.bu_code IS 'BU编号';
COMMENT ON COLUMN org_addr.bu_name IS 'BU名称';
COMMENT ON COLUMN org_addr.addr_no IS '地址号';
COMMENT ON COLUMN org_addr.line_no IS '行号';
COMMENT ON COLUMN org_addr.addr_code IS '地址薄编号';
COMMENT ON COLUMN org_addr.addr_type IS '地址薄类型:[UDC]ORG:ADDR_TYPE';
COMMENT ON COLUMN org_addr.addr_type2 IS '地址薄类型2';
COMMENT ON COLUMN org_addr.addr_type3 IS '地址薄类型3';
COMMENT ON COLUMN org_addr.addr_name IS '地址薄名称';
COMMENT ON COLUMN org_addr.addr_abbr IS '地址薄简称';
COMMENT ON COLUMN org_addr.addr_status IS '地址薄状态';
COMMENT ON COLUMN org_addr.addr_status2 IS '地址薄状态2';
COMMENT ON COLUMN org_addr.addr_status3 IS '地址薄状态3';
COMMENT ON COLUMN org_addr.legal_addr_no IS '法人地址号';
COMMENT ON COLUMN org_addr.src_cls IS '来源类别';
COMMENT ON COLUMN org_addr.src_id IS '来源ID';
COMMENT ON COLUMN org_addr.outer_code IS '外部编码';
COMMENT ON COLUMN org_addr.es1 IS 'ES1';
COMMENT ON COLUMN org_addr.es2 IS 'ES2';
COMMENT ON COLUMN org_addr.es3 IS 'ES3';
COMMENT ON COLUMN org_addr.es4 IS 'ES4';
COMMENT ON COLUMN org_addr.es5 IS 'ES5';
COMMENT ON COLUMN org_addr.es6 IS 'ES6';
COMMENT ON COLUMN org_addr.es7 IS 'ES7';
COMMENT ON COLUMN org_addr.es8 IS 'ES8';
COMMENT ON COLUMN org_addr.es9 IS 'ES9';
COMMENT ON COLUMN org_addr.es10 IS 'ES10';
COMMENT ON COLUMN org_addr.tenant_id IS '租户ID';
COMMENT ON COLUMN org_addr.remark IS '备注';
COMMENT ON COLUMN org_addr.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN org_addr.creator IS '记录创建者';
COMMENT ON COLUMN org_addr.create_time IS '记录创建时间';
COMMENT ON COLUMN org_addr.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN org_addr.updater IS '记录最后更新者';
COMMENT ON COLUMN org_addr.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN org_addr.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN org_addr.audit_data_version IS '锁版本';
COMMENT ON TABLE org_addr IS '地址簿';



-- ----------------------------
-- Table structure for org_addr_address
-- ----------------------------
CREATE TABLE org_addr_address (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  bu_id NUMBER(20),
  bu_code NVARCHAR2(32),
  bu_name NVARCHAR2(32),
  addr_no NUMBER(20) NOT NULL,
  line_no NUMBER(11),
  address_name NVARCHAR2(32),
  address_type NVARCHAR2(32),
  address_type2 NVARCHAR2(32),
  default_flag NUMBER(4),
  address_status NVARCHAR2(32),
  cont_person NVARCHAR2(32),
  mobile NVARCHAR2(32),
  mobile2 NVARCHAR2(32),
  tel NVARCHAR2(32),
  tel2 NVARCHAR2(32),
  fax NVARCHAR2(32),
  email NVARCHAR2(32),
  email2 NVARCHAR2(32),
  country NVARCHAR2(32),
  province NVARCHAR2(32),
  city NVARCHAR2(32),
  county NVARCHAR2(32),
  street NVARCHAR2(255),
  detail_addr NVARCHAR2(255),
  tp_type NVARCHAR2(255),
  x_lon NUMBER,
  y_lat NUMBER,
  coord_type NVARCHAR2(32),
  zip_code NVARCHAR2(32),
  web_address NVARCHAR2(32),
  weibo NVARCHAR2(32),
  wechat_mp NVARCHAR2(32),
  other_info1 NVARCHAR2(32),
  other_info2 NVARCHAR2(32),
  other_info3 NVARCHAR2(32),
  position NVARCHAR2(32),
  pid NUMBER(20),
  es1 NVARCHAR2(255),
  es2 NVARCHAR2(255),
  es3 NVARCHAR2(255),
  es4 NVARCHAR2(255),
  es5 NVARCHAR2(255),
  es6 NVARCHAR2(255),
  es7 NVARCHAR2(255),
  es8 NVARCHAR2(255),
  es9 NVARCHAR2(255),
  es10 NVARCHAR2(255),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN org_addr_address.id IS '记录唯一ID';
COMMENT ON COLUMN org_addr_address.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN org_addr_address.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN org_addr_address.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN org_addr_address.bu_id IS 'BU_ID';
COMMENT ON COLUMN org_addr_address.bu_code IS 'BU编号';
COMMENT ON COLUMN org_addr_address.bu_name IS 'BU名称';
COMMENT ON COLUMN org_addr_address.addr_no IS '地址号';
COMMENT ON COLUMN org_addr_address.line_no IS '行号';
COMMENT ON COLUMN org_addr_address.address_name IS '地址名称';
COMMENT ON COLUMN org_addr_address.address_type IS '地址类型(指送货地址，开票地址等):[UDC]ORG:ADDRESS_TYPE';
COMMENT ON COLUMN org_addr_address.address_type2 IS '地址类型2';
COMMENT ON COLUMN org_addr_address.default_flag IS '是否默认：1是，0否';
COMMENT ON COLUMN org_addr_address.address_status IS '地址状态';
COMMENT ON COLUMN org_addr_address.cont_person IS '联系人姓名';
COMMENT ON COLUMN org_addr_address.mobile IS '手机号码';
COMMENT ON COLUMN org_addr_address.mobile2 IS '手机号码2';
COMMENT ON COLUMN org_addr_address.tel IS '电话';
COMMENT ON COLUMN org_addr_address.tel2 IS '电话2';
COMMENT ON COLUMN org_addr_address.fax IS '传真';
COMMENT ON COLUMN org_addr_address.email IS '电邮';
COMMENT ON COLUMN org_addr_address.email2 IS '电邮2';
COMMENT ON COLUMN org_addr_address.country IS '国家';
COMMENT ON COLUMN org_addr_address.province IS '省份';
COMMENT ON COLUMN org_addr_address.city IS '城市';
COMMENT ON COLUMN org_addr_address.county IS '区县';
COMMENT ON COLUMN org_addr_address.street IS '街道/乡镇';
COMMENT ON COLUMN org_addr_address.detail_addr IS '详细地址';
COMMENT ON COLUMN org_addr_address.tp_type IS '默认运输方式';
COMMENT ON COLUMN org_addr_address.x_lon IS '经度';
COMMENT ON COLUMN org_addr_address.y_lat IS '纬度';
COMMENT ON COLUMN org_addr_address.coord_type IS '经纬度标准';
COMMENT ON COLUMN org_addr_address.zip_code IS '邮政编码';
COMMENT ON COLUMN org_addr_address.web_address IS '网址';
COMMENT ON COLUMN org_addr_address.weibo IS '微博';
COMMENT ON COLUMN org_addr_address.wechat_mp IS '微信公众号';
COMMENT ON COLUMN org_addr_address.other_info1 IS '其它联系信息1';
COMMENT ON COLUMN org_addr_address.other_info2 IS '其它联系信息2';
COMMENT ON COLUMN org_addr_address.other_info3 IS '其它联系信息3';
COMMENT ON COLUMN org_addr_address.position IS '职位';
COMMENT ON COLUMN org_addr_address.pid IS '上级联系人ID';
COMMENT ON COLUMN org_addr_address.es1 IS 'ES1';
COMMENT ON COLUMN org_addr_address.es2 IS 'ES2';
COMMENT ON COLUMN org_addr_address.es3 IS 'ES3';
COMMENT ON COLUMN org_addr_address.es4 IS 'ES4';
COMMENT ON COLUMN org_addr_address.es5 IS 'ES5';
COMMENT ON COLUMN org_addr_address.es6 IS 'ES6';
COMMENT ON COLUMN org_addr_address.es7 IS 'ES7';
COMMENT ON COLUMN org_addr_address.es8 IS 'ES8';
COMMENT ON COLUMN org_addr_address.es9 IS 'ES9';
COMMENT ON COLUMN org_addr_address.es10 IS 'ES10';
COMMENT ON COLUMN org_addr_address.tenant_id IS '租户ID';
COMMENT ON COLUMN org_addr_address.remark IS '备注';
COMMENT ON COLUMN org_addr_address.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN org_addr_address.creator IS '记录创建者';
COMMENT ON COLUMN org_addr_address.create_time IS '记录创建时间';
COMMENT ON COLUMN org_addr_address.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN org_addr_address.updater IS '记录最后更新者';
COMMENT ON COLUMN org_addr_address.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN org_addr_address.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN org_addr_address.audit_data_version IS '锁版本';
COMMENT ON TABLE org_addr_address IS '地址簿地址信息';



-- ----------------------------
-- Table structure for org_addr_bank_acc
-- ----------------------------
CREATE TABLE org_addr_bank_acc (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  thirdparty_virtual_user_id NVARCHAR2(255),
  thirdparty_virtual_acc NVARCHAR2(255),
  bu_id NUMBER(20),
  bu_code NVARCHAR2(32),
  bu_name NVARCHAR2(32),
  addr_no NUMBER(20) NOT NULL,
  line_no NUMBER(11),
  acc_code NVARCHAR2(32),
  acc_type NVARCHAR2(32),
  default_flag NUMBER(4),
  bank_id NUMBER(20),
  bank_code NVARCHAR2(32),
  bank_name NVARCHAR2(32),
  branch_name NVARCHAR2(32),
  bank_acc NVARCHAR2(255),
  holder_name NVARCHAR2(32),
  curr_code NVARCHAR2(32),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  bank_account_name NVARCHAR2(255),
  bank_account_comp NVARCHAR2(255),
  pay_collect_method NVARCHAR2(32)
)
;
COMMENT ON COLUMN org_addr_bank_acc.id IS '记录唯一ID';
COMMENT ON COLUMN org_addr_bank_acc.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN org_addr_bank_acc.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN org_addr_bank_acc.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN org_addr_bank_acc.thirdparty_virtual_user_id IS '第三方虚拟用户ID';
COMMENT ON COLUMN org_addr_bank_acc.thirdparty_virtual_acc IS '第三方虚拟帐户';
COMMENT ON COLUMN org_addr_bank_acc.bu_id IS 'BU_ID';
COMMENT ON COLUMN org_addr_bank_acc.bu_code IS 'BU编号';
COMMENT ON COLUMN org_addr_bank_acc.bu_name IS 'BU名称';
COMMENT ON COLUMN org_addr_bank_acc.addr_no IS '地址号';
COMMENT ON COLUMN org_addr_bank_acc.line_no IS '行号';
COMMENT ON COLUMN org_addr_bank_acc.acc_code IS '账号编号';
COMMENT ON COLUMN org_addr_bank_acc.acc_type IS '账号类型:[UDC]ORG:ADDR_BANKACC_TYPE';
COMMENT ON COLUMN org_addr_bank_acc.default_flag IS '是否默认：1是，0否';
COMMENT ON COLUMN org_addr_bank_acc.bank_id IS '银行ID';
COMMENT ON COLUMN org_addr_bank_acc.bank_code IS '银行编号';
COMMENT ON COLUMN org_addr_bank_acc.bank_name IS '银行名称';
COMMENT ON COLUMN org_addr_bank_acc.branch_name IS '网点名称';
COMMENT ON COLUMN org_addr_bank_acc.bank_acc IS '开户行账号';
COMMENT ON COLUMN org_addr_bank_acc.holder_name IS '开户人姓名';
COMMENT ON COLUMN org_addr_bank_acc.curr_code IS '币种';
COMMENT ON COLUMN org_addr_bank_acc.tenant_id IS '租户ID';
COMMENT ON COLUMN org_addr_bank_acc.remark IS '备注';
COMMENT ON COLUMN org_addr_bank_acc.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN org_addr_bank_acc.creator IS '记录创建者';
COMMENT ON COLUMN org_addr_bank_acc.create_time IS '记录创建时间';
COMMENT ON COLUMN org_addr_bank_acc.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN org_addr_bank_acc.updater IS '记录最后更新者';
COMMENT ON COLUMN org_addr_bank_acc.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN org_addr_bank_acc.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN org_addr_bank_acc.audit_data_version IS '锁版本';
COMMENT ON COLUMN org_addr_bank_acc.bank_account_name IS '开户行账户名称';
COMMENT ON COLUMN org_addr_bank_acc.bank_account_comp IS '开户行账户组合';
COMMENT ON COLUMN org_addr_bank_acc.pay_collect_method IS '收付款方式 [UDC]COM:PAY_METHOD';
COMMENT ON TABLE org_addr_bank_acc IS '地址簿银行账号信息';



-- ----------------------------
-- Table structure for org_addr_qualify
-- ----------------------------
CREATE TABLE org_addr_qualify (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  bu_id NUMBER(20),
  bu_code NVARCHAR2(32),
  bu_name NVARCHAR2(32),
  addr_no NUMBER(20) NOT NULL,
  line_no NUMBER(11),
  qualify_type NVARCHAR2(32),
  qualify_name NVARCHAR2(32),
  qualify_no NVARCHAR2(32),
  qualify_file_id NUMBER(20),
  qualify_file_name NVARCHAR2(255),
  qualify_file_code NVARCHAR2(255),
  valid_from DATE,
  valid_to DATE,
  next_check_date DATE,
  lang_term_flag NUMBER(4),
  qualify_status NVARCHAR2(32),
  qualify_status2 NVARCHAR2(32),
  qualify_owner NVARCHAR2(32),
  es1 NVARCHAR2(255),
  es2 NVARCHAR2(255),
  es3 NVARCHAR2(255),
  es4 NVARCHAR2(255),
  es5 NVARCHAR2(255),
  es6 NVARCHAR2(255),
  es7 NVARCHAR2(255),
  es8 NVARCHAR2(255),
  es9 NCLOB,
  es10 NVARCHAR2(255),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN org_addr_qualify.id IS '记录唯一ID';
COMMENT ON COLUMN org_addr_qualify.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN org_addr_qualify.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN org_addr_qualify.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN org_addr_qualify.bu_id IS 'BU_ID';
COMMENT ON COLUMN org_addr_qualify.bu_code IS 'BU编号';
COMMENT ON COLUMN org_addr_qualify.bu_name IS 'BU名称';
COMMENT ON COLUMN org_addr_qualify.addr_no IS '地址号';
COMMENT ON COLUMN org_addr_qualify.line_no IS '行号';
COMMENT ON COLUMN org_addr_qualify.qualify_type IS '资质类型:[UDC]ORG:ADDR_QUALIFY_TYPE';
COMMENT ON COLUMN org_addr_qualify.qualify_name IS '资质名称';
COMMENT ON COLUMN org_addr_qualify.qualify_no IS '资质文件编号(文件自己的编号)';
COMMENT ON COLUMN org_addr_qualify.qualify_file_id IS '资质文件ID';
COMMENT ON COLUMN org_addr_qualify.qualify_file_name IS '资质文件名称';
COMMENT ON COLUMN org_addr_qualify.qualify_file_code IS '资质文件编号(上传后系统生成的编号';
COMMENT ON COLUMN org_addr_qualify.valid_from IS '生效日期';
COMMENT ON COLUMN org_addr_qualify.valid_to IS '失效日期';
COMMENT ON COLUMN org_addr_qualify.next_check_date IS '下次检验日期';
COMMENT ON COLUMN org_addr_qualify.lang_term_flag IS '是否长期有效：1是，0否';
COMMENT ON COLUMN org_addr_qualify.qualify_status IS '资质证照状态:[UDC]COM:STATUS_ACTIVEORNO';
COMMENT ON COLUMN org_addr_qualify.qualify_status2 IS '资质证照状态2';
COMMENT ON COLUMN org_addr_qualify.qualify_owner IS '证照所有者';
COMMENT ON COLUMN org_addr_qualify.es1 IS 'ES1';
COMMENT ON COLUMN org_addr_qualify.es2 IS 'ES2';
COMMENT ON COLUMN org_addr_qualify.es3 IS 'ES3';
COMMENT ON COLUMN org_addr_qualify.es4 IS 'ES4';
COMMENT ON COLUMN org_addr_qualify.es5 IS 'ES5';
COMMENT ON COLUMN org_addr_qualify.es6 IS 'ES6';
COMMENT ON COLUMN org_addr_qualify.es7 IS 'ES7';
COMMENT ON COLUMN org_addr_qualify.es8 IS 'ES8';
COMMENT ON COLUMN org_addr_qualify.es9 IS 'ES9';
COMMENT ON COLUMN org_addr_qualify.es10 IS 'ES10';
COMMENT ON COLUMN org_addr_qualify.tenant_id IS '租户ID';
COMMENT ON COLUMN org_addr_qualify.remark IS '备注';
COMMENT ON COLUMN org_addr_qualify.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN org_addr_qualify.creator IS '记录创建者';
COMMENT ON COLUMN org_addr_qualify.create_time IS '记录创建时间';
COMMENT ON COLUMN org_addr_qualify.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN org_addr_qualify.updater IS '记录最后更新者';
COMMENT ON COLUMN org_addr_qualify.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN org_addr_qualify.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN org_addr_qualify.audit_data_version IS '锁版本';
COMMENT ON TABLE org_addr_qualify IS '地址簿资质信息';

-- ----------------------------
-- Records of org_addr_qualify
-- ----------------------------



-- ----------------------------
-- Table structure for org_area
-- ----------------------------
CREATE TABLE org_area (
  id NUMBER(20) NOT NULL,
  ou_id NUMBER(20),
  bu_id NUMBER(20),
  bu_code NVARCHAR2(32),
  bu_name NVARCHAR2(32),
  province NVARCHAR2(32),
  city NVARCHAR2(32),
  county NVARCHAR2(32),
  street NVARCHAR2(255),
  detail_addr NVARCHAR2(255),
  nationwide_sts NVARCHAR2(10),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20)
)
;
COMMENT ON COLUMN org_area.id IS '记录唯一ID';
COMMENT ON COLUMN org_area.ou_id IS 'OU_ID';
COMMENT ON COLUMN org_area.bu_id IS 'BU_ID';
COMMENT ON COLUMN org_area.bu_code IS 'BU编号';
COMMENT ON COLUMN org_area.bu_name IS 'BU名称';
COMMENT ON COLUMN org_area.province IS '省份';
COMMENT ON COLUMN org_area.city IS '城市';
COMMENT ON COLUMN org_area.county IS '区县';
COMMENT ON COLUMN org_area.street IS '街道/乡镇';
COMMENT ON COLUMN org_area.detail_addr IS '详细地址';
COMMENT ON COLUMN org_area.nationwide_sts IS '详细地址';
COMMENT ON COLUMN org_area.tenant_id IS '租户ID';
COMMENT ON COLUMN org_area.remark IS '备注';
COMMENT ON COLUMN org_area.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN org_area.creator IS '记录创建者';
COMMENT ON COLUMN org_area.create_time IS '记录创建时间';
COMMENT ON COLUMN org_area.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN org_area.updater IS '记录最后更新者';
COMMENT ON COLUMN org_area.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN org_area.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN org_area.audit_data_version IS '锁版本';
COMMENT ON COLUMN org_area.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN org_area.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN org_area.sec_ou_id IS 'sec_ou_id';
COMMENT ON TABLE org_area IS '公司行政区划';

-- ----------------------------
-- Records of org_area
-- ----------------------------



-- ----------------------------
-- Table structure for org_bg_bu
-- ----------------------------
CREATE TABLE org_bg_bu (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN org_bg_bu.id IS '记录唯一ID';
COMMENT ON COLUMN org_bg_bu.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN org_bg_bu.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN org_bg_bu.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN org_bg_bu.tenant_id IS '租户ID';
COMMENT ON COLUMN org_bg_bu.remark IS '备注';
COMMENT ON COLUMN org_bg_bu.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN org_bg_bu.creator IS '记录创建者';
COMMENT ON COLUMN org_bg_bu.create_time IS '记录创建时间';
COMMENT ON COLUMN org_bg_bu.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN org_bg_bu.updater IS '记录最后更新者';
COMMENT ON COLUMN org_bg_bu.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN org_bg_bu.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN org_bg_bu.audit_data_version IS '锁版本';
COMMENT ON TABLE org_bg_bu IS 'BU组与BU';

-- ----------------------------
-- Records of org_bg_bu
-- ----------------------------



-- ----------------------------
-- Table structure for org_bu
-- ----------------------------
CREATE TABLE org_bu (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  bu_code NVARCHAR2(32),
  bu_name NVARCHAR2(32),
  bu_name2 NVARCHAR2(32),
  bu_name3 NVARCHAR2(32),
  bu_name4 NVARCHAR2(32),
  bu_abbr NVARCHAR2(32),
  bu_type NVARCHAR2(255),
  bu_type2 NVARCHAR2(32),
  bu_type3 NVARCHAR2(32),
  bu_type4 NVARCHAR2(32),
  bu_type5 NVARCHAR2(32),
  bu_type6 NVARCHAR2(32),
  bu_type7 NVARCHAR2(32),
  bu_status NVARCHAR2(32),
  bu_status2 NVARCHAR2(32),
  bu_status3 NVARCHAR2(32),
  ou_id NUMBER(20),
  ou_code NVARCHAR2(32),
  ou_name NVARCHAR2(32),
  pid NUMBER(20),
  bu_path NVARCHAR2(32),
  addr_no NVARCHAR2(32),
  bu_level NVARCHAR2(32),
  bu_region NVARCHAR2(32),
  sort_no NUMBER(11),
  pic_emp_id NUMBER(20),
  pic_name NVARCHAR2(32),
  cat NVARCHAR2(40),
  cat2 NVARCHAR2(40),
  cat3 NVARCHAR2(40),
  cat4 NVARCHAR2(40),
  cat5 NVARCHAR2(40),
  cat6 NVARCHAR2(40),
  cat7 NVARCHAR2(40),
  cat8 NVARCHAR2(40),
  cat9 NVARCHAR2(40),
  cat10 NVARCHAR2(40),
  cat11 NVARCHAR2(40),
  cat12 NVARCHAR2(40),
  cat13 NVARCHAR2(40),
  cat14 NVARCHAR2(40),
  cat15 NVARCHAR2(40),
  cat16 NVARCHAR2(40),
  cat17 NVARCHAR2(40),
  cat18 NVARCHAR2(40),
  cat19 NVARCHAR2(40),
  cat20 NVARCHAR2(40),
  cat21 NVARCHAR2(40),
  cat22 NVARCHAR2(40),
  cat23 NVARCHAR2(40),
  cat24 NVARCHAR2(40),
  cat25 NVARCHAR2(40),
  cat26 NVARCHAR2(40),
  cat27 NVARCHAR2(40),
  cat28 NVARCHAR2(40),
  cat29 NVARCHAR2(40),
  cat30 NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  cost_centre_code NVARCHAR2(40),
  cost_centre_name NVARCHAR2(40),
  jdy_flag NUMBER(11),
  data_source NVARCHAR2(40),
  sync_status NUMBER(4)
)
;
COMMENT ON COLUMN org_bu.id IS '记录唯一ID';
COMMENT ON COLUMN org_bu.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN org_bu.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN org_bu.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN org_bu.bu_code IS 'BU编号';
COMMENT ON COLUMN org_bu.bu_name IS 'BU名称';
COMMENT ON COLUMN org_bu.bu_name2 IS 'BU名称2';
COMMENT ON COLUMN org_bu.bu_name3 IS 'BU名称3';
COMMENT ON COLUMN org_bu.bu_name4 IS 'BU名称4';
COMMENT ON COLUMN org_bu.bu_abbr IS 'BU简称';
COMMENT ON COLUMN org_bu.bu_type IS 'BU类型';
COMMENT ON COLUMN org_bu.bu_type2 IS '店铺类型 [UDC]ORG:BU_TYPE2';
COMMENT ON COLUMN org_bu.bu_type3 IS 'BU类型3';
COMMENT ON COLUMN org_bu.bu_type4 IS 'BU类型4';
COMMENT ON COLUMN org_bu.bu_type5 IS 'BU类型5';
COMMENT ON COLUMN org_bu.bu_type6 IS 'BU类型6';
COMMENT ON COLUMN org_bu.bu_type7 IS 'BU类型7';
COMMENT ON COLUMN org_bu.bu_status IS 'BU状态 [UDC]COM:STATUS_BU';
COMMENT ON COLUMN org_bu.bu_status2 IS 'BU状态2';
COMMENT ON COLUMN org_bu.bu_status3 IS 'BU状态3';
COMMENT ON COLUMN org_bu.ou_id IS '公司ID';
COMMENT ON COLUMN org_bu.ou_code IS '公司编号';
COMMENT ON COLUMN org_bu.ou_name IS '公司名称';
COMMENT ON COLUMN org_bu.pid IS '上级ID';
COMMENT ON COLUMN org_bu.bu_path IS '关系路径';
COMMENT ON COLUMN org_bu.addr_no IS '地址号';
COMMENT ON COLUMN org_bu.bu_level IS 'BU层级 [UDC]ORG:BU_LEVEL';
COMMENT ON COLUMN org_bu.bu_region IS '区域 [UDC]COM:REGION';
COMMENT ON COLUMN org_bu.sort_no IS '排序号码';
COMMENT ON COLUMN org_bu.pic_emp_id IS '负责人员工ID';
COMMENT ON COLUMN org_bu.pic_name IS '负责人姓名';
COMMENT ON COLUMN org_bu.cat IS '类别码';
COMMENT ON COLUMN org_bu.cat2 IS '类别码2';
COMMENT ON COLUMN org_bu.cat3 IS '类别码3';
COMMENT ON COLUMN org_bu.cat4 IS '类别码4';
COMMENT ON COLUMN org_bu.cat5 IS '类别码5';
COMMENT ON COLUMN org_bu.cat6 IS '类别码6';
COMMENT ON COLUMN org_bu.cat7 IS '类别码7';
COMMENT ON COLUMN org_bu.cat8 IS '类别码8';
COMMENT ON COLUMN org_bu.cat9 IS '类别码9';
COMMENT ON COLUMN org_bu.cat10 IS '类别码10';
COMMENT ON COLUMN org_bu.cat11 IS '类别码11';
COMMENT ON COLUMN org_bu.cat12 IS '类别码12';
COMMENT ON COLUMN org_bu.cat13 IS '类别码13';
COMMENT ON COLUMN org_bu.cat14 IS '类别码14';
COMMENT ON COLUMN org_bu.cat15 IS '类别码15';
COMMENT ON COLUMN org_bu.cat16 IS '类别码16';
COMMENT ON COLUMN org_bu.cat17 IS '类别码17';
COMMENT ON COLUMN org_bu.cat18 IS '类别码18';
COMMENT ON COLUMN org_bu.cat19 IS '类别码19';
COMMENT ON COLUMN org_bu.cat20 IS '类别码20';
COMMENT ON COLUMN org_bu.cat21 IS '类别码21';
COMMENT ON COLUMN org_bu.cat22 IS '类别码22';
COMMENT ON COLUMN org_bu.cat23 IS '类别码23';
COMMENT ON COLUMN org_bu.cat24 IS '类别码24';
COMMENT ON COLUMN org_bu.cat25 IS '类别码25';
COMMENT ON COLUMN org_bu.cat26 IS '类别码26';
COMMENT ON COLUMN org_bu.cat27 IS '类别码27';
COMMENT ON COLUMN org_bu.cat28 IS '类别码28';
COMMENT ON COLUMN org_bu.cat29 IS '类别码29';
COMMENT ON COLUMN org_bu.cat30 IS '类别码30';
COMMENT ON COLUMN org_bu.tenant_id IS '租户ID';
COMMENT ON COLUMN org_bu.remark IS '备注';
COMMENT ON COLUMN org_bu.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN org_bu.creator IS '记录创建者';
COMMENT ON COLUMN org_bu.create_time IS '记录创建时间';
COMMENT ON COLUMN org_bu.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN org_bu.updater IS '记录最后更新者';
COMMENT ON COLUMN org_bu.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN org_bu.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN org_bu.audit_data_version IS '锁版本';
COMMENT ON COLUMN org_bu.cost_centre_code IS '成本中心编码';
COMMENT ON COLUMN org_bu.cost_centre_name IS '成本中心名称';
COMMENT ON COLUMN org_bu.jdy_flag IS '是否同步激荡云';
COMMENT ON COLUMN org_bu.data_source IS '数据来源';
COMMENT ON COLUMN org_bu.sync_status IS '同步的数据是否需要覆盖 false:忽略  true:覆盖';
COMMENT ON TABLE org_bu IS 'BU';

-- ----------------------------
-- Records of org_bu
-- ----------------------------



-- ----------------------------
-- Table structure for org_bu_ref
-- ----------------------------
CREATE TABLE org_bu_ref (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN org_bu_ref.id IS '记录唯一ID';
COMMENT ON COLUMN org_bu_ref.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN org_bu_ref.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN org_bu_ref.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN org_bu_ref.tenant_id IS '租户ID';
COMMENT ON COLUMN org_bu_ref.remark IS '备注';
COMMENT ON COLUMN org_bu_ref.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN org_bu_ref.creator IS '记录创建者';
COMMENT ON COLUMN org_bu_ref.create_time IS '记录创建时间';
COMMENT ON COLUMN org_bu_ref.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN org_bu_ref.updater IS '记录最后更新者';
COMMENT ON COLUMN org_bu_ref.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN org_bu_ref.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN org_bu_ref.audit_data_version IS '锁版本';
COMMENT ON TABLE org_bu_ref IS '组织关联';

-- ----------------------------
-- Records of org_bu_ref
-- ----------------------------



-- ----------------------------
-- Table structure for org_bu_tree
-- ----------------------------
CREATE TABLE org_bu_tree (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  bu_tree_type NVARCHAR2(32),
  bu_tree_type2 NVARCHAR2(32),
  bu_tree_type3 NVARCHAR2(32),
  bu_tree_status NVARCHAR2(32),
  bu_tree_code NVARCHAR2(32),
  bu_tree_name NVARCHAR2(64),
  bu_tree_version NVARCHAR2(32),
  now_version NVARCHAR2(32),
  cat NVARCHAR2(32),
  cat2 NVARCHAR2(32),
  cat3 NVARCHAR2(32),
  cat4 NVARCHAR2(32),
  cat5 NVARCHAR2(32),
  cat6 NVARCHAR2(32),
  cat7 NVARCHAR2(32),
  cat8 NVARCHAR2(32),
  cat9 NVARCHAR2(32),
  cat10 NVARCHAR2(32),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  release_time DATE,
  is_now_version VARCHAR2(1),
  disable_time DATE,
  release_user NVARCHAR2(255),
  version_instruction NVARCHAR2(255)
)
;
COMMENT ON COLUMN org_bu_tree.id IS '记录唯一ID';
COMMENT ON COLUMN org_bu_tree.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN org_bu_tree.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN org_bu_tree.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN org_bu_tree.bu_tree_type IS '组织树类型';
COMMENT ON COLUMN org_bu_tree.bu_tree_type2 IS '组织树类型2';
COMMENT ON COLUMN org_bu_tree.bu_tree_type3 IS '组织树类型3';
COMMENT ON COLUMN org_bu_tree.bu_tree_status IS '组织树状态';
COMMENT ON COLUMN org_bu_tree.bu_tree_code IS '组织树编号';
COMMENT ON COLUMN org_bu_tree.bu_tree_name IS '组织树名称';
COMMENT ON COLUMN org_bu_tree.bu_tree_version IS '组织树版本';
COMMENT ON COLUMN org_bu_tree.now_version IS '组织树当前版本';
COMMENT ON COLUMN org_bu_tree.cat IS '类别码';
COMMENT ON COLUMN org_bu_tree.cat2 IS '类别码2';
COMMENT ON COLUMN org_bu_tree.cat3 IS '类别码3';
COMMENT ON COLUMN org_bu_tree.cat4 IS '类别码4';
COMMENT ON COLUMN org_bu_tree.cat5 IS '类别码5';
COMMENT ON COLUMN org_bu_tree.cat6 IS '类别码6';
COMMENT ON COLUMN org_bu_tree.cat7 IS '类别码7';
COMMENT ON COLUMN org_bu_tree.cat8 IS '类别码8';
COMMENT ON COLUMN org_bu_tree.cat9 IS '类别码9';
COMMENT ON COLUMN org_bu_tree.cat10 IS '类别码10';
COMMENT ON COLUMN org_bu_tree.tenant_id IS '租户ID';
COMMENT ON COLUMN org_bu_tree.remark IS '备注';
COMMENT ON COLUMN org_bu_tree.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN org_bu_tree.creator IS '记录创建者';
COMMENT ON COLUMN org_bu_tree.create_time IS '记录创建时间';
COMMENT ON COLUMN org_bu_tree.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN org_bu_tree.updater IS '记录最后更新者';
COMMENT ON COLUMN org_bu_tree.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN org_bu_tree.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN org_bu_tree.audit_data_version IS '锁版本';
COMMENT ON COLUMN org_bu_tree.release_time IS '发布时间';
COMMENT ON COLUMN org_bu_tree.is_now_version IS '是否当前版本';
COMMENT ON COLUMN org_bu_tree.disable_time IS '停用时间';
COMMENT ON COLUMN org_bu_tree.release_user IS '发布人';
COMMENT ON COLUMN org_bu_tree.version_instruction IS '版本说明';
COMMENT ON TABLE org_bu_tree IS '组织树';

-- ----------------------------
-- Records of org_bu_tree
-- ----------------------------



-- ----------------------------
-- Table structure for org_bu_tree_d
-- ----------------------------
CREATE TABLE org_bu_tree_d (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  bu_tree_id NUMBER(20),
  bu_id NUMBER(20),
  pid NUMBER(20),
  bu_path NVARCHAR2(64),
  bu_level NVARCHAR2(64),
  sort_no NUMBER(11),
  grade NUMBER(11),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  code_path NVARCHAR2(255),
  bu_code NVARCHAR2(40),
  data_source NVARCHAR2(40),
  sync_status NUMBER(4),
  jdy_flag NUMBER(11)
)
;
COMMENT ON COLUMN org_bu_tree_d.id IS '记录唯一ID';
COMMENT ON COLUMN org_bu_tree_d.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN org_bu_tree_d.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN org_bu_tree_d.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN org_bu_tree_d.bu_tree_id IS '组织树ID';
COMMENT ON COLUMN org_bu_tree_d.bu_id IS '组织ID';
COMMENT ON COLUMN org_bu_tree_d.pid IS '上级ID';
COMMENT ON COLUMN org_bu_tree_d.bu_path IS '路径';
COMMENT ON COLUMN org_bu_tree_d.bu_level IS '组织层级';
COMMENT ON COLUMN org_bu_tree_d.sort_no IS '排序';
COMMENT ON COLUMN org_bu_tree_d.grade IS '级别';
COMMENT ON COLUMN org_bu_tree_d.tenant_id IS '租户ID';
COMMENT ON COLUMN org_bu_tree_d.remark IS '备注';
COMMENT ON COLUMN org_bu_tree_d.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN org_bu_tree_d.creator IS '记录创建者';
COMMENT ON COLUMN org_bu_tree_d.create_time IS '记录创建时间';
COMMENT ON COLUMN org_bu_tree_d.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN org_bu_tree_d.updater IS '记录最后更新者';
COMMENT ON COLUMN org_bu_tree_d.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN org_bu_tree_d.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN org_bu_tree_d.audit_data_version IS '锁版本';
COMMENT ON COLUMN org_bu_tree_d.data_source IS '数据来源';
COMMENT ON COLUMN org_bu_tree_d.sync_status IS '同步的数据是否需要覆盖 false:忽略  true:覆盖';
COMMENT ON COLUMN org_bu_tree_d.jdy_flag IS '是否同步激荡云 默认:1';
COMMENT ON TABLE org_bu_tree_d IS '组织树明细';

-- ----------------------------
-- Records of org_bu_tree_d
-- ----------------------------



-- ----------------------------
-- Table structure for org_bu_tree_version
-- ----------------------------
CREATE TABLE org_bu_tree_version (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN org_bu_tree_version.id IS '记录唯一ID';
COMMENT ON COLUMN org_bu_tree_version.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN org_bu_tree_version.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN org_bu_tree_version.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN org_bu_tree_version.tenant_id IS '租户ID';
COMMENT ON COLUMN org_bu_tree_version.remark IS '备注';
COMMENT ON COLUMN org_bu_tree_version.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN org_bu_tree_version.creator IS '记录创建者';
COMMENT ON COLUMN org_bu_tree_version.create_time IS '记录创建时间';
COMMENT ON COLUMN org_bu_tree_version.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN org_bu_tree_version.updater IS '记录最后更新者';
COMMENT ON COLUMN org_bu_tree_version.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN org_bu_tree_version.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN org_bu_tree_version.audit_data_version IS '锁版本';
COMMENT ON TABLE org_bu_tree_version IS '组织树版本';

-- ----------------------------
-- Records of org_bu_tree_version
-- ----------------------------



-- ----------------------------
-- Table structure for org_emp
-- ----------------------------
CREATE TABLE org_emp (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  pid NUMBER(20) NOT NULL,
  sort_no NUMBER(11),
  grade NUMBER(11),
  id_path NVARCHAR2(255),
  code_path NVARCHAR2(255),
  ou_id NUMBER(20),
  ou_code NVARCHAR2(40),
  ou_name NVARCHAR2(40),
  bu_id NUMBER(20),
  bu_code NVARCHAR2(40),
  bu_name NVARCHAR2(40),
  emp_bu_id NUMBER(20),
  emp_bu_tree_id NUMBER(20),
  emp_bu_treedid NUMBER(20),
  user_id NUMBER(20),
  user_name NVARCHAR2(40),
  emp_code NVARCHAR2(40),
  emp_name NVARCHAR2(40),
  emp_type NVARCHAR2(255),
  emp_type2 NVARCHAR2(40),
  emp_type3 NVARCHAR2(40),
  emp_status NVARCHAR2(40),
  foreign_name NVARCHAR2(40),
  addr_no NUMBER(20),
  emp_gender NVARCHAR2(40),
  birth_date DATE,
  email NVARCHAR2(40),
  mobile NVARCHAR2(40),
  id_type NVARCHAR2(40),
  id_no NVARCHAR2(255),
  emp_level NVARCHAR2(40),
  title NVARCHAR2(40),
  join_date DATE,
  leave_date DATE,
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  jdy_flag NUMBER(11),
  data_source NVARCHAR2(40),
  sync_status NUMBER(4)
)
;
COMMENT ON COLUMN org_emp.ou_id IS '公司ID';
COMMENT ON COLUMN org_emp.ou_code IS '公司编号';
COMMENT ON COLUMN org_emp.ou_name IS '公司名称';
COMMENT ON COLUMN org_emp.bu_id IS 'BU ID';
COMMENT ON COLUMN org_emp.bu_code IS 'BU编号';
COMMENT ON COLUMN org_emp.bu_name IS 'BU名称';
COMMENT ON COLUMN org_emp.emp_bu_id IS '员工所属 BU ID';
COMMENT ON COLUMN org_emp.emp_bu_tree_id IS '员工所属BU树ID';
COMMENT ON COLUMN org_emp.emp_bu_treedid IS '员工所属BU树详情ID';
COMMENT ON COLUMN org_emp.user_id IS '用户id';
COMMENT ON COLUMN org_emp.user_name IS '用户名';
COMMENT ON COLUMN org_emp.emp_code IS '雇员编号';
COMMENT ON COLUMN org_emp.emp_name IS '雇员姓名';
COMMENT ON COLUMN org_emp.emp_type IS '员工类型 [UDC]ORG:EMP_TYPE';
COMMENT ON COLUMN org_emp.emp_type2 IS '员工类型2';
COMMENT ON COLUMN org_emp.emp_type3 IS '员工类型3';
COMMENT ON COLUMN org_emp.emp_status IS '员工状态 [UDC]ORG:EMP_STATUS';
COMMENT ON COLUMN org_emp.foreign_name IS '雇员外文名';
COMMENT ON COLUMN org_emp.addr_no IS '地址号';
COMMENT ON COLUMN org_emp.emp_gender IS '员工性别';
COMMENT ON COLUMN org_emp.birth_date IS '出生日期';
COMMENT ON COLUMN org_emp.email IS '工作邮箱';
COMMENT ON COLUMN org_emp.mobile IS '工作手机号';
COMMENT ON COLUMN org_emp.id_type IS '证件类型';
COMMENT ON COLUMN org_emp.id_no IS '证件号码';
COMMENT ON COLUMN org_emp.emp_level IS '职级';
COMMENT ON COLUMN org_emp.title IS '行政职位, [UDC]ORG:TITLE';
COMMENT ON COLUMN org_emp.join_date IS '入职日期';
COMMENT ON COLUMN org_emp.leave_date IS '离职日期';
COMMENT ON COLUMN org_emp.jdy_flag IS '是否同步激荡云';
COMMENT ON COLUMN org_emp.data_source IS '数据来源';
COMMENT ON COLUMN org_emp.sync_status IS '同步的数据是否需要覆盖 false:忽略  true:覆盖';
COMMENT ON TABLE org_emp IS '员工';




-- ----------------------------
-- Table structure for org_emp_bu
-- ----------------------------
CREATE TABLE org_emp_bu (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  emp_id NUMBER(20),
  emp_bu_id NUMBER(20),
  emp_bu_tree_id NUMBER(20),
  emp_bu_tree_code NVARCHAR2(40),
  emp_bu_treedid NUMBER(20),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  data_source NVARCHAR2(40),
  sync_status NUMBER(4)
)
;
COMMENT ON COLUMN org_emp_bu.id IS '记录唯一ID';
COMMENT ON COLUMN org_emp_bu.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN org_emp_bu.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN org_emp_bu.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN org_emp_bu.emp_id IS '员工ID';
COMMENT ON COLUMN org_emp_bu.emp_bu_id IS '员工绑定组织ID';
COMMENT ON COLUMN org_emp_bu.emp_bu_tree_id IS '员工绑定的组织树ID';
COMMENT ON COLUMN org_emp_bu.emp_bu_tree_code IS '员工绑定的组织树编号';
COMMENT ON COLUMN org_emp_bu.emp_bu_treedid IS '员工绑定的组织树详情ID';
COMMENT ON COLUMN org_emp_bu.tenant_id IS '租户ID';
COMMENT ON COLUMN org_emp_bu.remark IS '备注';
COMMENT ON COLUMN org_emp_bu.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN org_emp_bu.creator IS '记录创建者';
COMMENT ON COLUMN org_emp_bu.create_time IS '记录创建时间';
COMMENT ON COLUMN org_emp_bu.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN org_emp_bu.updater IS '记录最后更新者';
COMMENT ON COLUMN org_emp_bu.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN org_emp_bu.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN org_emp_bu.audit_data_version IS '锁版本';
COMMENT ON COLUMN org_emp_bu.data_source IS '数据来源';
COMMENT ON COLUMN org_emp_bu.sync_status IS '同步的数据是否需要覆盖 false:忽略  true:覆盖';
COMMENT ON TABLE org_emp_bu IS '员工组织关系表';

-- ----------------------------
-- Records of org_emp_bu
-- ----------------------------



-- ----------------------------
-- Table structure for org_ou
-- ----------------------------
CREATE TABLE org_ou (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  ou_code NVARCHAR2(32),
  ou_name NVARCHAR2(32),
  ou_name2 NVARCHAR2(32),
  ou_name3 NVARCHAR2(32),
  ou_name4 NVARCHAR2(32),
  ou_abbr NVARCHAR2(32),
  abbr_alpha NVARCHAR2(10),
  ou_type NVARCHAR2(32),
  ou_type2 NVARCHAR2(32),
  ou_type3 NVARCHAR2(32),
  ou_status NVARCHAR2(32),
  ou_status2 NVARCHAR2(32),
  ou_status3 NVARCHAR2(32),
  bu_id NVARCHAR2(32),
  bu_code NVARCHAR2(32),
  bu_name NVARCHAR2(32),
  pid NUMBER(20),
  legal_ou_id NUMBER(20),
  ou_path NVARCHAR2(128),
  ou_curr NVARCHAR2(10),
  fin_cal_code NVARCHAR2(128),
  fin_year NUMBER(11),
  fin_period NUMBER(11),
  addr_no NVARCHAR2(32),
  country NVARCHAR2(32),
  region NVARCHAR2(32),
  sort_no NUMBER(11),
  biz_code_cert NVARCHAR2(32),
  ic_register_no NVARCHAR2(32),
  uni_cert_no NVARCHAR2(32),
  repr_name NVARCHAR2(64),
  tax_reg_no NVARCHAR2(32),
  taxpayer_type NVARCHAR2(32),
  taxer_code NVARCHAR2(32),
  inv_type NVARCHAR2(40),
  inv_title NVARCHAR2(40),
  inv_address NVARCHAR2(40),
  inv_tel NVARCHAR2(40),
  inv_pic_name NVARCHAR2(40),
  inv_pic_phone NVARCHAR2(40),
  inv_bank_name NVARCHAR2(40),
  inv_bank_branch NVARCHAR2(40),
  inv_bank_acc NVARCHAR2(40),
  tax_rate_no NVARCHAR2(40),
  tax_rate NUMBER,
  cat NVARCHAR2(40),
  cat2 NVARCHAR2(40),
  cat3 NVARCHAR2(40),
  cat4 NVARCHAR2(40),
  cat5 NVARCHAR2(40),
  cat6 NVARCHAR2(40),
  cat7 NVARCHAR2(40),
  cat8 NVARCHAR2(40),
  cat9 NVARCHAR2(40),
  cat10 NVARCHAR2(40),
  cat11 NVARCHAR2(40),
  cat12 NVARCHAR2(40),
  cat13 NVARCHAR2(40),
  cat14 NVARCHAR2(40),
  cat15 NVARCHAR2(40),
  cat16 NVARCHAR2(40),
  cat17 NVARCHAR2(40),
  cat18 NVARCHAR2(40),
  cat19 NVARCHAR2(40),
  cat20 NVARCHAR2(40),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  external_code NVARCHAR2(32),
  data_source NVARCHAR2(40),
  sync_status NUMBER(4)
)
;
COMMENT ON COLUMN org_ou.id IS '记录唯一ID';
COMMENT ON COLUMN org_ou.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN org_ou.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN org_ou.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN org_ou.ou_code IS '公司编号';
COMMENT ON COLUMN org_ou.ou_name IS '公司名称';
COMMENT ON COLUMN org_ou.ou_name2 IS '公司名称2';
COMMENT ON COLUMN org_ou.ou_name3 IS '公司名称3';
COMMENT ON COLUMN org_ou.ou_name4 IS '公司名称4';
COMMENT ON COLUMN org_ou.ou_abbr IS '公司简称';
COMMENT ON COLUMN org_ou.abbr_alpha IS '字母缩写';
COMMENT ON COLUMN org_ou.ou_type IS '公司类型 [UDC]ORG:OU_TYPE';
COMMENT ON COLUMN org_ou.ou_type2 IS '公司类型2';
COMMENT ON COLUMN org_ou.ou_type3 IS '公司类型3';
COMMENT ON COLUMN org_ou.ou_status IS '公司状态 [UDC]COM:STATUS_ACTIVEORNO';
COMMENT ON COLUMN org_ou.ou_status2 IS '公司状态2';
COMMENT ON COLUMN org_ou.ou_status3 IS '公司状态3';
COMMENT ON COLUMN org_ou.bu_id IS '经营单位ID';
COMMENT ON COLUMN org_ou.bu_code IS 'BU编号';
COMMENT ON COLUMN org_ou.bu_name IS 'BU名称';
COMMENT ON COLUMN org_ou.pid IS '上级ID';
COMMENT ON COLUMN org_ou.legal_ou_id IS '法人公司ID';
COMMENT ON COLUMN org_ou.ou_path IS '路径';
COMMENT ON COLUMN org_ou.ou_curr IS '本位币';
COMMENT ON COLUMN org_ou.fin_cal_code IS '财务日历编号';
COMMENT ON COLUMN org_ou.fin_year IS '财务年度';
COMMENT ON COLUMN org_ou.fin_period IS '财务期间';
COMMENT ON COLUMN org_ou.addr_no IS '地址号';
COMMENT ON COLUMN org_ou.country IS '国家 [UDC]COM:COUNTRY';
COMMENT ON COLUMN org_ou.region IS '区域 [UDC]ORG:OU_REGION';
COMMENT ON COLUMN org_ou.sort_no IS '排序号 用于相同层级的排序';
COMMENT ON COLUMN org_ou.biz_code_cert IS '组织机构代码证号';
COMMENT ON COLUMN org_ou.ic_register_no IS '工商登记号';
COMMENT ON COLUMN org_ou.uni_cert_no IS '统一信用代码';
COMMENT ON COLUMN org_ou.repr_name IS '法人代表';
COMMENT ON COLUMN org_ou.tax_reg_no IS '税务登记号';
COMMENT ON COLUMN org_ou.taxpayer_type IS '纳税人类型';
COMMENT ON COLUMN org_ou.taxer_code IS '纳税人识别号';
COMMENT ON COLUMN org_ou.inv_type IS '发票类型';
COMMENT ON COLUMN org_ou.inv_title IS '开票抬头';
COMMENT ON COLUMN org_ou.inv_address IS '开票地址';
COMMENT ON COLUMN org_ou.inv_tel IS '开票电话';
COMMENT ON COLUMN org_ou.inv_pic_name IS '开票联系人';
COMMENT ON COLUMN org_ou.inv_pic_phone IS '开票联系人电话';
COMMENT ON COLUMN org_ou.inv_bank_name IS '开票银行名称';
COMMENT ON COLUMN org_ou.inv_bank_branch IS '开票银行支行';
COMMENT ON COLUMN org_ou.inv_bank_acc IS '开票银行账号';
COMMENT ON COLUMN org_ou.tax_rate_no IS '税率编号';
COMMENT ON COLUMN org_ou.tax_rate IS '税率';
COMMENT ON COLUMN org_ou.cat IS '类别码';
COMMENT ON COLUMN org_ou.cat2 IS '类别码2';
COMMENT ON COLUMN org_ou.cat3 IS '类别码3';
COMMENT ON COLUMN org_ou.cat4 IS '类别码4';
COMMENT ON COLUMN org_ou.cat5 IS '类别码5';
COMMENT ON COLUMN org_ou.cat6 IS '类别码6';
COMMENT ON COLUMN org_ou.cat7 IS '类别码7';
COMMENT ON COLUMN org_ou.cat8 IS '类别码8';
COMMENT ON COLUMN org_ou.cat9 IS '类别码9';
COMMENT ON COLUMN org_ou.cat10 IS '类别码10';
COMMENT ON COLUMN org_ou.cat11 IS '类别码11';
COMMENT ON COLUMN org_ou.cat12 IS '类别码12';
COMMENT ON COLUMN org_ou.cat13 IS '类别码13';
COMMENT ON COLUMN org_ou.cat14 IS '类别码14';
COMMENT ON COLUMN org_ou.cat15 IS '类别码15';
COMMENT ON COLUMN org_ou.cat16 IS '类别码16';
COMMENT ON COLUMN org_ou.cat17 IS '类别码17';
COMMENT ON COLUMN org_ou.cat18 IS '类别码18';
COMMENT ON COLUMN org_ou.cat19 IS '类别码19';
COMMENT ON COLUMN org_ou.cat20 IS '类别码20';
COMMENT ON COLUMN org_ou.tenant_id IS '租户ID';
COMMENT ON COLUMN org_ou.remark IS '备注';
COMMENT ON COLUMN org_ou.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN org_ou.creator IS '记录创建者';
COMMENT ON COLUMN org_ou.create_time IS '记录创建时间';
COMMENT ON COLUMN org_ou.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN org_ou.updater IS '记录最后更新者';
COMMENT ON COLUMN org_ou.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN org_ou.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN org_ou.audit_data_version IS '锁版本';
COMMENT ON COLUMN org_ou.external_code IS '核算编码';
COMMENT ON COLUMN org_ou.data_source IS '数据来源';
COMMENT ON COLUMN org_ou.sync_status IS '同步的数据是否需要覆盖 false:忽略  true:覆盖';
COMMENT ON TABLE org_ou IS '公司';




-- ----------------------------
-- Table structure for org_store
-- ----------------------------
CREATE TABLE org_store (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  ou_id NUMBER(20),
  ou_code NVARCHAR2(32),
  ou_name NVARCHAR2(32),
  bu_id NUMBER(20),
  bu_code NVARCHAR2(32),
  bu_name NVARCHAR2(32),
  store_code NVARCHAR2(32),
  store_name NVARCHAR2(32),
  store_name2 NVARCHAR2(32),
  store_abbr NVARCHAR2(32),
  store_type NVARCHAR2(32),
  store_type2 NVARCHAR2(32),
  store_type3 NVARCHAR2(32),
  store_status NVARCHAR2(32),
  store_status2 NVARCHAR2(32),
  store_status3 NVARCHAR2(32),
  addr_no NVARCHAR2(32),
  region NVARCHAR2(32),
  sort_no NUMBER(11),
  pic_user_id NUMBER(20),
  pic_emp_id NUMBER(20),
  pic_name NVARCHAR2(32),
  open_time_span NVARCHAR2(32),
  open_time_span2 NVARCHAR2(32),
  start_date DATE,
  end_date DATE,
  pid NUMBER(20),
  store_path NVARCHAR2(32),
  cat NVARCHAR2(40),
  cat2 NVARCHAR2(40),
  cat3 NVARCHAR2(40),
  cat4 NVARCHAR2(40),
  cat5 NVARCHAR2(40),
  cat6 NVARCHAR2(40),
  cat7 NVARCHAR2(40),
  cat8 NVARCHAR2(40),
  cat9 NVARCHAR2(40),
  cat10 NVARCHAR2(40),
  cat11 NVARCHAR2(40),
  cat12 NVARCHAR2(40),
  cat13 NVARCHAR2(40),
  cat14 NVARCHAR2(40),
  cat15 NVARCHAR2(40),
  cat16 NVARCHAR2(40),
  cat17 NVARCHAR2(40),
  cat18 NVARCHAR2(40),
  cat19 NVARCHAR2(40),
  cat20 NVARCHAR2(40),
  cat21 NVARCHAR2(40),
  cat22 NVARCHAR2(40),
  cat23 NVARCHAR2(40),
  cat24 NVARCHAR2(40),
  cat25 NVARCHAR2(40),
  cat26 NVARCHAR2(40),
  cat27 NVARCHAR2(40),
  cat28 NVARCHAR2(40),
  cat29 NVARCHAR2(40),
  cat30 NVARCHAR2(40),
  outer_code NVARCHAR2(40),
  outer_code2 NVARCHAR2(40),
  es1 NVARCHAR2(256),
  es2 NVARCHAR2(256),
  es3 NVARCHAR2(256),
  es4 NVARCHAR2(256),
  es5 NVARCHAR2(256),
  es6 NVARCHAR2(256),
  es7 NVARCHAR2(256),
  es8 NVARCHAR2(256),
  es9 NVARCHAR2(256),
  es10 NVARCHAR2(256),
  ed1 DATE,
  ed2 DATE,
  ed3 DATE,
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN org_store.id IS '记录唯一ID';
COMMENT ON COLUMN org_store.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN org_store.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN org_store.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN org_store.ou_code IS '公司编号';
COMMENT ON COLUMN org_store.ou_name IS '公司名称';
COMMENT ON COLUMN org_store.addr_no IS '地址号';
COMMENT ON COLUMN org_store.region IS '区域';
COMMENT ON COLUMN org_store.pid IS '上级ID';
COMMENT ON COLUMN org_store.cat IS '类别码';
COMMENT ON COLUMN org_store.cat2 IS '类别码2';
COMMENT ON COLUMN org_store.cat3 IS '类别码3';
COMMENT ON COLUMN org_store.cat4 IS '类别码4';
COMMENT ON COLUMN org_store.cat5 IS '类别码5';
COMMENT ON COLUMN org_store.cat6 IS '类别码6';
COMMENT ON COLUMN org_store.cat7 IS '类别码7';
COMMENT ON COLUMN org_store.cat8 IS '类别码8';
COMMENT ON COLUMN org_store.cat9 IS '类别码9';
COMMENT ON COLUMN org_store.cat10 IS '类别码10';
COMMENT ON COLUMN org_store.cat11 IS '类别码11';
COMMENT ON COLUMN org_store.cat12 IS '类别码12';
COMMENT ON COLUMN org_store.cat13 IS '类别码13';
COMMENT ON COLUMN org_store.cat14 IS '类别码14';
COMMENT ON COLUMN org_store.cat15 IS '类别码15';
COMMENT ON COLUMN org_store.cat16 IS '类别码16';
COMMENT ON COLUMN org_store.cat17 IS '类别码17';
COMMENT ON COLUMN org_store.cat18 IS '类别码18';
COMMENT ON COLUMN org_store.cat19 IS '类别码19';
COMMENT ON COLUMN org_store.cat20 IS '类别码20';
COMMENT ON COLUMN org_store.cat21 IS '类别码21';
COMMENT ON COLUMN org_store.cat22 IS '类别码22';
COMMENT ON COLUMN org_store.cat23 IS '类别码23';
COMMENT ON COLUMN org_store.cat24 IS '类别码24';
COMMENT ON COLUMN org_store.cat25 IS '类别码25';
COMMENT ON COLUMN org_store.cat26 IS '类别码26';
COMMENT ON COLUMN org_store.cat27 IS '类别码27';
COMMENT ON COLUMN org_store.cat28 IS '类别码28';
COMMENT ON COLUMN org_store.cat29 IS '类别码29';
COMMENT ON COLUMN org_store.cat30 IS '类别码30';
COMMENT ON COLUMN org_store.outer_code IS '外部编码';
COMMENT ON COLUMN org_store.outer_code2 IS '外部编码2';
COMMENT ON COLUMN org_store.es1 IS 'ES1';
COMMENT ON COLUMN org_store.es2 IS 'ES2';
COMMENT ON COLUMN org_store.es3 IS 'ES3';
COMMENT ON COLUMN org_store.es4 IS 'ES4';
COMMENT ON COLUMN org_store.es5 IS 'ES5';
COMMENT ON COLUMN org_store.es6 IS 'ES6';
COMMENT ON COLUMN org_store.es7 IS 'ES7';
COMMENT ON COLUMN org_store.es8 IS 'ES8';
COMMENT ON COLUMN org_store.es9 IS 'ES9';
COMMENT ON COLUMN org_store.es10 IS 'ES10';
COMMENT ON COLUMN org_store.ed1 IS 'ED1';
COMMENT ON COLUMN org_store.ed2 IS 'ED2';
COMMENT ON COLUMN org_store.ed3 IS 'ED3';
COMMENT ON COLUMN org_store.tenant_id IS '租户ID';
COMMENT ON COLUMN org_store.remark IS '备注';
COMMENT ON COLUMN org_store.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN org_store.creator IS '记录创建者';
COMMENT ON COLUMN org_store.create_time IS '记录创建时间';
COMMENT ON COLUMN org_store.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN org_store.updater IS '记录最后更新者';
COMMENT ON COLUMN org_store.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN org_store.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN org_store.audit_data_version IS '锁版本';
COMMENT ON TABLE org_store IS '门店表';

-- ----------------------------
-- Records of org_store
-- ----------------------------



-- ----------------------------
-- Table structure for pri_main_price_alter
-- ----------------------------
CREATE TABLE pri_main_price_alter (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  ou_id NUMBER(20),
  bu_id NUMBER(20),
  doc_no NVARCHAR2(32),
  doc_type NVARCHAR2(32),
  doc_type2 NVARCHAR2(32),
  doc_type3 NVARCHAR2(32),
  doc_status NVARCHAR2(32),
  apply_emp_id NUMBER(20),
  apply_date DATE,
  apply_desc NVARCHAR2(128),
  appr_status NVARCHAR2(32),
  appr_time DATE,
  apply_user_id NUMBER(20),
  apply_comment NVARCHAR2(128),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  proc_inst_id NVARCHAR2(255),
  proc_inst_status NVARCHAR2(255),
  submit_time DATE,
  approved_time DATE
)
;
COMMENT ON COLUMN pri_main_price_alter.id IS '记录唯一ID';
COMMENT ON COLUMN pri_main_price_alter.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN pri_main_price_alter.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN pri_main_price_alter.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN pri_main_price_alter.ou_id IS 'OU公司ID';
COMMENT ON COLUMN pri_main_price_alter.bu_id IS 'BU组织ID';
COMMENT ON COLUMN pri_main_price_alter.doc_no IS '单据编号';
COMMENT ON COLUMN pri_main_price_alter.doc_type IS '单据类型';
COMMENT ON COLUMN pri_main_price_alter.doc_type2 IS '单据类型2';
COMMENT ON COLUMN pri_main_price_alter.doc_type3 IS '单据类型3';
COMMENT ON COLUMN pri_main_price_alter.doc_status IS '单据状态';
COMMENT ON COLUMN pri_main_price_alter.apply_emp_id IS '申请人员工ID';
COMMENT ON COLUMN pri_main_price_alter.apply_date IS '申请日期';
COMMENT ON COLUMN pri_main_price_alter.apply_desc IS '申请描述';
COMMENT ON COLUMN pri_main_price_alter.appr_status IS '审批状态';
COMMENT ON COLUMN pri_main_price_alter.appr_time IS '审批时间';
COMMENT ON COLUMN pri_main_price_alter.apply_user_id IS '审批人ID';
COMMENT ON COLUMN pri_main_price_alter.apply_comment IS '审批意见';
COMMENT ON COLUMN pri_main_price_alter.tenant_id IS '租户ID';
COMMENT ON COLUMN pri_main_price_alter.remark IS '备注';
COMMENT ON COLUMN pri_main_price_alter.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN pri_main_price_alter.creator IS '记录创建者';
COMMENT ON COLUMN pri_main_price_alter.create_time IS '记录创建时间';
COMMENT ON COLUMN pri_main_price_alter.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN pri_main_price_alter.updater IS '记录最后更新者';
COMMENT ON COLUMN pri_main_price_alter.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN pri_main_price_alter.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN pri_main_price_alter.audit_data_version IS '锁版本';
COMMENT ON COLUMN pri_main_price_alter.proc_inst_id IS '流程实例ID';
COMMENT ON COLUMN pri_main_price_alter.proc_inst_status IS '流程实例状态';
COMMENT ON COLUMN pri_main_price_alter.submit_time IS '提交时间';
COMMENT ON COLUMN pri_main_price_alter.approved_time IS '审批通过时间';
COMMENT ON TABLE pri_main_price_alter IS '主档价格变更单据表';

-- ----------------------------
-- Records of pri_main_price_alter
-- ----------------------------



-- ----------------------------
-- Table structure for pri_main_price_alter_d_row
-- ----------------------------
CREATE TABLE pri_main_price_alter_d_row (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  mas_id NUMBER(20),
  pri_main_price_id NUMBER(20),
  ou_id NUMBER(20),
  ou_code NVARCHAR2(32),
  ou_name NVARCHAR2(32),
  bu_id NUMBER(20),
  bu_code NVARCHAR2(32),
  bu_name NVARCHAR2(32),
  item_id NUMBER(20),
  item_code NVARCHAR2(32),
  item_code2 NVARCHAR2(32),
  item_code3 NVARCHAR2(32),
  item_name NVARCHAR2(32),
  item_name2 NVARCHAR2(32),
  item_name3 NVARCHAR2(32),
  spu_id NUMBER(20),
  spu_code NVARCHAR2(40),
  spu_code2 NVARCHAR2(40),
  spu_code3 NVARCHAR2(40),
  spu_name NVARCHAR2(40),
  spu_name2 NVARCHAR2(40),
  spu_name3 NVARCHAR2(40),
  spec NVARCHAR2(40),
  item_cate_code NVARCHAR2(32),
  uom NVARCHAR2(16),
  price_type NVARCHAR2(32),
  tax_code NVARCHAR2(32),
  tax_rate_no NVARCHAR2(32),
  tax_rate NUMBER,
  install_flag NUMBER(11),
  price1 NUMBER,
  price2 NUMBER,
  price3 NUMBER,
  price4 NUMBER,
  price5 NUMBER,
  price6 NUMBER,
  price7 NUMBER,
  price8 NUMBER,
  price9 NUMBER,
  price10 NUMBER,
  curr_code NVARCHAR2(32),
  valid_from DATE,
  valid_to DATE,
  price_status NVARCHAR2(32),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN pri_main_price_alter_d_row.id IS '记录唯一ID';
COMMENT ON COLUMN pri_main_price_alter_d_row.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN pri_main_price_alter_d_row.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN pri_main_price_alter_d_row.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN pri_main_price_alter_d_row.mas_id IS '单据ID';
COMMENT ON COLUMN pri_main_price_alter_d_row.pri_main_price_id IS '商品价格表ID';
COMMENT ON COLUMN pri_main_price_alter_d_row.ou_id IS 'OU公司ID';
COMMENT ON COLUMN pri_main_price_alter_d_row.ou_code IS 'OU公司编号';
COMMENT ON COLUMN pri_main_price_alter_d_row.ou_name IS 'OU公司名称';
COMMENT ON COLUMN pri_main_price_alter_d_row.bu_id IS 'BU组织ID';
COMMENT ON COLUMN pri_main_price_alter_d_row.bu_code IS 'BU组织编号';
COMMENT ON COLUMN pri_main_price_alter_d_row.bu_name IS 'BU组织名称';
COMMENT ON COLUMN pri_main_price_alter_d_row.item_id IS '商品ID';
COMMENT ON COLUMN pri_main_price_alter_d_row.item_code IS '品项编号';
COMMENT ON COLUMN pri_main_price_alter_d_row.item_code2 IS '第二编号';
COMMENT ON COLUMN pri_main_price_alter_d_row.item_code3 IS '第三编号';
COMMENT ON COLUMN pri_main_price_alter_d_row.item_name IS '品项名称';
COMMENT ON COLUMN pri_main_price_alter_d_row.item_name2 IS '第二名称';
COMMENT ON COLUMN pri_main_price_alter_d_row.item_name3 IS '第三名称';
COMMENT ON COLUMN pri_main_price_alter_d_row.spu_id IS 'SPU_ID';
COMMENT ON COLUMN pri_main_price_alter_d_row.spu_code IS 'SPU_CODE';
COMMENT ON COLUMN pri_main_price_alter_d_row.spu_code2 IS 'SPU_CODE2';
COMMENT ON COLUMN pri_main_price_alter_d_row.spu_code3 IS 'SPU_CODE3';
COMMENT ON COLUMN pri_main_price_alter_d_row.spu_name IS 'SPU_NAME';
COMMENT ON COLUMN pri_main_price_alter_d_row.spu_name2 IS 'SPU_NAME2';
COMMENT ON COLUMN pri_main_price_alter_d_row.spu_name3 IS 'SPU_NAME3';
COMMENT ON COLUMN pri_main_price_alter_d_row.spec IS '一般规格，比如：食品净含量';
COMMENT ON COLUMN pri_main_price_alter_d_row.item_cate_code IS '品类编码';
COMMENT ON COLUMN pri_main_price_alter_d_row.uom IS '单位';
COMMENT ON COLUMN pri_main_price_alter_d_row.price_type IS '价格类型';
COMMENT ON COLUMN pri_main_price_alter_d_row.tax_code IS '税码';
COMMENT ON COLUMN pri_main_price_alter_d_row.tax_rate_no IS '税率编号';
COMMENT ON COLUMN pri_main_price_alter_d_row.tax_rate IS '税率';
COMMENT ON COLUMN pri_main_price_alter_d_row.install_flag IS '是否含税';
COMMENT ON COLUMN pri_main_price_alter_d_row.price1 IS '市场价';
COMMENT ON COLUMN pri_main_price_alter_d_row.price2 IS 'B端指导价';
COMMENT ON COLUMN pri_main_price_alter_d_row.price3 IS 'C端零售价';
COMMENT ON COLUMN pri_main_price_alter_d_row.price4 IS 'B端毛利控制率';
COMMENT ON COLUMN pri_main_price_alter_d_row.price5 IS 'C端毛利控制率';
COMMENT ON COLUMN pri_main_price_alter_d_row.price6 IS 'B端毛利率';
COMMENT ON COLUMN pri_main_price_alter_d_row.price7 IS 'C端毛利率';
COMMENT ON COLUMN pri_main_price_alter_d_row.price8 IS '采购价';
COMMENT ON COLUMN pri_main_price_alter_d_row.price9 IS '价格9';
COMMENT ON COLUMN pri_main_price_alter_d_row.price10 IS '价格10';
COMMENT ON COLUMN pri_main_price_alter_d_row.curr_code IS '币种';
COMMENT ON COLUMN pri_main_price_alter_d_row.valid_from IS '生效时间';
COMMENT ON COLUMN pri_main_price_alter_d_row.valid_to IS '失效时间';
COMMENT ON COLUMN pri_main_price_alter_d_row.price_status IS '状态';
COMMENT ON COLUMN pri_main_price_alter_d_row.tenant_id IS '租户ID';
COMMENT ON COLUMN pri_main_price_alter_d_row.remark IS '备注';
COMMENT ON COLUMN pri_main_price_alter_d_row.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN pri_main_price_alter_d_row.creator IS '记录创建者';
COMMENT ON COLUMN pri_main_price_alter_d_row.create_time IS '记录创建时间';
COMMENT ON COLUMN pri_main_price_alter_d_row.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN pri_main_price_alter_d_row.updater IS '记录最后更新者';
COMMENT ON COLUMN pri_main_price_alter_d_row.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN pri_main_price_alter_d_row.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN pri_main_price_alter_d_row.audit_data_version IS '锁版本';
COMMENT ON TABLE pri_main_price_alter_d_row IS '主档价格变更单据明细表';

-- ----------------------------
-- Records of pri_main_price_alter_d_row
-- ----------------------------



-- ----------------------------
-- Table structure for pri_main_price_row
-- ----------------------------
CREATE TABLE pri_main_price_row (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  ou_id NUMBER(20),
  ou_code NVARCHAR2(32),
  ou_name NVARCHAR2(32),
  bu_id NUMBER(20),
  bu_code NVARCHAR2(32),
  bu_name NVARCHAR2(32),
  item_id NUMBER(20),
  item_code NVARCHAR2(32),
  item_code2 NVARCHAR2(32),
  item_code3 NVARCHAR2(32),
  item_name NVARCHAR2(32),
  item_name2 NVARCHAR2(32),
  item_name3 NVARCHAR2(32),
  spu_id NUMBER(20),
  spu_code NVARCHAR2(40),
  spu_code2 NVARCHAR2(40),
  spu_code3 NVARCHAR2(40),
  spu_name NVARCHAR2(40),
  spu_name2 NVARCHAR2(40),
  spu_name3 NVARCHAR2(40),
  spec NVARCHAR2(40),
  item_cate_code NVARCHAR2(32),
  uom NVARCHAR2(16),
  price_type NVARCHAR2(32),
  tax_code NVARCHAR2(32),
  tax_rate_no NVARCHAR2(32),
  tax_rate NUMBER,
  install_flag NUMBER(11),
  price1 NUMBER,
  price2 NUMBER,
  price3 NUMBER,
  price4 NUMBER,
  price5 NUMBER,
  price6 NUMBER,
  price7 NUMBER,
  price8 NUMBER,
  price9 NUMBER,
  price10 NUMBER,
  curr_code NVARCHAR2(32),
  valid_from DATE,
  valid_to DATE,
  price_status NVARCHAR2(32),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN pri_main_price_row.id IS '记录唯一ID';
COMMENT ON COLUMN pri_main_price_row.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN pri_main_price_row.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN pri_main_price_row.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN pri_main_price_row.ou_id IS 'OU公司ID';
COMMENT ON COLUMN pri_main_price_row.ou_code IS 'OU公司编号';
COMMENT ON COLUMN pri_main_price_row.ou_name IS 'OU公司名称';
COMMENT ON COLUMN pri_main_price_row.bu_id IS 'BU组织ID';
COMMENT ON COLUMN pri_main_price_row.bu_code IS 'BU组织编号';
COMMENT ON COLUMN pri_main_price_row.bu_name IS 'BU组织名称';
COMMENT ON COLUMN pri_main_price_row.item_id IS '商品ID';
COMMENT ON COLUMN pri_main_price_row.item_code IS '品项编号';
COMMENT ON COLUMN pri_main_price_row.item_code2 IS '第二编号';
COMMENT ON COLUMN pri_main_price_row.item_code3 IS '第三编号';
COMMENT ON COLUMN pri_main_price_row.item_name IS '品项名称';
COMMENT ON COLUMN pri_main_price_row.item_name2 IS '第二名称';
COMMENT ON COLUMN pri_main_price_row.item_name3 IS '第三名称';
COMMENT ON COLUMN pri_main_price_row.spu_id IS 'SPU_ID';
COMMENT ON COLUMN pri_main_price_row.spu_code IS 'SPU_CODE';
COMMENT ON COLUMN pri_main_price_row.spu_code2 IS 'SPU_CODE2';
COMMENT ON COLUMN pri_main_price_row.spu_code3 IS 'SPU_CODE3';
COMMENT ON COLUMN pri_main_price_row.spu_name IS 'SPU_NAME';
COMMENT ON COLUMN pri_main_price_row.spu_name2 IS 'SPU_NAME2';
COMMENT ON COLUMN pri_main_price_row.spu_name3 IS 'SPU_NAME3';
COMMENT ON COLUMN pri_main_price_row.spec IS '一般规格，比如：食品净含量';
COMMENT ON COLUMN pri_main_price_row.item_cate_code IS '品类编码';
COMMENT ON COLUMN pri_main_price_row.uom IS '单位';
COMMENT ON COLUMN pri_main_price_row.price_type IS '价格类型';
COMMENT ON COLUMN pri_main_price_row.tax_code IS '税码';
COMMENT ON COLUMN pri_main_price_row.tax_rate_no IS '税率编号';
COMMENT ON COLUMN pri_main_price_row.tax_rate IS '税率';
COMMENT ON COLUMN pri_main_price_row.install_flag IS '是否含税';
COMMENT ON COLUMN pri_main_price_row.price1 IS '市场价';
COMMENT ON COLUMN pri_main_price_row.price2 IS 'B端指导价';
COMMENT ON COLUMN pri_main_price_row.price3 IS 'C端零售价';
COMMENT ON COLUMN pri_main_price_row.price4 IS 'B端毛利控制率';
COMMENT ON COLUMN pri_main_price_row.price5 IS 'C端毛利控制率';
COMMENT ON COLUMN pri_main_price_row.price6 IS 'B端毛利率';
COMMENT ON COLUMN pri_main_price_row.price7 IS 'C端毛利率';
COMMENT ON COLUMN pri_main_price_row.price8 IS '采购价';
COMMENT ON COLUMN pri_main_price_row.price9 IS '价格9';
COMMENT ON COLUMN pri_main_price_row.price10 IS '价格10';
COMMENT ON COLUMN pri_main_price_row.curr_code IS '币种';
COMMENT ON COLUMN pri_main_price_row.valid_from IS '生效时间';
COMMENT ON COLUMN pri_main_price_row.valid_to IS '失效时间';
COMMENT ON COLUMN pri_main_price_row.price_status IS '状态';
COMMENT ON COLUMN pri_main_price_row.tenant_id IS '租户ID';
COMMENT ON COLUMN pri_main_price_row.remark IS '备注';
COMMENT ON COLUMN pri_main_price_row.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN pri_main_price_row.creator IS '记录创建者';
COMMENT ON COLUMN pri_main_price_row.create_time IS '记录创建时间';
COMMENT ON COLUMN pri_main_price_row.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN pri_main_price_row.updater IS '记录最后更新者';
COMMENT ON COLUMN pri_main_price_row.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN pri_main_price_row.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN pri_main_price_row.audit_data_version IS '锁版本';
COMMENT ON TABLE pri_main_price_row IS '商品主档价格列表';



-- ----------------------------
-- Table structure for sys_dp
-- ----------------------------
CREATE TABLE sys_dp (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  domain_code NVARCHAR2(64),
  domain_code_name NVARCHAR2(64),
  table_code NVARCHAR2(64),
  table_name NVARCHAR2(64),
  table_desc NVARCHAR2(64),
  dp_type NVARCHAR2(64),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN sys_dp.id IS '记录唯一ID';
COMMENT ON COLUMN sys_dp.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN sys_dp.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN sys_dp.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN sys_dp.domain_code IS '领域编号';
COMMENT ON COLUMN sys_dp.domain_code_name IS '领域名称';
COMMENT ON COLUMN sys_dp.table_code IS '表名编码';
COMMENT ON COLUMN sys_dp.table_name IS '表名中文';
COMMENT ON COLUMN sys_dp.table_desc IS '表说明';
COMMENT ON COLUMN sys_dp.dp_type IS '数据权限类型';
COMMENT ON COLUMN sys_dp.tenant_id IS '租户ID';
COMMENT ON COLUMN sys_dp.remark IS '备注';
COMMENT ON COLUMN sys_dp.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN sys_dp.creator IS '记录创建者';
COMMENT ON COLUMN sys_dp.create_time IS '记录创建时间';
COMMENT ON COLUMN sys_dp.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN sys_dp.updater IS '记录最后更新者';
COMMENT ON COLUMN sys_dp.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN sys_dp.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN sys_dp.audit_data_version IS '锁版本';
COMMENT ON TABLE sys_dp IS '数据权限开关';

-- ----------------------------
-- Records of sys_dp
-- ----------------------------



-- ----------------------------
-- Table structure for sys_dp_role
-- ----------------------------
CREATE TABLE sys_dp_role (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  dp_role_code NVARCHAR2(64),
  dp_role_name NVARCHAR2(64),
  bu_tree_id NUMBER(20),
  enable NUMBER(11),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN sys_dp_role.id IS '记录唯一ID';
COMMENT ON COLUMN sys_dp_role.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN sys_dp_role.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN sys_dp_role.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN sys_dp_role.dp_role_code IS '数据权限编码';
COMMENT ON COLUMN sys_dp_role.dp_role_name IS '数据权限名称';
COMMENT ON COLUMN sys_dp_role.bu_tree_id IS '组织树ID';
COMMENT ON COLUMN sys_dp_role.enable IS '是否启用';
COMMENT ON COLUMN sys_dp_role.tenant_id IS '租户ID';
COMMENT ON COLUMN sys_dp_role.remark IS '备注';
COMMENT ON COLUMN sys_dp_role.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN sys_dp_role.creator IS '记录创建者';
COMMENT ON COLUMN sys_dp_role.create_time IS '记录创建时间';
COMMENT ON COLUMN sys_dp_role.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN sys_dp_role.updater IS '记录最后更新者';
COMMENT ON COLUMN sys_dp_role.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN sys_dp_role.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN sys_dp_role.audit_data_version IS '锁版本';
COMMENT ON TABLE sys_dp_role IS '数据权限表';

-- ----------------------------
-- Records of sys_dp_role
-- ----------------------------



-- ----------------------------
-- Table structure for sys_dp_role_power
-- ----------------------------
CREATE TABLE sys_dp_role_power (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  dp_role_code NVARCHAR2(64),
  bu_tree_id NUMBER(20),
  bu_id NUMBER(20),
  bu_tree_d_id NUMBER(20),
  ac_type NVARCHAR2(16),
  inherit_type NVARCHAR2(16),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN sys_dp_role_power.id IS '记录唯一ID';
COMMENT ON COLUMN sys_dp_role_power.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN sys_dp_role_power.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN sys_dp_role_power.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN sys_dp_role_power.dp_role_code IS '数据权限编码';
COMMENT ON COLUMN sys_dp_role_power.bu_tree_id IS '组织树ID';
COMMENT ON COLUMN sys_dp_role_power.bu_id IS '组织ID';
COMMENT ON COLUMN sys_dp_role_power.bu_tree_d_id IS '组织树节点ID';
COMMENT ON COLUMN sys_dp_role_power.ac_type IS '访问控制类型 [UDC]USR:AC_TYPE';
COMMENT ON COLUMN sys_dp_role_power.inherit_type IS '继承类型 [UDC]USR:INHERIT_TYPE';
COMMENT ON COLUMN sys_dp_role_power.tenant_id IS '租户ID';
COMMENT ON COLUMN sys_dp_role_power.remark IS '备注';
COMMENT ON COLUMN sys_dp_role_power.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN sys_dp_role_power.creator IS '记录创建者';
COMMENT ON COLUMN sys_dp_role_power.create_time IS '记录创建时间';
COMMENT ON COLUMN sys_dp_role_power.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN sys_dp_role_power.updater IS '记录最后更新者';
COMMENT ON COLUMN sys_dp_role_power.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN sys_dp_role_power.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN sys_dp_role_power.audit_data_version IS '锁版本';
COMMENT ON TABLE sys_dp_role_power IS '数据权限明细表';

-- ----------------------------
-- Table structure for table_column_extensions
-- ----------------------------
CREATE TABLE table_column_extensions (
  id NUMBER(20) NOT NULL,
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  table_name NVARCHAR2(40),
  column_name NVARCHAR2(40),
  row_id NUMBER(20),
  row_code NVARCHAR2(40),
  sort_no NUMBER(11),
  column_value NVARCHAR2(255),
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11)
)
;
COMMENT ON COLUMN table_column_extensions.id IS '记录唯一ID';
COMMENT ON COLUMN table_column_extensions.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN table_column_extensions.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN table_column_extensions.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN table_column_extensions.table_name IS '被扩展表名称';
COMMENT ON COLUMN table_column_extensions.column_name IS '被扩展列名';
COMMENT ON COLUMN table_column_extensions.row_id IS '关联行ID';
COMMENT ON COLUMN table_column_extensions.row_code IS '关联行编号';
COMMENT ON COLUMN table_column_extensions.sort_no IS '排序号';
COMMENT ON COLUMN table_column_extensions.column_value IS '扩展列值';
COMMENT ON COLUMN table_column_extensions.tenant_id IS '租户ID';
COMMENT ON COLUMN table_column_extensions.remark IS '备注';
COMMENT ON COLUMN table_column_extensions.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN table_column_extensions.creator IS '记录创建者';
COMMENT ON COLUMN table_column_extensions.create_time IS '记录创建时间';
COMMENT ON COLUMN table_column_extensions.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN table_column_extensions.updater IS '记录最后更新者';
COMMENT ON COLUMN table_column_extensions.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN table_column_extensions.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN table_column_extensions.audit_data_version IS '锁版本';
COMMENT ON TABLE table_column_extensions IS '表字段扩展';

-- ----------------------------
-- Table structure for yst_itm_item
-- ----------------------------
CREATE TABLE yst_itm_item (
  id NUMBER(20) NOT NULL,
  tenant_id NUMBER(20),
  remark NVARCHAR2(255),
  create_user_id NUMBER(20),
  creator NVARCHAR2(255),
  create_time DATE,
  modify_user_id NUMBER(20),
  updater NVARCHAR2(255),
  modify_time DATE,
  delete_flag NUMBER(11) NOT NULL,
  audit_data_version NUMBER(11),
  sec_bu_id NUMBER(20),
  sec_user_id NUMBER(20),
  sec_ou_id NUMBER(20),
  ou_id NUMBER(20),
  item_code NVARCHAR2(100),
  item_code2 NVARCHAR2(40),
  item_code3 NVARCHAR2(40),
  item_code4 NVARCHAR2(40),
  item_cate_code NVARCHAR2(40),
  price_period NVARCHAR2(40) NOT NULL,
  usage_desc NVARCHAR2(40),
  purchaser_Name NVARCHAR2(40),
  bu_code NVARCHAR2(40),
  uom NVARCHAR2(40),
  spec NVARCHAR2(40),
  item_status NVARCHAR2(40),
  item_name NVARCHAR2(40),
  approve_status NVARCHAR2(40),
  positivedate DATE,
  min_qty NUMBER,
  price NUMBER,
  tax_rate NUMBER,
  proc_inst_id NVARCHAR2(255),
  proc_inst_status NVARCHAR2(255),
  submit_time DATE,
  approved_time DATE
)
;
COMMENT ON COLUMN yst_itm_item.id IS '记录唯一ID';
COMMENT ON COLUMN yst_itm_item.tenant_id IS '租户ID';
COMMENT ON COLUMN yst_itm_item.remark IS '备注';
COMMENT ON COLUMN yst_itm_item.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN yst_itm_item.creator IS '记录创建者';
COMMENT ON COLUMN yst_itm_item.create_time IS '记录创建时间';
COMMENT ON COLUMN yst_itm_item.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN yst_itm_item.updater IS '记录最后更新者';
COMMENT ON COLUMN yst_itm_item.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN yst_itm_item.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN yst_itm_item.audit_data_version IS '锁版本';
COMMENT ON COLUMN yst_itm_item.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN yst_itm_item.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN yst_itm_item.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN yst_itm_item.ou_id IS '公司ID';
COMMENT ON COLUMN yst_itm_item.item_code IS '品项编号';
COMMENT ON COLUMN yst_itm_item.item_code2 IS '第二编号';
COMMENT ON COLUMN yst_itm_item.item_code3 IS '项目号
';
COMMENT ON COLUMN yst_itm_item.item_code4 IS '临时编码：
';
COMMENT ON COLUMN yst_itm_item.item_cate_code IS '物料类别';
COMMENT ON COLUMN yst_itm_item.price_period IS '询价周期(月)';
COMMENT ON COLUMN yst_itm_item.usage_desc IS '采购用途';
COMMENT ON COLUMN yst_itm_item.purchaser_Name IS '采购员';
COMMENT ON COLUMN yst_itm_item.bu_code IS '组织部门';
COMMENT ON COLUMN yst_itm_item.uom IS '主计量单位';
COMMENT ON COLUMN yst_itm_item.spec IS '规格型号';
COMMENT ON COLUMN yst_itm_item.item_status IS '物料状态';
COMMENT ON COLUMN yst_itm_item.item_name IS '物料名称
';
COMMENT ON COLUMN yst_itm_item.approve_status IS '审批状态';
COMMENT ON COLUMN yst_itm_item.positivedate IS '转正时间
';
COMMENT ON COLUMN yst_itm_item.min_qty IS '最小订货数量';
COMMENT ON COLUMN yst_itm_item.price IS ' 含税单价';
COMMENT ON COLUMN yst_itm_item.tax_rate IS ' 税率';
COMMENT ON COLUMN yst_itm_item.proc_inst_id IS '流程实例ID';
COMMENT ON COLUMN yst_itm_item.proc_inst_status IS '流程实例状态';
COMMENT ON COLUMN yst_itm_item.submit_time IS '提交时间';
COMMENT ON COLUMN yst_itm_item.approved_time IS '审批通过时间';
COMMENT ON TABLE yst_itm_item IS 'demo表';

-- ----------------------------
-- Primary Key structure for table com_city_code
-- ----------------------------
ALTER TABLE com_city_code ADD PRIMARY KEY (id);

-- -- ----------------------------
-- -- Primary Key structure for table com_city_code_copy1
-- -- ----------------------------
-- ALTER TABLE com_city_code_copy1 ADD PRIMARY KEY (id);
--
-- -- ----------------------------
-- -- Indexes structure for table com_city_code_copy1
-- -- ----------------------------
-- CREATE UNIQUE INDEX uk_area_area_code
--   ON com_city_code_copy1 (area_code);
-- CREATE INDEX idx_area_pid
--   ON com_city_code_copy1 (pid);
-- CREATE INDEX idx_area_area_name
--   ON com_city_code_copy1 (area_name);
-- CREATE INDEX sec_bu_id_index
--   ON com_city_code_copy1 (sec_bu_id);
-- CREATE INDEX sec_user_id_index
--   ON com_city_code_copy1 (sec_user_id);
-- CREATE INDEX sec_ou_id_index
--   ON com_city_code_copy1 (sec_ou_id);
-- CREATE INDEX create_user_id_index
--   ON com_city_code_copy1 (create_user_id);

-- ----------------------------
-- Primary Key structure for table com_currency
-- ----------------------------
ALTER TABLE com_currency ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table com_file
-- ----------------------------
ALTER TABLE com_file ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table common_org_bu_treed
-- ----------------------------
ALTER TABLE common_org_bu_treed ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table common_org_emp
-- ----------------------------
ALTER TABLE common_org_emp ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table cpcnt_attach
-- ----------------------------
ALTER TABLE cpcnt_attach ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table cpcnt_bank
-- ----------------------------
ALTER TABLE cpcnt_bank ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table cpcnt_category
-- ----------------------------
ALTER TABLE cpcnt_category ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table cpcnt_district
-- ----------------------------
ALTER TABLE cpcnt_district ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table cpcnt_image
-- ----------------------------
ALTER TABLE cpcnt_image ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table cpcnt_incoming_parts
-- ----------------------------
ALTER TABLE cpcnt_incoming_parts ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table cpcnt_industry
-- ----------------------------
ALTER TABLE cpcnt_industry ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table cpcnt_industry_type
-- ----------------------------
ALTER TABLE cpcnt_industry_type ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table cpcnt_merchant
-- ----------------------------
ALTER TABLE cpcnt_merchant ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table cpcnt_province
-- ----------------------------
ALTER TABLE cpcnt_province ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table cpcnt_request
-- ----------------------------
ALTER TABLE cpcnt_request ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table cpcnt_response
-- ----------------------------
ALTER TABLE cpcnt_response ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_brand
-- ----------------------------
ALTER TABLE itm_brand ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_cate_contr_para
-- ----------------------------
ALTER TABLE itm_cate_contr_para ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_cate_prop
-- ----------------------------
ALTER TABLE itm_cate_prop ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_cate_prop_value
-- ----------------------------
ALTER TABLE itm_cate_prop_value ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_combo_d
-- ----------------------------
ALTER TABLE itm_combo_d ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_combo_tag
-- ----------------------------
ALTER TABLE itm_combo_tag ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item
-- ----------------------------
ALTER TABLE itm_item ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_apply
-- ----------------------------
ALTER TABLE itm_item_apply ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_applyd
-- ----------------------------
ALTER TABLE itm_item_applyd ADD PRIMARY KEY (id);

-- ----------------------------
-- Indexes structure for table itm_item_applyd
-- ----------------------------
CREATE INDEX idx_spu_id
  ON itm_item_applyd (spu_id);

-- ----------------------------
-- Primary Key structure for table itm_item_attachment
-- ----------------------------
ALTER TABLE itm_item_attachment ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_attachment_applyd
-- ----------------------------
ALTER TABLE itm_item_attachment_applyd ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_bom
-- ----------------------------
ALTER TABLE itm_item_bom ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_business
-- ----------------------------
ALTER TABLE itm_item_business ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_cate
-- ----------------------------
ALTER TABLE itm_item_cate ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_combo
-- ----------------------------
ALTER TABLE itm_item_combo ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_cust_prop
-- ----------------------------
ALTER TABLE itm_item_cust_prop ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_cust_prop_applyd
-- ----------------------------
ALTER TABLE itm_item_cust_prop_applyd ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_prop
-- ----------------------------
ALTER TABLE itm_item_prop ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_prop_applyd
-- ----------------------------
ALTER TABLE itm_item_prop_applyd ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_publish
-- ----------------------------
ALTER TABLE itm_item_publish ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_qualify
-- ----------------------------
ALTER TABLE itm_item_qualify ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_qualify_applyd
-- ----------------------------
ALTER TABLE itm_item_qualify_applyd ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_sku_business
-- ----------------------------
ALTER TABLE itm_item_sku_business ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_status_config
-- ----------------------------
ALTER TABLE itm_item_status_config ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_tag
-- ----------------------------
ALTER TABLE itm_item_tag ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_item_tag_applyd
-- ----------------------------
ALTER TABLE itm_item_tag_applyd ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_itemuom_conv
-- ----------------------------
ALTER TABLE itm_itemuom_conv ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_itemuom_conv_applyd
-- ----------------------------
ALTER TABLE itm_itemuom_conv_applyd ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_life_status_scheduling
-- ----------------------------
ALTER TABLE itm_life_status_scheduling ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_prop
-- ----------------------------
ALTER TABLE itm_prop ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table itm_tag
-- ----------------------------
ALTER TABLE itm_tag ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table org_addr
-- ----------------------------
ALTER TABLE org_addr ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table org_addr_address
-- ----------------------------
ALTER TABLE org_addr_address ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table org_addr_bank_acc
-- ----------------------------
ALTER TABLE org_addr_bank_acc ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table org_addr_qualify
-- ----------------------------
ALTER TABLE org_addr_qualify ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table org_area
-- ----------------------------
ALTER TABLE org_area ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table org_bg_bu
-- ----------------------------
ALTER TABLE org_bg_bu ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table org_bu
-- ----------------------------
ALTER TABLE org_bu ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table org_bu_ref
-- ----------------------------
ALTER TABLE org_bu_ref ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table org_bu_tree
-- ----------------------------
ALTER TABLE org_bu_tree ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table org_bu_tree_d
-- ----------------------------
ALTER TABLE org_bu_tree_d ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table org_bu_tree_version
-- ----------------------------
ALTER TABLE org_bu_tree_version ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table org_emp
-- ----------------------------
ALTER TABLE org_emp ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table org_emp_bu
-- ----------------------------
ALTER TABLE org_emp_bu ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table org_ou
-- ----------------------------
ALTER TABLE org_ou ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table org_store
-- ----------------------------
ALTER TABLE org_store ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table pri_main_price_alter
-- ----------------------------
ALTER TABLE pri_main_price_alter ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table pri_main_price_alter_d_row
-- ----------------------------
ALTER TABLE pri_main_price_alter_d_row ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table pri_main_price_row
-- ----------------------------
ALTER TABLE pri_main_price_row ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table sys_dp
-- ----------------------------
ALTER TABLE sys_dp ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table sys_dp_role
-- ----------------------------
ALTER TABLE sys_dp_role ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table sys_dp_role_power
-- ----------------------------
ALTER TABLE sys_dp_role_power ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table table_column_extensions
-- ----------------------------
ALTER TABLE table_column_extensions ADD PRIMARY KEY (id);

-- ----------------------------
-- Primary Key structure for table yst_itm_item
-- ----------------------------
ALTER TABLE yst_itm_item ADD PRIMARY KEY (id);